/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.visualization.actions;

import com.intellij.dataspell.charteditor.DSChartEditorKt;
import com.intellij.dataspell.charteditor.VegaLiteConverterKt;
import com.intellij.dataspell.jupyter.customCells.visualization.VisualizationCellMetadata;
import com.intellij.dataspell.jupyter.customCells.visualization.VisualizationCellMetadataKt;
import com.intellij.dataspell.jupyter.customCells.visualization.VisualizationCellsBundle;
import com.intellij.dataspell.jupyter.customCells.visualization.run.JupyterVisualizationCellBuilderKt;
import com.intellij.jupyter.core.jupyter.actions.ActionDestination;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterActionHelper;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellSelectionModel;
import com.intellij.notebooks.visualization.NotebookCellSelectionModelProviderKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/visualization/actions/ReplaceVisualizationAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "cell", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;", "jupyterFileEditor", "Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;", "selectedOrdinal", "", "<init>", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterCell;Lcom/intellij/jupyter/core/jupyter/editor/JupyterFileEditor;Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.dataspell.jupyter.customCells.visualization"})
@SourceDebugExtension(value={"SMAP\nChartEditorVisualizationCellAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartEditorVisualizationCellAction.kt\ncom/intellij/dataspell/jupyter/customCells/visualization/actions/ReplaceVisualizationAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n57#2:231\n35#2,2:232\n57#2:234\n35#2,2:235\n57#2:239\n35#2,2:240\n295#3,2:237\n*S KotlinDebug\n*F\n+ 1 ChartEditorVisualizationCellAction.kt\ncom/intellij/dataspell/jupyter/customCells/visualization/actions/ReplaceVisualizationAction\n*L\n179#1:231\n179#1:232,2\n184#1:234\n184#1:235,2\n226#1:239\n226#1:240,2\n208#1:237,2\n*E\n"})
final class ReplaceVisualizationAction
extends DumbAwareAction {
    @NotNull
    private final JupyterCell cell;
    @NotNull
    private final JupyterFileEditor jupyterFileEditor;
    @Nullable
    private final Integer selectedOrdinal;

    public ReplaceVisualizationAction(@NotNull JupyterCell cell, @NotNull JupyterFileEditor jupyterFileEditor, @Nullable Integer selectedOrdinal) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        Intrinsics.checkNotNullParameter((Object)jupyterFileEditor, (String)"jupyterFileEditor");
        super(VisualizationCellsBundle.message("action.replace.visualization.text", new Object[0]));
        this.cell = cell;
        this.jupyterFileEditor = jupyterFileEditor;
        this.selectedOrdinal = selectedOrdinal;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block9: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            DataKey dataKey = DSChartEditorKt.getCHART_EDITOR_VEGA_SPEC_JSON();
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            JsonObject specJson = (JsonObject)dataKey.getData(dataContext);
            Map map = (Map)specJson;
            if (map == null || map.isEmpty()) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("[ReplaceVisualizationAction] No Vega spec JSON found in DataContext");
                return;
            }
            DataKey dataKey2 = DSChartEditorKt.getCHART_EDITOR_DATA();
            DataContext dataContext2 = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
            List data = (List)dataKey2.getData(dataContext2);
            Collection $i$f$currentClassLogger = data;
            if ($i$f$currentClassLogger == null || $i$f$currentClassLogger.isEmpty()) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger2 = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("[ReplaceVisualizationAction] No data values found in DataContext");
                return;
            }
            String vegaSpecWithData = DSChartEditorKt.prettyPrint((JsonElement)((JsonElement)VegaLiteConverterKt.withVegaData((JsonObject)specJson, (List)data)));
            WriteAction.run(() -> ReplaceVisualizationAction.actionPerformed$lambda$0(this, vegaSpecWithData));
            VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                FileEditorManager.getInstance((Project)project2).closeFile(it);
            }
            try {
                Object v10;
                EditorImpl editorImpl;
                block10: {
                    Editor clazz$iv$iv = this.jupyterFileEditor.getEditor();
                    EditorImpl editorImpl2 = editorImpl = clazz$iv$iv instanceof EditorImpl ? (EditorImpl)clazz$iv$iv : null;
                    if (editorImpl == null) break block9;
                    List intervals = NotebookCellLines.Companion.get((Editor)editorImpl).getIntervals();
                    Iterable $this$firstOrNull$iv = intervals;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
                        boolean bl = false;
                        Integer n = this.selectedOrdinal;
                        if (!(n != null && it.getOrdinal() == n.intValue())) continue;
                        v10 = element$iv;
                        break block10;
                    }
                    v10 = null;
                }
                NotebookCellLines.Interval interval = v10;
                NotebookCellSelectionModel selectionModel = NotebookCellSelectionModelProviderKt.getCellSelectionModel((Editor)((Editor)editorImpl));
                if (interval != null && selectionModel != null) {
                    JupyterActionHelper.INSTANCE.selectAndFocusFullCell(selectionModel, interval, editorImpl, ActionDestination.DOWN);
                } else {
                    BuildersKt.launch$default((CoroutineScope)CoroutinesKt.currentThreadCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project2, null){
                        int label;
                        final /* synthetic */ ReplaceVisualizationAction this$0;
                        final /* synthetic */ Project $project;
                        {
                            this.this$0 = $receiver;
                            this.$project = $project;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    Object object2 = JupyterVisualizationCellBuilderKt.updateVisualizationCell(ReplaceVisualizationAction.access$getCell$p(this.this$0), this.$project, (Continuation<? super Unit>)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)3, null);
                }
            }
            catch (Throwable t) {
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger3 = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("[ReplaceVisualizationAction] Failed to focus back the visualization cell", t);
            }
        }
    }

    private static final void actionPerformed$lambda$0(ReplaceVisualizationAction this$0, String $vegaSpecWithData) {
        VisualizationCellMetadata visualizationCellMetadata = VisualizationCellMetadataKt.getVisualizationMetadata(this$0.cell);
        String variableName = visualizationCellMetadata != null ? visualizationCellMetadata.getVariableName() : null;
        VisualizationCellMetadataKt.setVisualizationMetadata(this$0.cell, new VisualizationCellMetadata($vegaSpecWithData, variableName));
    }

    public static final /* synthetic */ JupyterCell access$getCell$p(ReplaceVisualizationAction $this) {
        return $this.cell;
    }
}

