/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataspell.jupyter.customCells.data.input;

import com.intellij.dataspell.jupyter.customCells.JupyterCustomCellsBundle;
import com.intellij.dataspell.jupyter.customCells.data.input.JupyterXlsDropHandlerKt;
import com.intellij.dataspell.jupyter.customCells.data.input.PythonDataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.DataframeVariableNameSuggester;
import com.intellij.jupyter.core.editor.handlers.LanguageTableDataFileDropHandler;
import com.intellij.jupyter.core.editor.handlers.TableDataFileDropHandlerContext;
import com.intellij.lang.Language;
import com.jetbrains.python.PythonLanguage;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/dataspell/jupyter/customCells/data/input/JupyterXmlDropHandler;", "Lcom/intellij/jupyter/core/editor/handlers/LanguageTableDataFileDropHandler;", "<init>", "()V", "nameSuggester", "Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "getNameSuggester", "()Lcom/intellij/jupyter/core/editor/handlers/DataframeVariableNameSuggester;", "generateCellCode", "", "context", "Lcom/intellij/jupyter/core/editor/handlers/TableDataFileDropHandlerContext;", "intellij.dataspell.jupyter.customCells"})
public final class JupyterXmlDropHandler
extends LanguageTableDataFileDropHandler {
    public JupyterXmlDropHandler() {
        PythonLanguage pythonLanguage = PythonLanguage.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)pythonLanguage, (String)"getInstance(...)");
        super((Language)pythonLanguage, JupyterCustomCellsBundle.message("jupyter.drop.xml.command", new Object[0]), SetsKt.setOf((Object)"xml"));
    }

    @NotNull
    public DataframeVariableNameSuggester getNameSuggester() {
        return PythonDataframeVariableNameSuggester.INSTANCE;
    }

    @NotNull
    public String generateCellCode(@NotNull TableDataFileDropHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String jsonPath = context.resolveFilePath();
        String string = context.getDataframeName();
        if (string == null) {
            string = this.getNameSuggester().createDataframeName(context.getProjectOrNull(), context.getDataFileNameWithoutExtension());
        }
        String dfName = string;
        return StringsKt.trimIndent((String)("\n      import pandas as pd\n      " + dfName + " = pd.read_xml(" + JupyterXlsDropHandlerKt.pyStr(jsonPath) + ")\n      " + dfName + "\n    "));
    }
}

