/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.remote.ui;

import com.intellij.jupyter.core.jupyter.JupyterRemoteBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteDirectoryNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteFileNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteLoadingNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteNode;
import com.intellij.jupyter.core.jupyter.remote.projectView.node.JupyterRemoteNotLoadedNode;
import com.intellij.jupyter.core.jupyter.remote.vfs.JupyterRemoteFileSystem;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001)B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\"\u0010\u0006\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0014J\b\u0010\u001b\u001a\u00020\nH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\b\u0010\u001f\u001a\u00020\nH\u0014J\u001a\u0010 \u001a\u000f\u0012\u000b\u0012\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00160!H\u0014\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0014J\u0006\u0010%\u001a\u00020\nJ\b\u0010&\u001a\u00020\nH\u0014J\b\u0010'\u001a\u00020$H\u0014J\b\u0010(\u001a\u00020\bH\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0006\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0012*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0015\u001a\u00070\b\u00a2\u0006\u0002\b\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRemoteFileRenameDialog;", "Lcom/intellij/refactoring/ui/RefactoringDialog;", "project", "Lcom/intellij/openapi/project/Project;", "node", "Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteNode;", "callback", "Lkotlin/Function2;", "", "Lkotlin/coroutines/Continuation;", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/jupyter/remote/projectView/node/JupyterRemoteNode;Lkotlin/jvm/functions/Function2;)V", "Lkotlin/jvm/functions/Function2;", "renameAction", "Ljavax/swing/Action;", "oldName", "kotlin.jvm.PlatformType", "inputText", "Lcom/intellij/ui/EditorTextField;", "newName", "Lorg/jetbrains/annotations/NotNull;", "getNewName", "()Ljava/lang/String;", "createCenterPanel", "", "doAction", "createNorthPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "createDefaultActions", "createActions", "", "()[Ljavax/swing/Action;", "hasHelpAction", "", "doRenameAction", "validateButtons", "areButtonsValid", "getTitleText", "RenameAction", "intellij.jupyter.core"})
public final class JupyterRemoteFileRenameDialog
extends RefactoringDialog {
    @NotNull
    private final JupyterRemoteNode node;
    @NotNull
    private final Function2<String, Continuation<? super Unit>, Object> callback;
    @Nullable
    private Action renameAction;
    private final String oldName;
    @NotNull
    private final EditorTextField inputText;

    /*
     * WARNING - void declaration
     */
    public JupyterRemoteFileRenameDialog(@NotNull Project project, @NotNull JupyterRemoteNode node, @NotNull Function2<? super String, ? super Continuation<? super Unit>, ? extends Object> callback2) {
        Editor editor;
        void $this$inputText_u24lambda_u240;
        EditorTextField editorTextField;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        super(project, false);
        this.node = node;
        this.callback = callback2;
        this.oldName = (String)this.node.getValue();
        EditorTextField editorTextField2 = editorTextField = new EditorTextField(this.oldName);
        JupyterRemoteFileRenameDialog jupyterRemoteFileRenameDialog = this;
        boolean bl = false;
        $this$inputText_u24lambda_u240.addDocumentListener(new DocumentListener(this){
            final /* synthetic */ JupyterRemoteFileRenameDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.validateButtons();
            }
        });
        $this$inputText_u24lambda_u240.addNotify();
        String string = this.oldName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"oldName");
        int extensionOffset = StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null).length();
        Editor editor2 = $this$inputText_u24lambda_u240.getEditor();
        if (editor2 != null && (editor2 = editor2.getSelectionModel()) != null) {
            editor2.setSelection(0, extensionOffset);
        }
        if ((editor = $this$inputText_u24lambda_u240.getEditor()) != null && (editor = editor.getCaretModel()) != null) {
            editor.moveToOffset(extensionOffset);
        }
        jupyterRemoteFileRenameDialog.inputText = editorTextField;
        this.setTitle(this.getTitleText());
        this.validateButtons();
        this.init();
    }

    private final String getNewName() {
        String string = this.inputText.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @Nullable
    protected Void createCenterPanel() {
        return null;
    }

    protected void doAction() {
        JupyterCoroutineKt.launchBackground((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ JupyterRemoteFileRenameDialog this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Function2 function2 = JupyterRemoteFileRenameDialog.access$getCallback$p(this.this$0);
                        String string = JupyterRemoteFileRenameDialog.access$getInputText$p(this.this$0).getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                        this.label = 1;
                        Object object2 = function2.invoke((Object)string, (Object)((Object)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.close(0);
    }

    @NotNull
    protected JComponent createNorthPanel() {
        BorderLayoutPanel borderLayoutPanel;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.oldName, (String)"oldName");
        JLabel heading = new JLabel(JupyterRemoteBundle.message("Jupyter.remote.refactoring.renaming.to", objectArray));
        BorderLayoutPanel $this$createNorthPanel_u24lambda_u240 = borderLayoutPanel = new BorderLayoutPanel(0, 8);
        boolean bl = false;
        $this$createNorthPanel_u24lambda_u240.add((Component)heading, (Object)"North");
        $this$createNorthPanel_u24lambda_u240.add((Component)this.inputText, (Object)"Center");
        BorderLayoutPanel panel = borderLayoutPanel;
        return (JComponent)panel;
    }

    @NotNull
    public EditorTextField getPreferredFocusedComponent() {
        return this.inputText;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        this.renameAction = new RenameAction();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction(), this.renameAction};
        return actionArray;
    }

    protected boolean hasHelpAction() {
        return false;
    }

    public final void doRenameAction() {
        this.doAction();
    }

    protected void validateButtons() {
        block0: {
            super.validateButtons();
            Action action = this.renameAction;
            if (action == null) break block0;
            action.setEnabled(this.areButtonsValid());
        }
    }

    protected boolean areButtonsValid() {
        return !Intrinsics.areEqual((Object)this.getNewName(), (Object)this.oldName) && JupyterRemoteFileSystem.Companion.getInstance().isValidName(this.getNewName());
    }

    @NlsContexts.DialogTitle
    @Nls
    private final String getTitleText() {
        String string;
        JupyterRemoteNode jupyterRemoteNode = this.node;
        if (jupyterRemoteNode instanceof JupyterRemoteFileNode) {
            FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            String string2 = ((JupyterRemoteFileNode)this.node).getFileName();
            Intrinsics.checkNotNull((Object)string2);
            string = Intrinsics.areEqual((Object)fileTypeManager.getFileTypeByFileName(string2), (Object)JupyterFileType.INSTANCE) ? JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename.notebook", new Object[0]) : JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename.file", new Object[0]);
        } else if (jupyterRemoteNode instanceof JupyterRemoteDirectoryNode) {
            string = JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename.directory", new Object[0]);
        } else {
            if (jupyterRemoteNode instanceof JupyterRemoteLoadingNode) {
                throw new IllegalStateException("Renaming a loading node.");
            }
            if (jupyterRemoteNode instanceof JupyterRemoteNotLoadedNode) {
                throw new IllegalStateException("Renaming a not inited node.");
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public static final /* synthetic */ Function2 access$getCallback$p(JupyterRemoteFileRenameDialog $this) {
        return $this.callback;
    }

    public static final /* synthetic */ EditorTextField access$getInputText$p(JupyterRemoteFileRenameDialog $this) {
        return $this.inputText;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRemoteFileRenameDialog$RenameAction;", "Ljavax/swing/AbstractAction;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/remote/ui/JupyterRemoteFileRenameDialog;)V", "actionPerformed", "", "e", "Ljava/awt/event/ActionEvent;", "intellij.jupyter.core"})
    public final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            super(JupyterRemoteBundle.message("Jupyter.remote.refactoring.rename", new Object[0]));
            this.putValue("DefaultAction", true);
        }

        @Override
        public void actionPerformed(@Nullable ActionEvent e) {
            JupyterRemoteFileRenameDialog.this.doRenameAction();
        }
    }
}

