/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.CommonBundle;
import com.intellij.aiplayground.ui.chat.ChatViewModel;
import com.intellij.aiplayground.ui.chat.editor.ChatVirtualFile;
import com.intellij.aiplayground.ui.chat.view.ChatView;
import com.intellij.aiplayground.ui.utils.AiPlaygroundCoroutine;
import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016J\r\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u001cH\u0016J%\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H(0*H\u0016\u00a2\u0006\u0002\u0010+J-\u0010,\u001a\u00020\u001c\"\u0004\b\u0000\u0010(2\u000e\u0010)\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H(0*2\b\u0010-\u001a\u0004\u0018\u0001H(H\u0016\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/aiplayground/ui/chat/editor/ChatFileEditor;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "chatFile", "Lcom/intellij/aiplayground/ui/chat/editor/ChatVirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/aiplayground/ui/chat/editor/ChatVirtualFile;)V", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolderBase;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "viewModel", "Lcom/intellij/aiplayground/ui/chat/ChatViewModel;", "getViewModel", "()Lcom/intellij/aiplayground/ui/chat/ChatViewModel;", "myPanel", "Lcom/intellij/aiplayground/ui/chat/view/ChatView;", "createPanel", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getComponent", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getName", "", "Lcom/intellij/openapi/util/NlsContexts$TabTitle;", "setState", "", "state", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "isModified", "", "isValid", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "dispose", "getUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nChatFileEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatFileEditor.kt\ncom/intellij/aiplayground/ui/chat/editor/ChatFileEditor\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,78:1\n42#2,3:79\n*S KotlinDebug\n*F\n+ 1 ChatFileEditor.kt\ncom/intellij/aiplayground/ui/chat/editor/ChatFileEditor\n*L\n28#1:79,3\n*E\n"})
public final class ChatFileEditor
implements FileEditor {
    @NotNull
    private final Project project;
    @NotNull
    private final ChatVirtualFile chatFile;
    @NotNull
    private final UserDataHolderBase userDataHolder;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ChatViewModel viewModel;
    @NotNull
    private final ChatView myPanel;
    public static final int $stable = 8;

    public ChatFileEditor(@NotNull Project project, @NotNull ChatVirtualFile chatFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)chatFile), (String)"chatFile");
        this.project = project;
        this.chatFile = chatFile;
        this.userDataHolder = new UserDataHolderBase();
        boolean $i$f$service = false;
        Class<AiPlaygroundCoroutine> serviceClass$iv = AiPlaygroundCoroutine.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        this.coroutineScope = CoroutineScopeKt.childScope$default((CoroutineScope)((AiPlaygroundCoroutine)object).getCoroutineScope(), (String)"ChatView", null, (boolean)false, (int)6, null);
        this.viewModel = ChatViewModel.Companion.create(this.project, this.coroutineScope, this.chatFile.getChat());
        this.myPanel = this.createPanel(this.viewModel);
    }

    @NotNull
    public final ChatViewModel getViewModel() {
        return this.viewModel;
    }

    private final ChatView createPanel(ChatViewModel viewModel) {
        return new ChatView(this.project, this.coroutineScope, viewModel);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.chatFile;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = CommonBundle.settingsTitle();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"settingsTitle(...)");
        return string;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
    }

    public void dispose() {
        kotlinx.coroutines.CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.userDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.userDataHolder.putUserData(key, value);
    }
}

