/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo;

import com.intellij.database.Dbms;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.lang.DependentLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mongo.MongoSqlTokens;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTokens;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MongoSqlDialect
extends SqlLanguageDialectBase
implements DependentLanguage {
    public static final MongoSqlDialect INSTANCE = new MongoSqlDialect();

    private MongoSqlDialect() {
        super("MongoDB");
    }

    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(MongoSqlTokens.class);
        if (tokensHelper == null) {
            MongoSqlDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.MONGO;
        if (dbms == null) {
            MongoSqlDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MongoSqlDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            MongoSqlDialect.$$$reportNull$$$0(3);
        }
        if (place instanceof SqlReferenceExpression && type == SqlDbElementType.ANY && expectedTypes.contains(ObjectKind.COLUMN)) {
            PsiElement parent = place.getParent();
            while (parent instanceof SqlReferenceExpression) {
                ObjectKind parentKind = ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind();
                if (parentKind == ObjectKind.COLUMN) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        Collection res = super.getParentDbTypes(result, type);
        if (type == ObjectKind.COLUMN) {
            res.add(ObjectKind.COLUMN);
        }
        return (T)res;
    }

    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    public boolean supportsJoinUsing() {
        return true;
    }

    public boolean supportsNestedColumns() {
        return true;
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"double", (String)"double", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"string", (String)"string", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"object", (String)"object", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"array", (String)"array", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"binData", (String)"binData", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"objectId", (String)"objectId", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"bool", (String)"bool", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"date", (String)"date", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"regex", (String)"regex", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"code", (String)"code", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"int", (String)"int", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"timestamp", (String)"timestamp", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"long", (String)"long", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"decimal", (String)"decimal", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"minKey", (String)"minKey", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"maxKey", (String)"maxKey", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, (String)"number", (String)"number", (SqlLanguageDialectEx)this);
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return new SqlCloseBlockProcessorImpl(new SqlCloseBlockProcessorImpl.SubstitutionDescriptor[]{new SubstitutionDescriptorImpl(new IElementType[]{SqlTokens.SQL_BEGIN, SqlCompositeElementTypes.SQL_BLOCK_STATEMENT}, "", "end;", 1, new SubstitutionDescriptorImpl.TailCheck[]{SubstitutionDescriptorImpl.TailCheck.tail((IElementType[])new IElementType[]{SqlTokens.SQL_END, SqlTokens.SQL_SEMICOLON}).mask(new boolean[]{true, false})})});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mongo/MongoSqlDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mongo/MongoSqlDialect";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtilCore.loadSystemVars((SqlLanguageDialect)INSTANCE));
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
        static final TokenSet ourClosingTokens = SqlTokens.STATEMENT_SEPARATORS;

        LazyData() {
        }
    }
}

