/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.vegalite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.UnicodeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.DateTime;
import org.jetbrains.letsPlot.commons.intern.datetime.Instant;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.Time;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.core.spec.OptionsSelectorKt;
import org.jetbrains.letsPlot.vegalite.VegaOption;
import org.jetbrains.letsPlot.vegalite.VegaUtil;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B3\b\u0002\u0012\u001a\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u001c\u0010\u000e\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002R\u0016\u0010\u0006\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0002\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\u0004\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00050\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/vegalite/DataProcessor;", "", "originalData", "", "", "", "encodingVegaSpec", "(Ljava/util/Map;Ljava/util/Map;)V", "updatedFields", "", "adjustSeriesDataTypes", "", "getField", "name", "parseTemporalData", "messageConsumer", "Lkotlin/Function1;", "truncateDateTimeToUnit", "Companion", "lets-plot-vega-lite"})
@SourceDebugExtension(value={"SMAP\nDataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataProcessor.kt\norg/jetbrains/letsPlot/vegalite/DataProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1855#2:197\n1549#2:198\n1620#2,3:199\n1856#2:202\n1855#2:203\n1549#2:204\n1620#2,3:205\n1549#2:208\n1620#2,3:209\n1856#2:212\n1855#2:213\n1549#2:214\n1620#2,3:215\n1856#2:218\n1#3:219\n*S KotlinDebug\n*F\n+ 1 DataProcessor.kt\norg/jetbrains/letsPlot/vegalite/DataProcessor\n*L\n77#1:197\n86#1:198\n86#1:199,3\n77#1:202\n145#1:203\n151#1:204\n151#1:205,3\n159#1:208\n159#1:209,3\n145#1:212\n176#1:213\n181#1:214\n181#1:215,3\n176#1:218\n*E\n"})
public final class DataProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, List<Object>> originalData;
    @NotNull
    private final Map<?, ?> encodingVegaSpec;
    @NotNull
    private Map<String, List<Object>> updatedFields;

    private DataProcessor(Map<String, ? extends List<? extends Object>> originalData, Map<?, ?> encodingVegaSpec) {
        this.originalData = originalData;
        this.encodingVegaSpec = encodingVegaSpec;
        this.updatedFields = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    private final void parseTemporalData(Function1<? super String, Unit> messageConsumer) {
        Iterable $this$forEach$iv = VegaOption.Encoding.INSTANCE.getChannels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List<Object> series;
            String type;
            String channel = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{channel, "field"};
            String string = OptionsSelectorKt.getString(this.encodingVegaSpec, (Object[])objectArray);
            if (string == null || (string = VegaUtil.INSTANCE.unescapeField$lets_plot_vega_lite(string)) == null) continue;
            String field = string;
            Object[] objectArray2 = new Object[]{channel, "type"};
            if (OptionsSelectorKt.getString(this.encodingVegaSpec, (Object[])objectArray2) == null || !Intrinsics.areEqual((Object)type, (Object)"temporal") || this.getField(field) == null) continue;
            List failedValues = new ArrayList();
            Iterable iterable = series;
            boolean $i$f$map = false;
            void var14_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long l;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void var22_22 = it;
                if (var22_22 instanceof Number) {
                    l = ((Number)it).longValue();
                } else if (var22_22 instanceof String) {
                    kotlinx.datetime.Instant instant;
                    kotlinx.datetime.Instant instant2 = DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseInstant$default(this, (String)it, null, 4, null);
                    if (instant2 == null && (instant2 = DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDateTime$default(this, (String)it, null, 4, null)) == null && (instant2 = DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDate$default(this, (String)it, null, 4, null)) == null && (instant2 = DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDateTime(this, (String)it, "yyyy-MM-dd HH:mm:ss")) == null && (instant2 = DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDateTime(this, (String)it, "yyyy/MM/dd HH:mm:ss")) == null) {
                        instant2 = DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDate(this, (String)it, "yyyy/MM/dd");
                    }
                    kotlinx.datetime.Instant instant3 = instant = instant2;
                    if (instant3 != null) {
                        l = instant3.toEpochMilliseconds();
                    } else {
                        DataProcessor $this$parseTemporalData_u24lambda_u248_u24lambda_u247_u24lambda_u246 = this;
                        boolean bl3 = false;
                        ((Collection)failedValues).add(it);
                        l = null;
                    }
                } else {
                    l = null;
                }
                collection.add(l);
            }
            List adjustedSeries2 = (List)destination$iv$iv;
            this.updatedFields.put(field, adjustedSeries2);
            if (!(!((Collection)failedValues).isEmpty())) continue;
            String message = "Failed to parse " + failedValues.size() + " date/time values in field '" + field + "': " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)failedValues, (int)5), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + (failedValues.size() > 5 ? ", ..." : "");
            messageConsumer.invoke((Object)StringsKt.take((String)message, (int)200));
        }
    }

    public final void adjustSeriesDataTypes() {
        Iterable $this$forEach$iv = VegaOption.Encoding.INSTANCE.getChannels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List list;
            String type;
            String channel = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{channel, "field"};
            String string = OptionsSelectorKt.getString(this.encodingVegaSpec, (Object[])objectArray);
            if (string == null || (string = VegaUtil.INSTANCE.unescapeField$lets_plot_vega_lite(string)) == null) continue;
            String field = string;
            Object[] objectArray2 = new Object[]{channel, "type"};
            if (OptionsSelectorKt.getString(this.encodingVegaSpec, (Object[])objectArray2) == null || this.getField(field) == null) continue;
            String string2 = type;
            if (Intrinsics.areEqual((Object)string2, (Object)"quantitative")) {
                $this$map$iv = series;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var17_17 = $this$mapTo$iv$iv.iterator();
                while (var17_17.hasNext()) {
                    Object t = item$iv$iv = var17_17.next();
                    var20_20 = destination$iv$iv;
                    boolean bl2 = false;
                    var22_22 = it;
                    var20_20.add(var22_22 instanceof Number ? Double.valueOf(((Number)it).doubleValue()) : (var22_22 instanceof String ? StringsKt.toDoubleOrNull((String)((String)it)) : null));
                }
                list = (List)destination$iv$iv;
            } else if (Intrinsics.areEqual((Object)string2, (Object)"temporal")) {
                $this$map$iv = series;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                var17_17 = $this$mapTo$iv$iv.iterator();
                while (var17_17.hasNext()) {
                    Long l;
                    it = item$iv$iv = var17_17.next();
                    var20_20 = destination$iv$iv;
                    boolean bl3 = false;
                    var22_22 = it;
                    if (var22_22 instanceof Number) {
                        l = ((Number)it).longValue();
                    } else if (var22_22 instanceof String) {
                        l = StringsKt.toLongOrNull((String)((String)it));
                        if (l == null) {
                            l = it;
                        }
                    } else {
                        l = null;
                    }
                    var20_20.add(l);
                }
                list = (List)destination$iv$iv;
            } else {
                list = series;
            }
            List adjustedSeries2 = list;
            this.updatedFields.put(field, adjustedSeries2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void truncateDateTimeToUnit() {
        Iterable $this$forEach$iv = VegaOption.Encoding.INSTANCE.getChannels();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            List<Object> timeSeries;
            String channel = (String)element$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{channel, "field"};
            String string = OptionsSelectorKt.getString(this.encodingVegaSpec, (Object[])objectArray);
            if (string == null || (string = VegaUtil.INSTANCE.unescapeField$lets_plot_vega_lite(string)) == null) continue;
            String field = string;
            Object[] objectArray2 = new Object[]{channel, "timeUnit"};
            if (OptionsSelectorKt.getString(this.encodingVegaSpec, (Object[])objectArray2) == null || this.getField(field) == null) continue;
            Iterable $this$map$iv = timeSeries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long l;
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                if (!(it instanceof Number)) {
                    l = null;
                } else {
                    String timeUnit;
                    Instant instant = new Instant(((Number)it).longValue());
                    DateTime dateTime = instant.toDateTime(TimeZone.Companion.getUTC());
                    DateTime adjustedDateTime = Companion.truncateDateTimeToUnit$lets_plot_vega_lite(dateTime, timeUnit);
                    l = adjustedDateTime.toInstant(TimeZone.Companion.getUTC()).toEpochMilliseconds();
                }
                collection.add(l);
            }
            List adjustedTimeSeries = (List)destination$iv$iv;
            this.updatedFields.put(field, adjustedTimeSeries);
        }
    }

    private final List<Object> getField(String name) {
        List<Object> list = this.updatedFields.get(name);
        if (list == null) {
            list = this.originalData.get(name);
        }
        return list;
    }

    private static final kotlinx.datetime.Instant parseTemporalData$lambda$8$lambda$7$tryParseInstant(DataProcessor this$0, String str, String pattern) {
        Object object;
        String string;
        block5: {
            block4: {
                string = pattern;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                DateTimeFormat dateTimeFormat = DateTimeComponents.Companion.Format((Function1)new Function1<DateTimeFormatBuilder.WithDateTimeComponents, Unit>(pattern){
                    final /* synthetic */ String $pattern;
                    {
                        this.$pattern = $pattern;
                        super(1);
                    }

                    public final void invoke(@NotNull DateTimeFormatBuilder.WithDateTimeComponents $this$Format) {
                        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
                        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)this.$pattern);
                    }
                });
                string = dateTimeFormat;
                if (dateTimeFormat != null) break block5;
            }
            string = DateTimeComponents.Formats.INSTANCE.getISO_DATE_TIME_OFFSET();
        }
        String format2 = string;
        Object object2 = this$0;
        try {
            DataProcessor $this$parseTemporalData_u24lambda_u248_u24lambda_u247_u24tryParseInstant_u24lambda_u241 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)kotlinx.datetime.Instant.Companion.parse((CharSequence)str, (DateTimeFormat)format2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (kotlinx.datetime.Instant)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    static /* synthetic */ kotlinx.datetime.Instant parseTemporalData$lambda$8$lambda$7$tryParseInstant$default(DataProcessor dataProcessor, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseInstant(dataProcessor, string, string2);
    }

    private static final kotlinx.datetime.Instant parseTemporalData$lambda$8$lambda$7$tryParseDateTime(DataProcessor this$0, String str, String pattern) {
        Object object;
        String string;
        block5: {
            block4: {
                string = pattern;
                if (string == null) break block4;
                String it = string;
                boolean bl = false;
                DateTimeFormat dateTimeFormat = LocalDateTime.Companion.Format((Function1)new Function1<DateTimeFormatBuilder.WithDateTime, Unit>(pattern){
                    final /* synthetic */ String $pattern;
                    {
                        this.$pattern = $pattern;
                        super(1);
                    }

                    public final void invoke(@NotNull DateTimeFormatBuilder.WithDateTime $this$Format) {
                        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
                        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)this.$pattern);
                    }
                });
                string = dateTimeFormat;
                if (dateTimeFormat != null) break block5;
            }
            string = LocalDateTime.Formats.INSTANCE.getISO();
        }
        String format2 = string;
        Object object2 = this$0;
        try {
            DataProcessor $this$parseTemporalData_u24lambda_u248_u24lambda_u247_u24tryParseDateTime_u24lambda_u243 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)TimeZoneKt.toInstant((LocalDateTime)LocalDateTime.Companion.parse((CharSequence)str, (DateTimeFormat)format2), (kotlinx.datetime.TimeZone)((kotlinx.datetime.TimeZone)kotlinx.datetime.TimeZone.Companion.getUTC())));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (kotlinx.datetime.Instant)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    static /* synthetic */ kotlinx.datetime.Instant parseTemporalData$lambda$8$lambda$7$tryParseDateTime$default(DataProcessor dataProcessor, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDateTime(dataProcessor, string, string2);
    }

    private static final kotlinx.datetime.Instant parseTemporalData$lambda$8$lambda$7$tryParseDate(DataProcessor this$0, String str, String pattern) {
        Object object;
        String string;
        block7: {
            block6: {
                string = pattern;
                if (string == null) break block6;
                String it = string;
                boolean bl = false;
                DateTimeFormat dateTimeFormat = LocalDate.Companion.Format((Function1)new Function1<DateTimeFormatBuilder.WithDate, Unit>(pattern){
                    final /* synthetic */ String $pattern;
                    {
                        this.$pattern = $pattern;
                        super(1);
                    }

                    public final void invoke(@NotNull DateTimeFormatBuilder.WithDate $this$Format) {
                        Intrinsics.checkNotNullParameter((Object)$this$Format, (String)"$this$Format");
                        UnicodeKt.byUnicodePattern((DateTimeFormatBuilder)((DateTimeFormatBuilder)$this$Format), (String)this.$pattern);
                    }
                });
                string = dateTimeFormat;
                if (dateTimeFormat != null) break block7;
            }
            string = LocalDate.Formats.INSTANCE.getISO();
        }
        String format2 = string;
        Object object2 = this$0;
        try {
            DataProcessor $this$parseTemporalData_u24lambda_u248_u24lambda_u247_u24tryParseDate_u24lambda_u245 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)LocalDate.Companion.parse((CharSequence)str, (DateTimeFormat)format2));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        LocalDate localDate = (LocalDate)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (localDate == null) {
            return null;
        }
        LocalDate date = localDate;
        return TimeZoneKt.toInstant((LocalDateTime)new LocalDateTime(date, new LocalTime(0, 0, 0, 0)), (kotlinx.datetime.TimeZone)((kotlinx.datetime.TimeZone)kotlinx.datetime.TimeZone.Companion.getUTC()));
    }

    static /* synthetic */ kotlinx.datetime.Instant parseTemporalData$lambda$8$lambda$7$tryParseDate$default(DataProcessor dataProcessor, String string, String string2, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        return DataProcessor.parseTemporalData$lambda$8$lambda$7$tryParseDate(dataProcessor, string, string2);
    }

    public /* synthetic */ DataProcessor(Map originalData, Map encodingVegaSpec, DefaultConstructorMarker $constructor_marker) {
        this(originalData, encodingVegaSpec);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JZ\u0010\u0003\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u00042\u001a\u0010\u0007\u001a\u0016\u0012\u0004\u0012\u00020\u0005\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00060\u00042\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00042\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\nJ\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/vegalite/DataProcessor$Companion;", "", "()V", "processData", "", "", "", "data", "encodingVegaSpec", "messageConsumer", "Lkotlin/Function1;", "", "truncateDateTimeToUnit", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "dateTime", "unitsTemplate", "truncateDateTimeToUnit$lets_plot_vega_lite", "lets-plot-vega-lite"})
    @SourceDebugExtension(value={"SMAP\nDataProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataProcessor.kt\norg/jetbrains/letsPlot/vegalite/DataProcessor$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,196:1\n37#2,2:197\n*S KotlinDebug\n*F\n+ 1 DataProcessor.kt\norg/jetbrains/letsPlot/vegalite/DataProcessor$Companion\n*L\n61#1:197,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, List<Object>> processData(@NotNull Map<String, ? extends List<? extends Object>> data, @NotNull Map<?, ?> encodingVegaSpec, @NotNull Function1<? super String, Unit> messageConsumer) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            Intrinsics.checkNotNullParameter(encodingVegaSpec, (String)"encodingVegaSpec");
            Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
            DataProcessor processor = new DataProcessor(data, encodingVegaSpec, null);
            processor.parseTemporalData((Function1<? super String, Unit>)messageConsumer);
            processor.adjustSeriesDataTypes();
            processor.truncateDateTimeToUnit();
            if (processor.updatedFields.isEmpty()) {
                return data;
            }
            return MapsKt.plus(data, (Map)processor.updatedFields);
        }

        @NotNull
        public final DateTime truncateDateTimeToUnit$lets_plot_vega_lite(@NotNull DateTime dateTime, @NotNull String unitsTemplate) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            Intrinsics.checkNotNullParameter((Object)unitsTemplate, (String)"unitsTemplate");
            int year = 0;
            Month month = Month.JANUARY;
            int day = 1;
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int ms = 0;
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"year", (boolean)false, (int)2, null)) {
                year = dateTime.getYear();
            }
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"month", (boolean)false, (int)2, null)) {
                Collection $this$toTypedArray$iv = (Collection)EntriesMappings.entries$0;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                month = thisCollection$iv.toArray(new Month[0])[dateTime.getMonth().ordinal()];
            }
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"day", (boolean)false, (int)2, null)) {
                day = dateTime.getDay();
            }
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"hours", (boolean)false, (int)2, null)) {
                hours = dateTime.getTime().getHours();
            }
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"minutes", (boolean)false, (int)2, null)) {
                minutes = dateTime.getTime().getMinutes();
            }
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"seconds", (boolean)false, (int)2, null)) {
                seconds = dateTime.getTime().getSeconds();
            }
            if (StringsKt.contains$default((CharSequence)unitsTemplate, (CharSequence)"milliseconds", (boolean)false, (int)2, null)) {
                ms = dateTime.getTime().getMilliseconds();
            }
            return new DateTime(new Date(day, month, year), new Time(hours, minutes, seconds, ms));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class EntriesMappings {
            public static final /* synthetic */ EnumEntries<Month> entries$0;

            static {
                entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Month.values()));
            }
        }
    }
}

