/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import com.intellij.openapi.graph.impl.view.JBGraphEditorComponentDrawable;
import com.intellij.openapi.graph.impl.view.JByToSwingEventsDelegatingMode;
import h.O.Kz;
import h.O.dL;
import h.O.e5;
import h.O.ki;
import h.O.q;
import h.h.T;
import h.h.d;
import h.h.o;
import h.o.F;
import java.applet.Applet;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventObject;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCellEditorMode
extends Kz {
    @NotNull
    private final d myNodeCellEditorProvider;
    @NotNull
    private final o myUserObjectMap;
    @NotNull
    private final CellEditorListener myCellEditorListener = new MyCellEditorListener();
    @Nullable
    private e5 myCurrentEditor;
    @Nullable
    private dL myCurrentEditedNodeRealizer;
    @Nullable
    private JComponent myCurrentEditorComponent;
    @Nullable
    private JByToSwingEventsDelegatingMode myEventsDelegatingMode;
    @Nullable
    private JBGraphEditorComponentDrawable myEditorComponentDrawable;
    @Nullable
    private PropertyChangeListener myFocusOwnerChangeListener;

    public JBCellEditorMode(e5 nodeCellEditor, o userObjectMap) {
        this(F.h(nodeCellEditor), userObjectMap);
    }

    public JBCellEditorMode(d nodeCellEditorProvider, o userObjectMap) {
        super(nodeCellEditorProvider, userObjectMap);
        this.myNodeCellEditorProvider = nodeCellEditorProvider;
        this.myUserObjectMap = userObjectMap;
    }

    @Override
    public boolean editNode(T node, EventObject event) {
        if (this.isNodeEditable(node) && (!this.isCellEditing() || this.stopCellEditing())) {
            dL dL2 = this.h().h(node);
            e5 e52 = this.getNodeCellEditor(node);
            if (e52 == null || event != null && !e52.isCellEditable(event)) {
                return false;
            }
            this.startCellEditing(dL2, e52);
            if (event instanceof MouseEvent && ((MouseEvent)event).getID() == 500 && this.myEventsDelegatingMode != null && this.isCellEditing()) {
                this.myEventsDelegatingMode.mouseClicked((MouseEvent)event);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isNodeEditable(T node) {
        return this.getNodeCellEditor(node) != null;
    }

    private void R(MouseEvent mouseEvent) {
        Object object;
        q q2;
        if (!this.isCellEditing()) {
            if (!this.shouldStartCellEditing(mouseEvent)) {
                return;
            }
            q2 = this.h(mouseEvent);
            if (q2.h() == null) {
                return;
            }
            this.editNode((T)q2.h(), mouseEvent);
            if (!dL.L) {
                return;
            }
        }
        this.O(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
        if (this.isCellEditing() && mouseEvent.getID() == 501 && ((object = (q2 = this.h(mouseEvent)).h()) == null || object != this.myCurrentEditedNodeRealizer.h()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    @Nullable
    public Object getUserObject(T node) {
        return this.myUserObjectMap.get(this.myCurrentEditedNodeRealizer.h());
    }

    @Override
    public void setUserObject(T node, Object data) {
        this.myUserObjectMap.h((Object)node, data);
    }

    @Override
    protected boolean shouldStartCellEditing(@NotNull MouseEvent event) {
        if (event == null) {
            JBCellEditorMode.O(0);
        }
        return event.getID() == 500 && event.getClickCount() == 2;
    }

    @Override
    @Nullable
    public e5 getNodeCellEditor(T node) {
        Object object = this.myNodeCellEditorProvider != null ? this.myNodeCellEditorProvider.get(node) : null;
        return object instanceof e5 ? (e5)object : null;
    }

    @Override
    public boolean isCellEditing() {
        return this.myCurrentEditor != null;
    }

    @Override
    public void startCellEditing(dL nodeRealizer, e5 nodeCellEditor) {
        if (this.isCellEditing() && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
        if (!this.isCellEditing()) {
            this.myCurrentEditor = nodeCellEditor;
            this.myCurrentEditedNodeRealizer = nodeRealizer;
            nodeCellEditor.addCellEditorListener(this.myCellEditorListener);
            JComponent jComponent = nodeCellEditor.getNodeCellEditorComponent(this.h, nodeRealizer, this.getUserObject(nodeRealizer.h()), nodeRealizer.u());
            this.installEditor(jComponent, nodeRealizer);
        }
    }

    @Override
    @Nullable
    public e5 getEditor() {
        return this.myCurrentEditor;
    }

    @Override
    @Nullable
    public T getEditingNode() {
        return this.myCurrentEditedNodeRealizer != null ? this.myCurrentEditedNodeRealizer.h() : null;
    }

    @Override
    public void cancelCellEditing() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.cancelCellEditing();
        }
    }

    @Override
    public boolean stopCellEditing() {
        return this.myCurrentEditor != null ? this.myCurrentEditor.stopCellEditing() : true;
    }

    @Override
    protected void cellEditingCanceled() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    protected void cellEditingStopped() {
        if (this.myCurrentEditor != null) {
            this.myCurrentEditor.removeCellEditorListener(this.myCellEditorListener);
            this.removeEditor();
            this.myCurrentEditor = null;
            this.reactivateParent();
        }
    }

    @Override
    public void reactivateParent() {
        super.reactivateParent();
    }

    @Override
    public void cancelEditing() throws UnsupportedOperationException {
        super.cancelEditing();
    }

    @Override
    protected void setEditing(boolean b2) {
        super.setEditing(b2);
    }

    @Override
    public void activate(boolean b2) {
        super.activate(b2);
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseMoved(event);
        }
    }

    private void u(@NotNull MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            JBCellEditorMode.O(1);
        }
        if (mouseEvent.getID() == 501 && this.isCellEditing() && ((object = this.h(mouseEvent).h()) == null || object != this.myCurrentEditedNodeRealizer.h()) && !this.stopCellEditing()) {
            this.cancelCellEditing();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseReleased(event);
        }
        this.K(event);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseDragged(event);
        }
        this.K(event);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mousePressed(event);
        }
        this.K(event);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.myEventsDelegatingMode != null) {
            this.myEventsDelegatingMode.mouseClicked(event);
        }
        this.K(event);
    }

    private void K(MouseEvent mouseEvent) {
        this.u(mouseEvent);
        if (!dL.L) {
            return;
        }
        this.R(mouseEvent);
    }

    @Override
    protected void installEditor(@NotNull JComponent editorComponent, dL nodeRealizer) {
        if (editorComponent == null) {
            JBCellEditorMode.O(2);
        }
        if (editorComponent.getNextFocusableComponent() == null) {
            editorComponent.setNextFocusableComponent(this.h.O());
        }
        JComponent jComponent = this.h();
        jComponent.add(editorComponent);
        this.myCurrentEditorComponent = editorComponent;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(nodeRealizer.h(), nodeRealizer.R());
        JByToSwingEventsDelegatingMode jByToSwingEventsDelegatingMode = new JByToSwingEventsDelegatingMode(true);
        this.h(jByToSwingEventsDelegatingMode, null, null, null);
        jByToSwingEventsDelegatingMode.addDelegateComponent(editorComponent, affineTransform);
        this.myEventsDelegatingMode = jByToSwingEventsDelegatingMode;
        this.myEditorComponentDrawable = new JBGraphEditorComponentDrawable(jComponent, editorComponent, affineTransform);
        this.h.h(this.myEditorComponentDrawable);
        editorComponent.setBounds(0, 0, (int)nodeRealizer.O(), (int)nodeRealizer.u());
        editorComponent.validate();
        editorComponent.requestFocusInWindow();
        editorComponent.repaint();
        if (this.myFocusOwnerChangeListener == null) {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.myFocusOwnerChangeListener = new MyFocusOwnerListener(keyboardFocusManager);
            keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
        }
    }

    @Override
    protected void removeEditor() {
        if (this.myFocusOwnerChangeListener != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener("permanentFocusOwner", this.myFocusOwnerChangeListener);
            this.myFocusOwnerChangeListener = null;
        }
        if (this.myCurrentEditorComponent != null) {
            this.myEventsDelegatingMode.reactivateParent();
            this.h().remove(this.myCurrentEditorComponent);
            this.h.O(this.myEditorComponentDrawable);
            this.h.O().repaint();
            this.myEventsDelegatingMode = null;
        }
        this.myCurrentEditorComponent = null;
    }

    private void O(Component component) {
        if (component instanceof ki) {
            return;
        }
        boolean bl = dL.L;
        if (this.isCellEditing()) {
            JComponent jComponent = this.h();
            for (Component component2 = component; component2 != null && component2 != jComponent; component2 = component2.getParent()) {
                if (component2 instanceof Window || component2 instanceof Applet && component2.getParent() == null) {
                    if (component2 == SwingUtilities.getRoot(this.h) && !this.stopCellEditing()) {
                        this.cancelCellEditing();
                    }
                    return;
                }
                if (!bl) continue;
                return;
            }
        }
    }

    @NotNull
    private JComponent h() {
        JComponent jComponent = this.h.O();
        if (jComponent == null) {
            JBCellEditorMode.O(3);
        }
        return jComponent;
    }

    private static /* synthetic */ void O(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorComponent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/view/JBCellEditorMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanvasComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shouldStartCellEditing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cancelEditingIfAnotherNodeWasClicked";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "installEditor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private final class MyCellEditorListener
    implements CellEditorListener {
        MyCellEditorListener() {
        }

        @Override
        public void editingStopped(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingStopped();
        }

        @Override
        public void editingCanceled(ChangeEvent event) {
            JBCellEditorMode.this.cellEditingCanceled();
        }
    }

    private final class MyFocusOwnerListener
    implements PropertyChangeListener {
        @NotNull
        private final KeyboardFocusManager myFocusManager;

        public MyFocusOwnerListener(KeyboardFocusManager focusManager) {
            if (focusManager == null) {
                MyFocusOwnerListener.h(0);
            }
            this.myFocusManager = focusManager;
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            JBCellEditorMode.this.O(this.myFocusManager.getPermanentFocusOwner());
        }

        private static /* synthetic */ void h(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusManager", "com/intellij/openapi/graph/impl/view/JBCellEditorMode$MyFocusOwnerListener", "<init>"));
        }
    }
}

