// Copyright 2000-2024 JetBrains s.r.o. and contributors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Collections;
import java.util.List;

public interface Field extends PhpClassMember, RWAccess, PhpTypeDeclarationOwner<PhpTypeDeclaration>, PhpAttributesOwner {
  Field[] EMPTY = new Field[0];
  ArrayFactory<Field> ARRAY_FACTORY = count -> count > 0 ? new Field[count] : EMPTY;
  Condition<PsiElement> INSTANCEOF = use -> use instanceof Field;

  boolean isConstant();

  boolean isReadonly();

  default boolean isAbstract() {
    return false;
  }

  default boolean isFinal() {
    return false;
  }

  default boolean hasPropertyHooksContainer() {
    return false;
  }

  @Nullable
  PsiElement getDefaultValue();

  @Nullable
  String getDefaultValuePresentation();

  @Nullable
  PhpClassFieldsList getParentList();

  default @NotNull List<PhpPropertyHook> getPropertyHooksList() {
    return Collections.emptyList();
  }

  default boolean isVirtualProperty() {
    return false;
  }

  default boolean isPropertyWithAsymmetricVisibility() {
    return false;
  }
}
