/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.unwraptag;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.psi.XMLMutationUtils;
import com.sixrr.xrp.utils.XMLRefactoringUtil;
import java.util.Collections;
import java.util.List;

class UnwrapTag
extends XRPUsageInfo {
    private final XmlTag tag;

    UnwrapTag(XmlTag tag) {
        super((PsiElement)tag);
        this.tag = tag;
    }

    @Override
    public void fixUsage() throws IncorrectOperationException {
        List<PsiElement> contents = XMLMutationUtils.calculateContents(this.tag);
        PsiElement tagParent = this.tag.getParent();
        Collections.reverse(contents);
        for (PsiElement child : contents) {
            String text;
            if (child instanceof XmlText && XMLRefactoringUtil.isWhitespace(text = child.getText())) continue;
            PsiElement childCopy = child.copy();
            tagParent.addAfter(childCopy, (PsiElement)this.tag);
        }
        this.tag.delete();
        PsiManager manager = tagParent.getManager();
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)manager.getProject());
        styleManager.reformat(tagParent);
    }
}

