/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.ui;

import com.intellij.DynamicBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpreterComboBox;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import com.jetbrains.php.framework.ui.CommandLineToolsInterpreterCombo;
import com.jetbrains.php.framework.ui.FrameworkCompositePathDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkPathDialog
extends DialogWrapper {
    public static final String PROJECT_INTERPRETER = "PROJECT_DEFAULT_INTERPRETER";
    @Nullable
    protected final Project myProject;
    private final boolean myNeedsPhp;
    private final String[] myExecutableNames;
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myPathField;
    private JLabel myPathLabel;
    private JPanel myPhpSettingsPanel;
    protected JPanel myAdditionalPanel;
    private PhpInterpreterComboBox myPhpInterpreterComboBox1;

    protected FrameworkPathDialog(boolean needsPhp, String ... names) {
        super(true);
        this.myNeedsPhp = needsPhp;
        this.myExecutableNames = names;
        this.myProject = null;
        this.$$$setupUI$$$();
        this.initialize(null);
    }

    protected FrameworkPathDialog(@NotNull Project project, boolean needsPhp, String ... names) {
        if (project == null) {
            FrameworkPathDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myNeedsPhp = needsPhp;
        this.myExecutableNames = names;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initialize(project);
    }

    protected final void initialize(final @Nullable Project project) {
        this.setTitle(this.getDialogTitle());
        this.myPathLabel.setText(this.getPathLabelText());
        this.myPathField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>((ComponentWithBrowseButton)this.myPathField, null, this.getFileChooserDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                return FrameworkPathDialog.this.getInitialFile(project);
            }

            public void actionPerformed(ActionEvent e) {
                String interpreterName = FrameworkPathDialog.this.myPhpInterpreterComboBox1.getSelectedItemName();
                if (interpreterName == null) {
                    super.actionPerformed(e);
                    return;
                }
                PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)FrameworkPathDialog.this.myProject);
                PhpInterpreter interpreter = manager.findInterpreter(interpreterName);
                if (interpreter == null || interpreter.isRemote()) {
                    return;
                }
                super.actionPerformed(e);
            }
        });
        this.myPhpSettingsPanel.setVisible(this.myNeedsPhp);
        this.setModal(true);
        this.init();
        this.pack();
        this.initValidation();
    }

    protected boolean postponeValidation() {
        return false;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        if (this.myNeedsPhp) {
            return FrameworkCompositePathDialog.createStandardValidationInfo((JComponent)this.myPhpInterpreterComboBox1, this.getPhpExecutablePath(), PhpProjectConfigurationFacade.PHP_EXECUTABLE, FrameworkBundle.message("framework.php.executable", new Object[0]), this.myProject);
        }
        String interpreterName = this.myPhpInterpreterComboBox1.getSelectedItemName();
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance((Project)this.myProject);
        PhpInterpreter interpreter = manager.findInterpreter(interpreterName);
        if (interpreter == null || interpreter.isRemote()) {
            return null;
        }
        String path = this.getPath();
        if (path == null) {
            if (this.myExecutableNames.length == 1) {
                return new ValidationInfo(FrameworkBundle.message("framework.path.dialog.0.not.chosen", this.myExecutableNames[0]), (JComponent)this.myPathField);
            }
            if (this.myExecutableNames.length == 2) {
                return new ValidationInfo(FrameworkBundle.message("framework.path.dialog.neither.file.0.nor.1.is.chosen", this.myExecutableNames[0], this.myExecutableNames[1]), (JComponent)this.myPathField);
            }
            StringBuilder messageBuilder = new StringBuilder();
            messageBuilder.append(FrameworkBundle.message("framework.path.dialog.none.of.expected.files.is.chosen", this.myPathField.getText()));
            messageBuilder.append('\n');
            for (String name : this.myExecutableNames) {
                messageBuilder.append(name).append(", ");
            }
            @NlsSafe String substring = messageBuilder.substring(0, messageBuilder.length() - 2);
            return new ValidationInfo(substring, (JComponent)this.myPathField);
        }
        if (path.isEmpty()) {
            return new ValidationInfo(FrameworkBundle.message("framework.path.dialog.path.not.provided", new Object[0]), (JComponent)this.myPathField);
        }
        return null;
    }

    @Nullable
    public final String getPath() {
        String text = this.myPathField.getText();
        for (String name : this.myExecutableNames) {
            String path = null;
            if (StringUtil.isEmpty((String)text)) {
                path = "";
            } else {
                File providedFile = new File(text);
                if (providedFile.exists()) {
                    String name1 = providedFile.getName();
                    for (String fileName : new String[]{name}) {
                        if (!name1.equals(fileName)) continue;
                        path = FileUtil.toSystemDependentName((String)providedFile.getPath());
                        break;
                    }
                }
            }
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @NotNull
    private String getPhpExecutablePath() {
        PhpInterpreter interpreter;
        assert (this.myNeedsPhp);
        String interpreterName = this.myPhpInterpreterComboBox1.getSelectedItemName();
        if (interpreterName != null && (interpreter = PhpInterpretersManagerImpl.getInstance((Project)this.myProject).findInterpreter(interpreterName)) != null) {
            String string = interpreter.getId();
            if (string == null) {
                FrameworkPathDialog.$$$reportNull$$$0(1);
            }
            return string;
        }
        return PROJECT_INTERPRETER;
    }

    public Data getData() {
        return new Data(StringUtil.notNullize((String)this.myPathField.getText()), StringUtil.notNullize((String)this.getPhpExecutablePath()));
    }

    protected final JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public final JComponent getPreferredFocusedComponent() {
        return this.myPathField.getTextField();
    }

    protected String getPathFieldText() {
        return this.myPathField.getText();
    }

    @Nls
    protected abstract String getDialogTitle();

    protected abstract FileChooserDescriptor getFileChooserDescriptor();

    @Nls
    protected abstract String getPathLabelText();

    public void createUIComponents() {
        this.myPhpInterpreterComboBox1 = new CommandLineToolsInterpreterCombo(this.myProject);
        this.myPhpInterpreterComboBox1.reset();
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myPhpInterpreterComboBox1);
    }

    @Nullable
    protected VirtualFile getInitialFile(@Nullable Project component) {
        return null;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JLabel jLabel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myPathLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkPathDialog.class).getString("framework.zend1.path.to.zf.tool"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPhpSettingsPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null, 0, true));
        this.myAdditionalPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/FrameworkBundle", FrameworkPathDialog.class).getString("php.interpreter"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        PhpInterpreterComboBox phpInterpreterComboBox = this.myPhpInterpreterComboBox1;
        jPanel2.add((Component)phpInterpreterComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkPathDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkPathDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpExecutablePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static final class Data {
        public static final Data EMPTY = new Data("", "");
        @NotNull
        private final String myPath;
        @NotNull
        private final String myPhpPath;

        public Data(@NotNull String path, @NotNull String phpPath) {
            if (path == null) {
                Data.$$$reportNull$$$0(0);
            }
            if (phpPath == null) {
                Data.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myPhpPath = phpPath;
        }

        @NotNull
        public String getPath(boolean quoteIfNeeded) {
            if (quoteIfNeeded && this.myPath.contains(" ")) {
                String string = "\"" + this.myPath + "\"";
                if (string == null) {
                    Data.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.myPath;
            if (string == null) {
                Data.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getPhpPath(boolean quoteIfNeeded) {
            if (quoteIfNeeded && this.myPhpPath.contains(" ")) {
                String string = "\"" + this.myPhpPath + "\"";
                if (string == null) {
                    Data.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.myPhpPath;
            if (string == null) {
                Data.$$$reportNull$$$0(5);
            }
            return string;
        }

        public static Data parseInvokeText(@Nullable String invokeText) {
            if (invokeText == null) {
                return EMPTY;
            }
            List elements = StringUtil.splitHonorQuotes((String)invokeText, (char)' ');
            if (elements.isEmpty()) {
                return EMPTY;
            }
            if (elements.size() == 1) {
                return new Data(StringUtil.unquoteString((String)((String)elements.get(0))), "");
            }
            return new Data(StringUtil.unquoteString((String)((String)elements.get(1))), StringUtil.unquoteString((String)((String)elements.get(0))));
        }

        public String[] createCommand(String ... args) {
            String[] result = new String[args.length + 2];
            result[0] = this.getPhpPath(false);
            result[1] = this.getPath(false);
            System.arraycopy(args, 0, result, 2, args.length);
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "phpPath";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/framework/ui/FrameworkPathDialog$Data";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/framework/ui/FrameworkPathDialog$Data";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPhpPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

