/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.zendtool.first;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.generators.zendtool.first.Zend1Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class Zend1Manifest {
    private static final int DELAY_FOR_PATTERNS_MS = 1000;
    @NonNls
    private static final String OFFICIAL_GENERAL_SPECIALITY_NAME = "_Global";
    @NonNls
    private static final Pattern ACTION_PATTERN = Pattern.compile("^ *(type=Tool, )?clientName=console, actionName=([\\w-]*) *: ([\\w-]*).*$");
    @NonNls
    private static final Pattern PROVIDER_PATTERN = Pattern.compile("^ *(type=Tool, )?clientName=console, providerName=([\\w-]*) *: ([\\w-]*).*$");
    @NonNls
    private static final Pattern SPECIALTY_PATTERN = Pattern.compile("^ *(type=Tool, )?clientName=console, providerName=([\\w-]*), specialtyName=([\\w-]*) *: ([\\w-]*).*$");
    @NonNls
    private static final Pattern PARAMETERS_PATTERN = Pattern.compile("^ *(type=Tool, )?clientName=console, actionName=([\\w-]*), providerName=([\\w-]*), specialtyName=([\\w-]*) *: (.*)$");
    @NonNls
    private static final Pattern NO_PARAMETERS_PATTERN = Pattern.compile("^(empty array) *$");
    @NonNls
    private static final Pattern PARAMETERS_ENTRY_PATTERN = Pattern.compile("([\\w-]*)=([\\w-]*)");
    private final Map<String, String> myActions = new HashMap<String, String>();
    private final Map<String, String> myProviders = new HashMap<String, String>();
    private final Map<Pair<String, String>, String> mySpecialties = new HashMap<Pair<String, String>, String>();
    private final Map<Trinity<String, String, String>, List<String>> myParameters = new HashMap<Trinity<String, String, String>, List<String>>();
    private boolean myParseParameters = false;

    public void parseString(String line) {
        if (line.trim().equals("actionableMethodLongParams")) {
            this.myParseParameters = true;
        } else if (line.trim().equals("actionableMethodShortParams")) {
            this.myParseParameters = false;
        }
        CharSequence bombedCharSequence = StringUtil.newBombedCharSequence((CharSequence)line, (long)1000L);
        Matcher matcher = ACTION_PATTERN.matcher(bombedCharSequence);
        if (matcher.find()) {
            this.myActions.put(matcher.group(2), matcher.group(3));
            return;
        }
        matcher = PROVIDER_PATTERN.matcher(bombedCharSequence);
        if (matcher.find()) {
            this.myProviders.put(matcher.group(2), matcher.group(3));
            return;
        }
        matcher = SPECIALTY_PATTERN.matcher(bombedCharSequence);
        if (matcher.find()) {
            this.mySpecialties.put((Pair<String, String>)Pair.create((Object)matcher.group(2), (Object)matcher.group(3)), matcher.group(4));
            return;
        }
        if (this.myParseParameters && (matcher = PARAMETERS_PATTERN.matcher(bombedCharSequence)).find()) {
            List parameters;
            CharSequence parametersEntry = StringUtil.newBombedCharSequence((CharSequence)matcher.group(5), (long)1000L);
            Matcher parametersMatcher = NO_PARAMETERS_PATTERN.matcher(parametersEntry);
            if (parametersMatcher.matches()) {
                parameters = Collections.emptyList();
            } else {
                parametersMatcher = PARAMETERS_ENTRY_PATTERN.matcher(parametersEntry);
                parameters = new LinkedList();
                int start = 0;
                while (parametersMatcher.find(start)) {
                    parameters.add(parametersMatcher.group(2));
                    start = parametersMatcher.end();
                }
            }
            this.myParameters.put((Trinity<String, String, String>)new Trinity((Object)matcher.group(2), (Object)matcher.group(3), (Object)matcher.group(4)), parameters);
        }
    }

    @NotNull
    public List<Zend1Command> getConsoleCommandData() {
        LinkedList<Zend1Command> result = new LinkedList<Zend1Command>();
        for (Map.Entry<Trinity<String, String, String>, List<String>> actionProviderSpecialtyParametersEntry : this.myParameters.entrySet()) {
            String action = this.myActions.get(actionProviderSpecialtyParametersEntry.getKey().getFirst());
            String officialProvider = (String)actionProviderSpecialtyParametersEntry.getKey().getSecond();
            String provider = this.myProviders.get(officialProvider);
            String officialSpeciality = (String)actionProviderSpecialtyParametersEntry.getKey().getThird();
            String specialty = OFFICIAL_GENERAL_SPECIALITY_NAME.equals(officialSpeciality) ? null : this.mySpecialties.get(Pair.create((Object)officialProvider, (Object)officialSpeciality));
            List<String> parameterNames = actionProviderSpecialtyParametersEntry.getValue();
            ArrayList<FrameworkCommand.Parameter> parameters = new ArrayList<FrameworkCommand.Parameter>(parameterNames.size());
            for (String parameterName : parameterNames) {
                parameters.add(new FrameworkCommand.Parameter(parameterName));
            }
            result.add(new Zend1Command(action, provider, specialty, parameters));
        }
        LinkedList<Zend1Command> linkedList = result;
        if (linkedList == null) {
            Zend1Manifest.$$$reportNull$$$0(0);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/framework/generators/zendtool/first/Zend1Manifest", "getConsoleCommandData"));
    }
}

