/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.moveMethod;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodToPredefinedTargetClassDialog;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpMoveMethodQuickFix
implements LocalQuickFix {
    private final SmartPsiElementPointer<Method> myMethod;
    private final SmartPsiElementPointer<PhpNamedElement> myVariable;
    private final List<PhpNamedElement> myParametersAndFieldsCandidates;

    public PhpMoveMethodQuickFix(Method method, PhpNamedElement variable, List<PhpNamedElement> parametersAndFieldsCandidates) {
        this.myMethod = SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)method);
        this.myVariable = SmartPointerManager.getInstance((Project)method.getProject()).createSmartPsiElementPointer((PsiElement)variable);
        this.myParametersAndFieldsCandidates = parametersAndFieldsCandidates;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getName() {
        PhpNamedElement variableElement = (PhpNamedElement)this.myVariable.getElement();
        if (variableElement != null) {
            if (variableElement instanceof Field) {
                String string = PhpArchitectureBundle.message("quickfix.name.move.method.to.field", variableElement.getName());
                if (string == null) {
                    PhpMoveMethodQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpArchitectureBundle.message("quickfix.name.move.method.to.parameter", variableElement.getName());
            if (string == null) {
                PhpMoveMethodQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = PhpArchitectureBundle.message("quickfix.name.move.method", new Object[0]);
        if (string == null) {
            PhpMoveMethodQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = PhpArchitectureBundle.message("quickfix.name.move.method", new Object[0]);
        if (string == null) {
            PhpMoveMethodQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhpMoveMethodQuickFix.$$$reportNull$$$0(4);
        }
        if (descriptor == null) {
            PhpMoveMethodQuickFix.$$$reportNull$$$0(5);
        }
        this.runFix();
    }

    public void runFix() {
        Method methodElement = (Method)this.myMethod.getElement();
        PhpNamedElement variableElement = (PhpNamedElement)this.myVariable.getElement();
        if (methodElement != null && variableElement != null) {
            new PhpMoveInstanceMethodToPredefinedTargetClassDialog(methodElement, this.myParametersAndFieldsCandidates, false).preselectVariable(variableElement).show();
        }
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            PhpMoveMethodQuickFix.$$$reportNull$$$0(6);
        }
        if (previewDescriptor == null) {
            PhpMoveMethodQuickFix.$$$reportNull$$$0(7);
        }
        return new IntentionPreviewInfo.Html(PhpArchitectureBundle.message("shows.move.instance.method.dialog", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/moveMethod/PhpMoveMethodQuickFix";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/moveMethod/PhpMoveMethodQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

