/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction;

import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PhpExtractMethodCandidate
extends PhpExtractMethodBlockCodeFragment
implements Comparable<PhpExtractMethodCandidate> {
    private final PhpExtractMethodBlockCodeFragment myFragment;
    public static final int CANDIDATE_LENGTH = 3000;
    public static final int NUMBER_OF_PARAMETERS_THRESHOLD = 4;
    @NotNull
    private final Set<PhpPsiElement> myOutputVariables;
    @NotNull
    private final Set<PhpPsiElement> myInputVariables;

    public PhpExtractMethodBlockCodeFragment getFragment() {
        return this.myFragment;
    }

    public PhpExtractMethodCandidate(PhpExtractMethodBlockCodeFragment fragment, @NotNull Set<PhpPsiElement> inputVariables, @NotNull Set<PhpPsiElement> outputVariables) {
        if (inputVariables == null) {
            PhpExtractMethodCandidate.$$$reportNull$$$0(0);
        }
        if (outputVariables == null) {
            PhpExtractMethodCandidate.$$$reportNull$$$0(1);
        }
        super(fragment.getStartStatement(), fragment.getEndStatement(), fragment.getScopeHolder());
        this.myFragment = fragment;
        this.myOutputVariables = outputVariables;
        this.myInputVariables = inputVariables;
    }

    @NotNull
    public Set<PhpPsiElement> getInputVariables() {
        Set<PhpPsiElement> set = this.myInputVariables;
        if (set == null) {
            PhpExtractMethodCandidate.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public Set<PhpPsiElement> getOutputVariables() {
        Set<PhpPsiElement> set = this.myOutputVariables;
        if (set == null) {
            PhpExtractMethodCandidate.$$$reportNull$$$0(3);
        }
        return set;
    }

    public double score() {
        return this.lengthScore() + (double)this.inputVariablesScore() + (double)this.outputVariablesScore() + this.whiteSpaceAndCommentScore();
    }

    private double lengthScore() {
        return (double)Math.min(this.myFragment.getEndOffset() - this.myFragment.getStartOffset(), 3000) * 0.001;
    }

    private int inputVariablesScore() {
        return -Math.min(this.myInputVariables.size(), 4);
    }

    private int outputVariablesScore() {
        return -(this.myOutputVariables.size() < 2 ? 0 : this.myOutputVariables.size());
    }

    public double whiteSpaceAndCommentScore() {
        return this.fragmentStartScore() + this.fragmentEndScore();
    }

    public double fragmentEndScore() {
        PsiElement nextSiblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)this.getEndStatement(), (boolean)true);
        if (nextSiblingIgnoreWhitespace instanceof PsiComment) {
            return 1.0;
        }
        if (PhpPsiUtil.isOfType((PsiElement)nextSiblingIgnoreWhitespace, (IElementType)PhpTokenTypes.chRBRACE) || PhpExtractMethodCandidate.isMultiLineBreak(this.getEndStatement().getNextSibling())) {
            return 0.5;
        }
        return 0.0;
    }

    public double fragmentStartScore() {
        PsiElement prevSiblingIgnoreWhitespace = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)this.getStartStatement(), (boolean)true);
        return (PhpPsiUtil.isOfType((PsiElement)prevSiblingIgnoreWhitespace, (IElementType)PhpTokenTypes.chLBRACE) || PhpExtractMethodCandidate.isMultiLineBreak(this.getStartStatement().getPrevSibling()) ? 1 : 0) + (this.getNameByComment() != null ? 3 : 0);
    }

    private static boolean isMultiLineBreak(PsiElement element) {
        if (element instanceof PsiWhiteSpace) {
            String whiteSpaceText = element.getText();
            return whiteSpaceText.split("[\n\r]").length > 2;
        }
        return false;
    }

    @Override
    public int compareTo(@NotNull PhpExtractMethodCandidate o) {
        if (o == null) {
            PhpExtractMethodCandidate.$$$reportNull$$$0(4);
        }
        return Double.compare(o.score(), this.score());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVariables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputVariables";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpExtractMethodCandidate";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/quickFixes/extractFunction/PhpExtractMethodCandidate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

