/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass;

import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Cluster;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Distance;

public class MinimalClusterDistance<T>
implements Distance<Cluster<T>> {
    private final Distance<? super T> myDistanceOperator;

    public MinimalClusterDistance(Distance<? super T> distanceOperator) {
        this.myDistanceOperator = distanceOperator;
    }

    @Override
    public double distance(Cluster<T> cluster1, Cluster<T> cluster2) {
        double minDistance = Double.MAX_VALUE;
        for (T entity1 : cluster1.getEntities()) {
            for (T entity2 : cluster2.getEntities()) {
                double distance = this.myDistanceOperator.distance(entity1, entity2);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
            }
        }
        return minDistance;
    }
}

