/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass;

import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.Distance;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class JaccardDistance<T>
implements Distance<T> {
    private final MultiMap<T, T> myMatrix;

    public JaccardDistance(MultiMap<T, T> matrix) {
        this.myMatrix = matrix;
    }

    @Override
    public double distance(T member1, T member2) {
        Collection set1 = this.myMatrix.get(member1);
        Collection set2 = this.myMatrix.get(member2);
        if (set1.isEmpty() && set2.isEmpty()) {
            return 1.0;
        }
        return 1.0 - (double)this.intersection(set1, set2).size() / (double)this.union(set1, set2).size();
    }

    private Collection<T> union(Collection<T> set1, Collection<T> set2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(set1);
        set.addAll(set2);
        return set;
    }

    public Set<T> intersection(Collection<T> set1, Collection<T> set2) {
        HashSet<T> set = new HashSet<T>(set1);
        set.retainAll(set2);
        return set;
    }
}

