/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.internalActions;

import com.intellij.lang.Language;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.calculators.LCOM4MetricsCalculator;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.CyclomaticComplexityVisitor;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.HalsteadMetric;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class PhpCollectClassMetricsStatistic
extends AnAction {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.php.architecture.complexityMetrics.internalActions.PhpCollectClassMetricsStatistic");
    private static final String CLASS_STATISTICS_CSV_FILE_NAME = "class-statistics.csv";
    private static final String METHOD_STATISTICS_CSV_FILE_NAME = "method-statistics.csv";

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpCollectClassMetricsStatistic.$$$reportNull$$$0(0);
        }
        final Project project = e.getProject();
        assert (project != null);
        final VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        assert (projectDir != null);
        this.removeStatitsticsFiles(project, projectDir, CLASS_STATISTICS_CSV_FILE_NAME);
        this.removeStatitsticsFiles(project, projectDir, METHOD_STATISTICS_CSV_FILE_NAME);
        final PhpIndex index = PhpIndex.getInstance((Project)project);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, PhpArchitectureBundle.message("collecting.metrics.statistics", new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Ref classStatisticsData = new Ref((Object)"");
                ApplicationManager.getApplication().runReadAction(() -> classStatisticsData.set((Object)PhpCollectClassMetricsStatistic.collectClassStatistics(project, index)));
                Ref functionStatisticsData = new Ref((Object)"");
                ApplicationManager.getApplication().runReadAction(() -> functionStatisticsData.set((Object)PhpCollectClassMetricsStatistic.collectFunctionStatistics(project, index)));
                PsiDirectory[] psiDirectory = new PsiDirectory[1];
                ApplicationManager.getApplication().runReadAction(() -> {
                    psiDirectory[0] = PsiManager.getInstance((Project)project).findDirectory(projectDir);
                });
                assert (psiDirectory[0] != null);
                PhpCollectClassMetricsStatistic.writeStatisticsToFile(project, psiDirectory[0], (String)classStatisticsData.get(), PhpCollectClassMetricsStatistic.CLASS_STATISTICS_CSV_FILE_NAME);
                PhpCollectClassMetricsStatistic.writeStatisticsToFile(project, psiDirectory[0], (String)functionStatisticsData.get(), PhpCollectClassMetricsStatistic.METHOD_STATISTICS_CSV_FILE_NAME);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/architecture/complexityMetrics/internalActions/PhpCollectClassMetricsStatistic$1", "run"));
            }
        });
    }

    private void removeStatitsticsFiles(Project project, VirtualFile projectDir, String fileName) {
        VirtualFile child = projectDir.findChild(fileName);
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            if (child != null) {
                try {
                    child.delete((Object)this);
                }
                catch (IOException e1) {
                    Notifications.Bus.notify((Notification)new Notification(PhpArchitectureBundle.message("collect.metrics.statistics", new Object[0]), PhpArchitectureBundle.message("collect.metrics.statistics", new Object[0]), e1.getMessage(), NotificationType.ERROR), (Project)project);
                }
            }
        });
    }

    @NotNull
    private static String collectFunctionStatistics(Project project, PhpIndex index) {
        StringBuilder sb = new StringBuilder();
        sb.append("function/method FQN, cyclomatic complexity, Halstead complexity\n");
        for (String fqn : index.getAllClassFqns(null)) {
            for (PhpClass aClass : index.getClassesByFQN(fqn)) {
                if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(aClass.getContainingFile().getVirtualFile())) continue;
                for (Method method : aClass.getOwnMethods()) {
                    CyclomaticComplexityVisitor cyclomaticComplexityVisitor = new CyclomaticComplexityVisitor();
                    method.accept((PsiElementVisitor)cyclomaticComplexityVisitor);
                    HalsteadMetric halsteadMetric = new HalsteadMetric(1000.0);
                    method.accept((PsiElementVisitor)halsteadMetric.getHalsteadVisitor());
                    sb.append(aClass.getFQN()).append(",").append(cyclomaticComplexityVisitor.getValue()).append(",").append(halsteadMetric.calculateComplexity()).append("\n");
                }
            }
        }
        String string = sb.toString();
        if (string == null) {
            PhpCollectClassMetricsStatistic.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static String collectClassStatistics(Project project, PhpIndex index) {
        StringBuilder sb = new StringBuilder();
        sb.append("class FQN, number of own methods, number of own fields, LCOM-graph-components, TCC\n");
        for (String fqn : index.getAllClassFqns(null)) {
            for (PhpClass aClass : index.getClassesByFQN(fqn)) {
                if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(aClass.getContainingFile().getVirtualFile())) continue;
                LCOM4MetricsCalculator calculator = new LCOM4MetricsCalculator(aClass);
                sb.append(aClass.getFQN()).append(",").append(aClass.getOwnMethods().length).append(",").append(aClass.getOwnFields().length).append(",").append(calculator.getLcom()).append(",").append(calculator.getTcc()).append("\n");
            }
        }
        return sb.toString();
    }

    private static void writeStatisticsToFile(Project project, PsiDirectory psiDirectory, String data, String fileName) {
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, (Language)PlainTextLanguage.INSTANCE, (CharSequence)data, true, false);
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> {
            VirtualFile child = psiDirectory.getVirtualFile().findChild(fileName);
            if (child != null) {
                try {
                    FileUtil.writeToFile((File)new File(fileName), (String)data);
                }
                catch (IOException e1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(e1.getMessage());
                    }
                    Notifications.Bus.notify((Notification)new Notification("System Messages", PhpArchitectureBundle.message("collect.metrics.statistics", new Object[0]), e1.getMessage(), NotificationType.ERROR), (Project)project);
                }
            }
            psiDirectory.add((PsiElement)file);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/internalActions/PhpCollectClassMetricsStatistic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/internalActions/PhpCollectClassMetricsStatistic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectFunctionStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

