/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics;

import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpComplexClassInspection;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpAccessesToDataMetric {
    public static final String IS = "is";
    private final Set<PhpClassMember> myForeignMembers;
    private final Set<PhpClassMember> mySourceClassMembers;

    public PhpAccessesToDataMetric(@NotNull PhpClass phpClass) {
        if (phpClass == null) {
            PhpAccessesToDataMetric.$$$reportNull$$$0(0);
        }
        this.myForeignMembers = new HashSet<PhpClassMember>();
        this.mySourceClassMembers = new HashSet<PhpClassMember>();
        for (Method method : phpClass.getOwnMethods()) {
            if (!PhpComplexClassInspection.isMemberToConsider((PhpClassMember)method)) continue;
            this.calculateAccessesToForeignData(method);
        }
    }

    public PhpAccessesToDataMetric(Method method) {
        this.myForeignMembers = new HashSet<PhpClassMember>();
        this.mySourceClassMembers = new HashSet<PhpClassMember>();
        this.calculateAccessesToForeignData(method);
    }

    public int getAccessToForeignDataMetric() {
        return this.myForeignMembers.size();
    }

    public double getLocalityOfAttributeAccesses() {
        int totalNumberOfFieldAccess = this.myForeignMembers.size() + this.mySourceClassMembers.size();
        if (totalNumberOfFieldAccess == 0) {
            return 1.0;
        }
        return (double)this.mySourceClassMembers.size() / (double)totalNumberOfFieldAccess;
    }

    public int getForeignDataProviders() {
        return this.myForeignMembers.stream().map(e -> e.getContainingClass()).collect(Collectors.toSet()).size();
    }

    public void calculateAccessesToForeignData(@NotNull Method method) {
        PhpClass myContainingClass;
        if (method == null) {
            PhpAccessesToDataMetric.$$$reportNull$$$0(1);
        }
        if ((myContainingClass = method.getContainingClass()) == null) {
            return;
        }
        PhpControlFlowUtil.processFlow((PhpControlFlow)method.getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                PsiElement resolvedElement;
                FieldReference fieldReference = instruction.getFieldReference();
                if (fieldReference != null && (resolvedElement = fieldReference.resolve()) instanceof Field) {
                    Field field = (Field)resolvedElement;
                    if (!(resolvedElement instanceof PhpDocProperty)) {
                        if (myContainingClass.findFieldByName((CharSequence)field.getName(), field.isConstant()) == null) {
                            PhpAccessesToDataMetric.this.myForeignMembers.add((PhpClassMember)field);
                        } else {
                            PhpAccessesToDataMetric.this.mySourceClassMembers.add((PhpClassMember)field);
                        }
                    }
                }
                return super.processAccessFieldByVariableInstruction(instruction);
            }

            public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                FieldReference fieldReference = (FieldReference)instruction.getAnchor();
                Field field = (Field)fieldReference.resolve();
                if (field != null && !(field instanceof PhpDocProperty)) {
                    if (myContainingClass.findFieldByName((CharSequence)field.getName(), field.isConstant()) == null) {
                        PhpAccessesToDataMetric.this.myForeignMembers.add((PhpClassMember)field);
                    } else {
                        PhpAccessesToDataMetric.this.mySourceClassMembers.add((PhpClassMember)field);
                    }
                }
                return super.processAccessFieldInObjectContextInstruction(instruction);
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                Field field;
                MethodReference methodReference;
                Method resolvedMethod;
                PsiElement anchor = instruction.getAnchor();
                if (anchor instanceof MethodReference && (resolvedMethod = (Method)ObjectUtils.tryCast((Object)(methodReference = (MethodReference)anchor).resolve(), Method.class)) != null && (field = PhpAccessesToDataMetric.getAccessedField(resolvedMethod)) != null && !(field instanceof PhpDocProperty)) {
                    if (!myContainingClass.getMethods().contains(resolvedMethod)) {
                        PhpAccessesToDataMetric.this.myForeignMembers.add((PhpClassMember)field);
                    } else {
                        PhpAccessesToDataMetric.this.mySourceClassMembers.add((PhpClassMember)field);
                    }
                }
                return super.processPhpCallInstruction(instruction);
            }
        });
    }

    public static Collection<String> getPossibleFieldNames(Method possibleAccessorMethod) {
        String name = null;
        String methodName = possibleAccessorMethod.getName();
        if (methodName.startsWith("get")) {
            name = methodName.substring("get".length());
        }
        if (methodName.startsWith("set")) {
            name = methodName.substring("set".length());
        }
        if (methodName.startsWith(IS)) {
            name = methodName.substring(IS.length());
        }
        ArrayList<String> possibleFieldNames = new ArrayList<String>();
        if (name != null) {
            List splitName = PhpNameUtil.splitName((String)name);
            String wordsDelimitedWithUnderScore = String.join((CharSequence)"_", splitName);
            possibleFieldNames.add(PhpAccessesToDataMetric.createCamelCaseName(wordsDelimitedWithUnderScore));
            possibleFieldNames.add(wordsDelimitedWithUnderScore);
        }
        return possibleFieldNames;
    }

    private static String createCamelCaseName(String wordsDelimitedWithUnderScore) {
        String camelCaps = PhpCodeUtil.camelCaps((String)wordsDelimitedWithUnderScore);
        return !wordsDelimitedWithUnderScore.isEmpty() ? Character.toLowerCase(camelCaps.charAt(0)) + camelCaps.substring(1) : camelCaps;
    }

    @Nullable
    public static Field getAccessedField(Method resolvedMethod) {
        PhpClass resolvedMethodContainingClass = resolvedMethod.getContainingClass();
        if (resolvedMethodContainingClass == null) {
            return null;
        }
        Collection<String> possibleFieldNames = PhpAccessesToDataMetric.getPossibleFieldNames(resolvedMethod);
        for (String possibleFieldName : possibleFieldNames) {
            Field nonConstantField = resolvedMethodContainingClass.findFieldByName((CharSequence)possibleFieldName, false);
            if (nonConstantField != null) {
                return nonConstantField;
            }
            Field constantField = resolvedMethodContainingClass.findFieldByName((CharSequence)possibleFieldName, true);
            if (constantField == null) continue;
            return constantField;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/metrics/PhpAccessesToDataMetric";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateAccessesToForeignData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

