/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.LibraryScopeCache;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.PhpAccessesToDataMetric;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.moveMethod.PhpMoveMethodQuickFix;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.codeStyle.PhpMethodMayBeStaticInspection;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.move.member.instance.PhpMoveInstanceMethodHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFeatureEnvyLocalInspection
extends PhpInspection {
    public static final int MAX_NUMBER_OF_SOURCE_CLASS_MEMBERS_ACCESSED = 2;
    public static final double ONE_THIRD = 0.3333333333333333;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpMethod(Method method) {
                PsiElement nameIdentifier;
                ArrayList<PhpNamedElement> parametersAndFieldsCandidates = new ArrayList<PhpNamedElement>();
                PhpNamedElement featureEnvy = PhpFeatureEnvyLocalInspection.findFeatureEnvy(method, parametersAndFieldsCandidates);
                if (featureEnvy != null && (nameIdentifier = method.getNameIdentifier()) != null) {
                    holder.registerProblem(nameIdentifier, PhpArchitectureBundle.message("inspection.php.feature.envy.method.has.feature.envy.on", featureEnvy.getName()), new LocalQuickFix[]{PhpFeatureEnvyLocalInspection.createMoveMethodQuickFixWithDialog(method, featureEnvy, parametersAndFieldsCandidates)});
                }
                super.visitPhpMethod(method);
            }
        };
    }

    public static PhpNamedElement findFeatureEnvy(Method method, List<PhpNamedElement> parametersAndFieldsCandidates) {
        if (PhpFeatureEnvyLocalInspection.shouldSkipMethod(method)) {
            return null;
        }
        PhpAccessesToDataMetric accessesToDataMetric = new PhpAccessesToDataMetric(method);
        if (accessesToDataMetric.getAccessToForeignDataMetric() > 4 && accessesToDataMetric.getForeignDataProviders() <= 2 && accessesToDataMetric.getLocalityOfAttributeAccesses() < 0.3333333333333333) {
            PhpNamedElement mostUsedVariable;
            parametersAndFieldsCandidates.addAll(PhpMoveInstanceMethodHandler.getParametersAndFieldsCandidate((Method)method));
            if (parametersAndFieldsCandidates.isEmpty()) {
                return null;
            }
            MultiMap<PhpNamedElement, PhpClassMember> statistics = PhpFeatureEnvyLocalInspection.getClassStatistics(method, parametersAndFieldsCandidates);
            Collection<PhpNamedElement> variableCandidates = PhpFeatureEnvyLocalInspection.getVariableCandidates(statistics);
            if (variableCandidates == null) {
                return null;
            }
            if (!variableCandidates.isEmpty() && (mostUsedVariable = (PhpNamedElement)ContainerUtil.getFirstItem(variableCandidates)) != null && mostUsedVariable != method.getContainingClass()) {
                return mostUsedVariable;
            }
        }
        return null;
    }

    @Nullable
    private static Collection<PhpNamedElement> getVariableCandidates(MultiMap<PhpNamedElement, PhpClassMember> statistics) {
        Optional<Map.Entry> mostUsedVariableCandidate = statistics.entrySet().stream().max(Comparator.comparingInt(e -> ((Collection)e.getValue()).size()));
        if (mostUsedVariableCandidate.isEmpty()) {
            return null;
        }
        int maxUsagesOfOneVariable = ((Collection)mostUsedVariableCandidate.get().getValue()).size();
        Set<PhpNamedElement> variableCandidates = statistics.entrySet().stream().filter(e -> ((Collection)e.getValue()).size() == maxUsagesOfOneVariable).map(e -> (PhpNamedElement)e.getKey()).collect(Collectors.toSet());
        if (PhpFeatureEnvyLocalInspection.candidatesHasThisReference(variableCandidates)) {
            return Collections.emptySet();
        }
        return variableCandidates;
    }

    private static boolean candidatesHasThisReference(Set<PhpNamedElement> variableCandidates) {
        return variableCandidates.stream().anyMatch(e -> e instanceof PhpClass);
    }

    public static boolean shouldSkipMethod(Method method) {
        return method.isStatic() || method.getMethodType(true) == Method.MethodType.CONSTRUCTOR || PhpChangeSignatureUsageSearcher.getOverridingMembers((Function)method, (boolean)false).size() != 1 || PhpChangeSignatureUsageSearcher.findDeepestSuperMethod((Method)method, (boolean)false) != null || PhpFeatureEnvyLocalInspection.isTestMethod(method);
    }

    @NotNull
    public static MultiMap<PhpNamedElement, PhpClassMember> getClassStatistics(final @NotNull Method method, final List<PhpNamedElement> parametersAndFieldsCandidates) {
        if (method == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(1);
        }
        final MultiMap accessedClassesStatistics = MultiMap.createSet();
        PhpClass sourceClass = method.getContainingClass();
        if (sourceClass == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(2);
            }
            return multiMap;
        }
        final Ref hasThisReferenceInMethodCall = new Ref((Object)false);
        PhpControlFlowUtil.processFlow((PhpControlFlow)method.getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

            public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                FieldReference fieldReference = (FieldReference)instruction.getAnchor();
                PhpFeatureEnvyLocalInspection.addAccessedClassData(method, (MemberReference)fieldReference, (MultiMap<PhpNamedElement, PhpClassMember>)accessedClassesStatistics, parametersAndFieldsCandidates);
                return super.processAccessFieldByVariableInstruction(instruction);
            }

            public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                FieldReference fieldReference = (FieldReference)instruction.getAnchor();
                PhpFeatureEnvyLocalInspection.addAccessedClassData(method, (MemberReference)fieldReference, (MultiMap<PhpNamedElement, PhpClassMember>)accessedClassesStatistics, parametersAndFieldsCandidates);
                return super.processAccessFieldInObjectContextInstruction(instruction);
            }

            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                PsiElement instructionAnchor = instruction.getAnchor();
                if (instructionAnchor instanceof MethodReference) {
                    MethodReference methodReference = (MethodReference)instructionAnchor;
                    PhpFeatureEnvyLocalInspection.addAccessedClassData(method, (MemberReference)methodReference, (MultiMap<PhpNamedElement, PhpClassMember>)accessedClassesStatistics, parametersAndFieldsCandidates);
                    hasThisReferenceInMethodCall.set((Object)ContainerUtil.exists((Object[])methodReference.getParameters(), e -> PhpLangUtil.isThisReference((PsiElement)e)));
                }
                return super.processPhpCallInstruction(instruction);
            }
        });
        int numberOfSourceClassMemberAccessed = accessedClassesStatistics.get((Object)sourceClass).size();
        if (((Boolean)hasThisReferenceInMethodCall.get()).booleanValue() || numberOfSourceClassMemberAccessed > 2) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(3);
            }
            return multiMap;
        }
        MultiMap multiMap = accessedClassesStatistics;
        if (multiMap == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(4);
        }
        return multiMap;
    }

    public static boolean isTestMethod(Method method) {
        return PhpUnitUtil.isTestMethod((Method)method) || PhpFeatureEnvyLocalInspection.hasTestDocAnnotation(method);
    }

    private static boolean hasTestDocAnnotation(Method method) {
        PhpDocComment docComment = method.getDocComment();
        return docComment != null && docComment.getTagElementsByName("@test").length != 0;
    }

    @Nullable
    public static PhpMoveMethodQuickFix createMoveMethodQuickFixWithDialog(@NotNull Method method, PhpNamedElement variable, List<PhpNamedElement> parametersAndFieldsCandidates) {
        PhpClass containingClass;
        if (method == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(5);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return null;
        }
        return new PhpMoveMethodQuickFix(method, variable, parametersAndFieldsCandidates);
    }

    private static void addAccessedClassData(Method method, MemberReference memberReference, MultiMap<PhpNamedElement, PhpClassMember> accessedClassesCounter, @NotNull List<PhpNamedElement> parametersAndFieldsCandidates) {
        Variable variable;
        PsiElement resolvedElement;
        PhpNamedElement resolvedVariable;
        if (parametersAndFieldsCandidates == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(6);
        }
        PsiElement resolve = memberReference.resolve();
        PhpExpression classReference = memberReference.getClassReference();
        if (classReference instanceof Variable && (parametersAndFieldsCandidates.contains(resolvedVariable = (PhpNamedElement)(resolvedElement = (variable = (Variable)classReference).resolve())) || resolvedVariable == method.getContainingClass())) {
            if (resolve instanceof FieldReferenceImpl.DynamicallyDeclaredField) {
                return;
            }
            if (resolve instanceof PhpClassMember) {
                PhpClass accessedClass;
                PhpClassMember member = (PhpClassMember)resolve;
                PhpClass containingClass = method.getContainingClass();
                if (containingClass != null && PhpFeatureEnvyLocalInspection.shouldBeConsidered(containingClass, member) && resolvedVariable != null && (accessedClass = (PhpClass)ContainerUtil.getOnlyItem((Collection)PhpIndex.getInstance((Project)method.getProject()).getClassesByFQN((String)ContainerUtil.getOnlyItem((Collection)resolvedVariable.getType().getTypes())))) != null) {
                    accessedClassesCounter.putValue((Object)resolvedVariable, (Object)member);
                }
            }
        }
    }

    private static boolean shouldBeConsidered(@NotNull PhpClass sourceClass, @NotNull PhpClassMember referencedMember) {
        if (sourceClass == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(7);
        }
        if (referencedMember == null) {
            PhpFeatureEnvyLocalInspection.$$$reportNull$$$0(8);
        }
        GlobalSearchScope librariesOnlyScope = LibraryScopeCache.getInstance((Project)referencedMember.getProject()).getLibrariesOnlyScope();
        PhpClass containingClass = referencedMember.getContainingClass();
        return !librariesOnlyScope.contains(referencedMember.getContainingFile().getVirtualFile()) && (containingClass == null || !PhpClassHierarchyUtils.isSuperClass((PhpClass)containingClass, (PhpClass)sourceClass, (boolean)true) && !PhpClassHierarchyUtils.isMyTrait((PhpClass)sourceClass, (PhpClass)containingClass, null)) && !referencedMember.getModifier().isStatic() && (!(referencedMember instanceof Method) || !PhpMethodMayBeStaticInspection.methodMayBeStatic((Method)((Method)referencedMember)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpFeatureEnvyLocalInspection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersAndFieldsCandidates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpFeatureEnvyLocalInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassStatistics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClassStatistics";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createMoveMethodQuickFixWithDialog";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAccessedClassData";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeConsidered";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

