/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.method;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.CyclomaticComplexityVisitor;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.PhpNestingDepthVisitor;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.metrics.PhpNumberOfVariablesVisitor;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractFunction.PhpExtractMethodQuickfix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.extractMethod.PhpExtractMethodBlockCodeFragment;
import org.jetbrains.annotations.NotNull;

public final class PhpComplexFunctionInspection
extends PhpInspection {
    public int myLocThreshold = 150;
    public int myNestingDepth = 4;
    public int myCyclomaticComplexityThreshold = 15;
    public int myNumberOfUsedVariables = 8;
    public static final int LOC_THRESHOLD = 150;
    public static final int MAX_NESTING_DEPTH = 4;
    public static final int CYCLOMATIC_COMPLEXITY = 15;
    public static final int NUMBER_OF_USED_VARIABLES = 8;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpComplexFunctionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                if (PhpComplexFunctionInspection.isFunctionComplex(function, PhpComplexFunctionInspection.this.myLocThreshold, PhpComplexFunctionInspection.this.myNestingDepth, PhpComplexFunctionInspection.this.myCyclomaticComplexityThreshold, PhpComplexFunctionInspection.this.myNumberOfUsedVariables)) {
                    PhpComplexFunctionInspection.this.registerProblemWithFix(function, holder);
                }
                super.visitPhpFunction(function);
            }

            public void visitPhpMethod(Method method) {
                if (PhpComplexFunctionInspection.isFunctionComplex((Function)method, PhpComplexFunctionInspection.this.myLocThreshold, PhpComplexFunctionInspection.this.myNestingDepth, PhpComplexFunctionInspection.this.myCyclomaticComplexityThreshold, PhpComplexFunctionInspection.this.myNumberOfUsedVariables)) {
                    PhpComplexFunctionInspection.this.registerProblemWithFix((Function)method, holder);
                }
                super.visitPhpMethod(method);
            }
        };
    }

    public static boolean isFunctionComplex(Function function) {
        return PhpComplexFunctionInspection.isFunctionComplex(function, 150, 4, 15, 8);
    }

    private static boolean isFunctionComplex(Function function, int locThreshold, int maxNestingDepthThreshold, int cyclomaticComplexityThreshold, int numberOfUsedVariables) {
        int numberOfVariables;
        int cyclomaticComplexity;
        int nestingDepth;
        int numberOfLines = PhpComplexFunctionInspection.getNumberOfLines(function);
        return numberOfLines > locThreshold && (nestingDepth = PhpComplexFunctionInspection.getMaxNestingDepth(function)) > maxNestingDepthThreshold && (cyclomaticComplexity = PhpComplexFunctionInspection.getCyclomaticComplexity(function)) > cyclomaticComplexityThreshold && (numberOfVariables = PhpComplexFunctionInspection.getNumberOfVariables(function)) > numberOfUsedVariables;
    }

    private void registerProblemWithFix(Function function, @NotNull ProblemsHolder holder) {
        PsiElement nameIdentifier;
        if (holder == null) {
            PhpComplexFunctionInspection.$$$reportNull$$$0(1);
        }
        if ((nameIdentifier = function.getNameIdentifier()) != null) {
            holder.registerProblem(nameIdentifier, PhpArchitectureBundle.message("inspection.php.complex.clazz.message.complex.function.should.be.refactored", new Object[0]), new LocalQuickFix[]{PhpComplexFunctionInspection.getQuickFix(function, this.myLocThreshold, this.myNestingDepth, this.myCyclomaticComplexityThreshold, this.myNumberOfUsedVariables)});
        }
    }

    @NotNull
    public static PhpExtractMethodQuickfix getQuickFix(Function function) {
        return PhpComplexFunctionInspection.getQuickFix(function, 150, 4, 15, 8);
    }

    @NotNull
    private static PhpExtractMethodQuickfix getQuickFix(Function function, int locThreshold, int nestingDepth, int cyclomaticComplexityThreshold, int variables) {
        return new PhpExtractMethodQuickfix((Condition<? super PhpExtractMethodBlockCodeFragment>)((Condition)fragment -> {
            Function functionFromFragment = PhpPsiElementFactory.createFunction((Project)function.getProject(), (String)("function f() {" + fragment.generateCodeText() + "}"));
            return PhpComplexFunctionInspection.getNumberOfLines(functionFromFragment) <= locThreshold || PhpComplexFunctionInspection.getMaxNestingDepth(functionFromFragment) <= nestingDepth || PhpComplexFunctionInspection.getCyclomaticComplexity(functionFromFragment) <= cyclomaticComplexityThreshold || PhpComplexFunctionInspection.getNumberOfVariables(functionFromFragment) <= variables;
        }));
    }

    public static int getNumberOfLines(Function function) {
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)function.getProject());
        Document doc = docManager.getDocument(function.getContainingFile());
        PsiElement groupStatement = PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition)GroupStatement.INSTANCEOF);
        if (doc != null) {
            if (groupStatement != null) {
                return doc.getLineNumber(groupStatement.getLastChild().getTextOffset()) - doc.getLineNumber(groupStatement.getTextOffset()) + 1;
            }
        } else {
            return StringUtil.countNewLines((CharSequence)function.getText()) + 1;
        }
        return 0;
    }

    public static int getCyclomaticComplexity(Function function) {
        CyclomaticComplexityVisitor cyclomaticComplexityVisitor = new CyclomaticComplexityVisitor();
        function.accept((PsiElementVisitor)cyclomaticComplexityVisitor);
        return cyclomaticComplexityVisitor.getValue();
    }

    public static int getMaxNestingDepth(Function function) {
        PhpNestingDepthVisitor nestingDepthVisitor = new PhpNestingDepthVisitor();
        function.accept((PsiElementVisitor)nestingDepthVisitor);
        return nestingDepthVisitor.getMaxNestingDepth();
    }

    private static int getNumberOfVariables(Function function) {
        PhpNumberOfVariablesVisitor numberOfVariablesVisitor = new PhpNumberOfVariablesVisitor(100);
        function.accept((PsiElementVisitor)numberOfVariablesVisitor);
        return numberOfVariablesVisitor.getNumberOfUsedVariables();
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myLocThreshold", (String)PhpArchitectureBundle.message("inspection.php.complex.function.inspection.lines.of.code", new Object[0]), (int)1, (int)10000), OptPane.number((String)"myNestingDepth", (String)PhpArchitectureBundle.message("inspection.php.complex.function.inspection.max.nesting.depth", new Object[0]), (int)1, (int)10000), OptPane.number((String)"myCyclomaticComplexityThreshold", (String)PhpArchitectureBundle.message("inspection.php.complex.function.inspection.cyclomatic.complexity", new Object[0]), (int)1, (int)10000), OptPane.number((String)"myNumberOfUsedVariables", (String)PhpArchitectureBundle.message("inspection.php.complex.function.inspection.number.of.used.variables", new Object[0]), (int)1, (int)10000)});
        if (optPane == null) {
            PhpComplexFunctionInspection.$$$reportNull$$$0(2);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpComplexFunctionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/method/PhpComplexFunctionInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerProblemWithFix";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

