/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.inspections.clazz;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpClassMembersEntitySetMatrix;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.ClassClusteringProvider;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.extractClass.JaccardDistance;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.type.PhpMissingFieldTypeInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpChangeSignatureUsageSearcher;
import com.jetbrains.php.refactoring.extractClass.PhpExtractClassHandler;
import com.jetbrains.php.refactoring.extractClass.PhpExtractMembersToClassDialog;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassHasTooManyDeclaredMembersInspection
extends PhpInspection {
    private static final int MAX_NUMBER_OF_PROPERTIES = 20;
    private static final int MAX_NUMBER_OF_METHODS = 15;
    public int myMaxNumberOfProperties = 20;
    public int myMaxNumberOfMethods = 15;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.number((String)"myMaxNumberOfProperties", (String)PhpArchitectureBundle.message("inspection.options.maximum.number.of.fields", new Object[0]), (int)1, (int)1000), OptPane.number((String)"myMaxNumberOfMethods", (String)PhpArchitectureBundle.message("inspection.options.maximum.number.of.methods", new Object[0]), (int)1, (int)1000)});
        if (optPane == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(1);
        }
        return new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                String message;
                PsiElement nameIdentifier;
                if (!PhpClassHasTooManyDeclaredMembersInspection.isSkipped(clazz) && (nameIdentifier = clazz.getNameIdentifier()) != null && (message = PhpClassHasTooManyDeclaredMembersInspection.this.getWarningMessage(ContainerUtil.filter((Object[])clazz.getOwnFields(), PhpClassHasTooManyDeclaredMembersInspection.isPropertyToConsider()), ContainerUtil.filter((Object[])clazz.getOwnMethods(), PhpClassHasTooManyDeclaredMembersInspection.isMethodToConsider()))) != null) {
                    holder.registerProblem(nameIdentifier, message, new LocalQuickFix[]{PhpClassHasTooManyDeclaredMembersInspection.getExtractClassQuickFix(clazz)});
                }
                super.visitPhpClass(clazz);
            }
        };
    }

    @NotNull
    private static Condition<Field> isPropertyToConsider() {
        Condition condition = field -> !(field instanceof PhpDocProperty) && !field.isConstant() && !PhpMissingFieldTypeInspection.overridesFieldOfParentClass((Field)field);
        if (condition == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(2);
        }
        return condition;
    }

    @NotNull
    private static Condition<Method> isMethodToConsider() {
        Condition condition = method -> !(method instanceof PhpDocMethod) && !PhpLangUtil.isMagicMethod((CharSequence)method.getName()) && PhpChangeSignatureUsageSearcher.findDeepestSuperMethod((Method)method, (boolean)false) == null;
        if (condition == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @Nullable
    @InspectionMessage
    @NlsSafe
    private String getWarningMessage(@NotNull Collection<Field> ownProperties, @NotNull Collection<Method> ownMethods) {
        if (ownProperties == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(4);
        }
        if (ownMethods == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(5);
        }
        if (ownProperties.size() > this.myMaxNumberOfProperties && ownMethods.size() > this.myMaxNumberOfMethods) {
            return PhpArchitectureBundle.message("inspection.message.class.has.too.many.own.properties.0.and.methods.1", ownProperties.size(), ownMethods.size());
        }
        if (ownProperties.size() > this.myMaxNumberOfProperties) {
            return PhpArchitectureBundle.message("inspection.message.class.has.too.many.own.properties", ownProperties.size());
        }
        if (ownMethods.size() > this.myMaxNumberOfMethods) {
            return PhpArchitectureBundle.message("inspection.message.class.has.too.many.own.methods", ownMethods.size());
        }
        return null;
    }

    @NotNull
    public static JaccardDistance<PhpClassMember> createJaccardDistance(List<PhpClassMember> classMembers) {
        PhpClassMembersEntitySetMatrix matrix = new PhpClassMembersEntitySetMatrix(classMembers);
        return new JaccardDistance<PhpClassMember>(matrix.getEntitySets());
    }

    private static boolean isSkipped(PhpClass clazz) {
        return clazz.isInterface() || PhpUnitUtil.isTestClass((PhpClass)clazz);
    }

    @NotNull
    public static LocalQuickFix getExtractClassQuickFix(@NotNull PhpClass containingClass) {
        if (containingClass == null) {
            PhpClassHasTooManyDeclaredMembersInspection.$$$reportNull$$$0(6);
        }
        return new MyLocalQuickFix(containingClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpClassHasTooManyDeclaredMembersInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownProperties";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownMethods";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpClassHasTooManyDeclaredMembersInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "isPropertyToConsider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "isMethodToConsider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWarningMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getExtractClassQuickFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }

    private static class MyLocalQuickFix
    extends LocalQuickFixOnPsiElement {
        private MyLocalQuickFix(@NotNull PhpClass containingClass) {
            if (containingClass == null) {
                MyLocalQuickFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)containingClass);
        }

        public boolean startInWriteAction() {
            return false;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpArchitectureBundle.message("quickfix.name.extract.class", new Object[0]);
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                MyLocalQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(3);
            }
            if (psiFile == null) {
                MyLocalQuickFix.$$$reportNull$$$0(4);
            }
            if (startElement == null) {
                MyLocalQuickFix.$$$reportNull$$$0(5);
            }
            if (endElement == null) {
                MyLocalQuickFix.$$$reportNull$$$0(6);
            }
            Set<PhpClassMember> preselectedMembers = this.getSelectedMembers((PhpClass)this.getStartElement());
            List classMembers = PhpExtractClassHandler.createClassMembersInfo((List)PhpExtractClassHandler.getClassMembers((PhpClass)((PhpClass)this.getStartElement())), preselectedMembers);
            PhpExtractMembersToClassDialog dialog = new PhpExtractMembersToClassDialog(classMembers, false);
            dialog.show();
        }

        public Set<PhpClassMember> getSelectedMembers(PhpClass clazz) {
            List<PhpClassMember> phpClassMembers = PhpExtractClassHandler.getClassMembers((PhpClass)clazz);
            phpClassMembers = ClassClusteringProvider.filterClassMembers(phpClassMembers);
            return ClassClusteringProvider.doClusteringAndGetTheBestCluster(phpClassMembers);
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
            if (project == null) {
                MyLocalQuickFix.$$$reportNull$$$0(7);
            }
            if (previewDescriptor == null) {
                MyLocalQuickFix.$$$reportNull$$$0(8);
            }
            return new IntentionPreviewInfo.Html(PhpArchitectureBundle.message("show.extract.members.to.class.dialog", new Object[0]));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpClassHasTooManyDeclaredMembersInspection$MyLocalQuickFix";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "previewDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/inspections/clazz/PhpClassHasTooManyDeclaredMembersInspection$MyLocalQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "generatePreview";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

