/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.codeSmell.presentation;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.architecture.complexityMetrics.PhpArchitectureBundle;
import com.jetbrains.php.architecture.complexityMetrics.codeSmell.presentation.PhpCodeSmellLineMarkerLogger;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpComplexClassInspection;
import com.jetbrains.php.architecture.complexityMetrics.inspections.clazz.PhpExtractClassQuickFix;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.PhpComplexFunctionInspection;
import com.jetbrains.php.architecture.complexityMetrics.inspections.method.PhpFeatureEnvyLocalInspection;
import com.jetbrains.php.architecture.complexityMetrics.quickFixes.moveMethod.PhpMoveMethodQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CodeSmellLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nullable(value="null means disabled")
    public @Nullable(value="null means disabled") String getName() {
        return PhpArchitectureBundle.message("gutter.name.code.complexity", new Object[0]);
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        PhpClass clazz;
        PsiElement identifier;
        if (element == null) {
            CodeSmellLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (CodeSmellLineMarkerProvider.isEnabledForBuild() && element instanceof Function) {
            PhpMoveMethodQuickFix moveMethodQuickFixWithDialog;
            ArrayList<PhpNamedElement> parametersAndFieldsCandidates;
            Method method;
            PhpNamedElement featureEnvy;
            Function function = (Function)element;
            identifier = function.getNameIdentifier();
            if (PhpComplexFunctionInspection.isFunctionComplex(function) && identifier != null) {
                return new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.SuggestedRefactoringBulb, element1 -> PhpArchitectureBundle.message("quickfix.php.extract.method", new Object[0]), (e, elt) -> {
                    PhpCodeSmellLineMarkerLogger.EXTRACT_METHOD_FIX_STARTED.log(element.getProject());
                    PhpComplexFunctionInspection.getQuickFix((Function)elt.getParent()).runFix(function);
                }, GutterIconRenderer.Alignment.RIGHT, () -> PhpArchitectureBundle.message("quickfix.php.extract.method", new Object[0]));
            }
            if (function instanceof Method && (featureEnvy = PhpFeatureEnvyLocalInspection.findFeatureEnvy(method = (Method)function, parametersAndFieldsCandidates = new ArrayList<PhpNamedElement>())) != null && (moveMethodQuickFixWithDialog = PhpFeatureEnvyLocalInspection.createMoveMethodQuickFixWithDialog(method, featureEnvy, parametersAndFieldsCandidates)) != null && identifier != null) {
                return new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.SuggestedRefactoringBulb, element1 -> moveMethodQuickFixWithDialog.getName(), (e, elt) -> {
                    PhpCodeSmellLineMarkerLogger.MOVE_METHOD_FIX_STARTED.log(element.getProject());
                    moveMethodQuickFixWithDialog.runFix();
                }, GutterIconRenderer.Alignment.RIGHT, () -> PhpArchitectureBundle.message(moveMethodQuickFixWithDialog.getName(), new Object[0]));
            }
        }
        if (element instanceof PhpClass && PhpComplexClassInspection.isClassComplex(clazz = (PhpClass)element) && (identifier = clazz.getNameIdentifier()) != null) {
            return new LineMarkerInfo(identifier, identifier.getTextRange(), AllIcons.Gutter.SuggestedRefactoringBulb, element1 -> PhpArchitectureBundle.message("quickfix.php.extract.class", new Object[0]), (e, elt) -> {
                PhpCodeSmellLineMarkerLogger.EXTRACT_CLASS_FIX_STARTED.log(element.getProject());
                PhpExtractClassQuickFix.doExtractClass(elt.getProject(), (PhpClass)elt.getParent());
            }, GutterIconRenderer.Alignment.RIGHT, () -> PhpArchitectureBundle.message("quickfix.php.extract.class", new Object[0]));
        }
        return null;
    }

    private static boolean isEnabledForBuild() {
        Application application = ApplicationManager.getApplication();
        return application.isUnitTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/architecture/complexityMetrics/codeSmell/presentation/CodeSmellLineMarkerProvider", "getLineMarkerInfo"));
    }
}

