/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.architecture.complexityMetrics.calculators;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldInObjectContextInstruction;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LCOM1MetricsCalculator {
    private final Method[] myMethodsToAnalyze;

    public LCOM1MetricsCalculator(PhpClass aClass) {
        this.myMethodsToAnalyze = (Method[])Arrays.stream(aClass.getOwnMethods()).filter(e -> !PhpLangUtil.isMagicMethod((CharSequence)e.getName()) && !e.isAbstract()).toArray(Method[]::new);
    }

    public static double getLcom1MetricValue(Map<Method, Set<Field>> dependencies, int numberOfIntersectingMethods) {
        double lcom = 0.0;
        if (dependencies.size() > 1) {
            int numberOfAllPairs = dependencies.size() * (dependencies.size() - 1);
            lcom = (double)(numberOfAllPairs - numberOfIntersectingMethods) / (double)numberOfAllPairs;
        }
        return lcom;
    }

    public double getLcom() {
        HashMap<Method, Set<Field>> dependencies = new HashMap<Method, Set<Field>>();
        int numberOfIntersectingMethods = this.getNumberOfIntersectingMethods(dependencies);
        return LCOM1MetricsCalculator.getLcom1MetricValue(dependencies, numberOfIntersectingMethods);
    }

    private static void addFieldUsage(Field field, Method method, Map<Method, Set<Field>> dependencies) {
        if (field != null && field.getContainingClass() == method.getContainingClass()) {
            Set<Field> set = dependencies.get(method);
            if (set == null) {
                dependencies.put(method, new HashSet());
                set = dependencies.get(method);
            }
            set.add(field);
        }
    }

    public int getNumberOfIntersectingMethods(@NotNull Map<Method, Set<Field>> dependencies) {
        if (dependencies == null) {
            LCOM1MetricsCalculator.$$$reportNull$$$0(0);
        }
        this.calculateDependencies(dependencies);
        int numberOfIntersectingMethods = 0;
        for (Method it1 : dependencies.keySet()) {
            for (Method it2 : dependencies.keySet()) {
                if (it1 == it2 || !ContainerUtil.intersects((Collection)dependencies.get(it1), (Collection)dependencies.get(it2))) continue;
                ++numberOfIntersectingMethods;
            }
        }
        return numberOfIntersectingMethods;
    }

    private void calculateDependencies(final @NotNull Map<Method, Set<Field>> dependencies) {
        if (dependencies == null) {
            LCOM1MetricsCalculator.$$$reportNull$$$0(1);
        }
        for (final Method method : this.myMethodsToAnalyze) {
            PhpControlFlowUtil.processFlow((PhpControlFlow)method.getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

                public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
                    Field field;
                    PsiElement resolvedElement;
                    FieldReference fieldReference = instruction.getFieldReference();
                    if (fieldReference != null && (resolvedElement = fieldReference.resolve()) instanceof Field && (field = (Field)resolvedElement).getContainingClass() == method.getContainingClass()) {
                        LCOM1MetricsCalculator.addFieldUsage(field, method, dependencies);
                    }
                    return super.processAccessFieldByVariableInstruction(instruction);
                }

                public boolean processAccessFieldInObjectContextInstruction(PhpAccessFieldInObjectContextInstruction instruction) {
                    FieldReference fieldReference = (FieldReference)instruction.getAnchor();
                    Field field = (Field)fieldReference.resolve();
                    if (field != null && field.getContainingClass() == method.getContainingClass()) {
                        LCOM1MetricsCalculator.addFieldUsage(field, method, dependencies);
                    }
                    return super.processAccessFieldInObjectContextInstruction(instruction);
                }
            });
        }
    }

    public double getTCC() {
        HashMap<Method, Set<Field>> dependencies = new HashMap<Method, Set<Field>>();
        int numberOfIntersectingMethods = this.getNumberOfIntersectingMethods(dependencies);
        double tcc = 0.0;
        if (dependencies.size() > 1) {
            int numberOfAllPairs = dependencies.size() * (dependencies.size() - 1);
            tcc = (double)numberOfIntersectingMethods / (double)numberOfAllPairs;
        }
        return tcc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "dependencies";
        objectArray2[1] = "com/jetbrains/php/architecture/complexityMetrics/calculators/LCOM1MetricsCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNumberOfIntersectingMethods";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

