/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileHeaderInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FileHeaderInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){
            JoomlaDataService service;
            final boolean serviceEnabled;
            {
                this.service = JoomlaDataService.getInstance(holder.getProject());
                this.serviceEnabled = this.service.isEnabled();
            }

            public void visitPhpFile(PhpFile phpFile) {
                this.checkFileCopyright(phpFile, holder, JoomlaBundle.message("joomla.inspection.missing.copyright.tag", new Object[0]));
                this.checkFileLicense(phpFile, holder, JoomlaBundle.message("joomla.inspection.missing.license.tag", new Object[0]));
            }

            private void checkFileLicense(PhpFile file, ProblemsHolder holder2, @InspectionMessage String message) {
                if (!this.serviceEnabled) {
                    return;
                }
                PhpDocComment docComment = FileHeaderInspection.getFileComment(file);
                if (FileHeaderInspection.isHeaderWithoutLicenseTag(docComment)) {
                    holder2.registerProblem((PsiElement)docComment, message, new LocalQuickFix[0]);
                }
            }

            private void checkFileCopyright(PhpFile file, ProblemsHolder holder2, @InspectionMessage String message) {
                if (!this.serviceEnabled) {
                    return;
                }
                PhpDocComment docComment = FileHeaderInspection.getFileComment(file);
                if (FileHeaderInspection.isHeaderWithoutCopyrightTag(docComment)) {
                    holder2.registerProblem((PsiElement)docComment, message, new LocalQuickFix[0]);
                }
            }
        };
    }

    @Nullable
    private static PhpDocComment getFileComment(PhpFile constElement) {
        PsiElement nextSiblingIgnoreWhitespace;
        PsiElement firstChild = constElement.getFirstChild();
        if (!(firstChild instanceof GroupStatement)) {
            return null;
        }
        PsiElement firstFirstChild = firstChild.getFirstChild();
        if (PhpPsiUtil.isOfType((PsiElement)firstFirstChild, (IElementType)PhpTokenTypes.PHP_OPENING_TAG) && (nextSiblingIgnoreWhitespace = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)firstFirstChild, (boolean)true)) instanceof PhpDocComment) {
            return (PhpDocComment)nextSiblingIgnoreWhitespace;
        }
        return null;
    }

    private static boolean isHeaderWithoutCopyrightTag(@Nullable PhpDocComment docComment) {
        return docComment != null && !PhpDocUtil.hasDocTagWithName((PhpDocComment)docComment, (String)"@copyright");
    }

    private static boolean isHeaderWithoutLicenseTag(@Nullable PhpDocComment docComment) {
        return docComment != null && !PhpDocUtil.hasDocTagWithName((PhpDocComment)docComment, (String)"@license");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/joomla/inspections/FileHeaderInspection", "buildVisitor"));
    }
}

