/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.makefile.MakefileSyntaxHighlighter;
import com.jetbrains.lang.makefile.psi.MakefileFunction;
import com.jetbrains.lang.makefile.psi.MakefileFunctionName;
import com.jetbrains.lang.makefile.psi.MakefilePrerequisite;
import com.jetbrains.lang.makefile.psi.MakefileRecipe;
import com.jetbrains.lang.makefile.psi.MakefileRule;
import com.jetbrains.lang.makefile.psi.MakefileString;
import com.jetbrains.lang.makefile.psi.MakefileTarget;
import com.jetbrains.lang.makefile.psi.MakefileTypes;
import com.jetbrains.lang.makefile.psi.MakefileVariable;
import com.jetbrains.lang.makefile.psi.MakefileVariableUsage;
import com.jetbrains.lang.makefile.psi.MakefileVariableValue;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001c\u0010\u000e\u001a\u00020\t*\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u000e\u001a\u00020\t*\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\u0015H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/lang/makefile/MakefileAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "lineTokenSet", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "mark", "attr", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "node", "Lcom/intellij/lang/ASTNode;", "isUnused", "", "Lcom/jetbrains/lang/makefile/psi/MakefileRule;", "intellij.makefile"})
@SourceDebugExtension(value={"SMAP\nMakefileAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MakefileAnnotator.kt\ncom/jetbrains/lang/makefile/MakefileAnnotator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n13472#2,2:63\n1761#3,3:65\n*S KotlinDebug\n*F\n+ 1 MakefileAnnotator.kt\ncom/jetbrains/lang/makefile/MakefileAnnotator\n*L\n32#1:63,2\n54#1:65,3\n*E\n"})
public final class MakefileAnnotator
implements Annotator,
DumbAware {
    @NotNull
    private final TokenSet lineTokenSet;

    public MakefileAnnotator() {
        IElementType[] iElementTypeArray = new IElementType[]{MakefileTypes.IDENTIFIER};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.lineTokenSet = tokenSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof MakefileTarget) {
            PsiElement psiElement = ((MakefileTarget)element).getParent().getParent().getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.lang.makefile.psi.MakefileRule");
            if (!this.isUnused((MakefileRule)psiElement)) {
                this.mark(holder, element, ((MakefileTarget)element).isSpecialTarget() ? MakefileSyntaxHighlighter.Companion.getSPECIAL_TARGET() : MakefileSyntaxHighlighter.Companion.getTARGET());
                return;
            }
        }
        if (element instanceof MakefilePrerequisite) {
            this.mark(holder, element, MakefileSyntaxHighlighter.Companion.getPREREQUISITE());
            return;
        }
        if (element instanceof MakefileVariable) {
            this.mark(holder, element, MakefileSyntaxHighlighter.Companion.getVARIABLE());
            return;
        }
        if (element instanceof MakefileVariableValue) {
            ASTNode[] aSTNodeArray = ((MakefileVariableValue)element).getNode().getChildren(this.lineTokenSet);
            Intrinsics.checkNotNullExpressionValue((Object)aSTNodeArray, (String)"getChildren(...)");
            Object[] $this$forEach$iv = aSTNodeArray;
            boolean $i$f$forEach = false;
            int n = 0;
            int n2 = $this$forEach$iv.length;
            while (n < n2) {
                Object element$iv = $this$forEach$iv[n];
                ASTNode it = (ASTNode)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                this.mark(holder, it, MakefileSyntaxHighlighter.Companion.getVARIABLE_VALUE());
                ++n;
            }
            return;
        }
        if (element instanceof MakefileFunctionName && ((MakefileFunctionName)element).getParent() instanceof MakefileFunction) {
            this.mark(holder, element, MakefileSyntaxHighlighter.Companion.getFUNCTION());
            return;
        }
        if (element instanceof MakefileString) {
            this.mark(holder, element, MakefileSyntaxHighlighter.Companion.getSTRING());
            return;
        }
        if (!(element instanceof MakefileVariableUsage)) return;
        this.mark(holder, element, MakefileSyntaxHighlighter.Companion.getVARIABLE());
    }

    private final void mark(AnnotationHolder $this$mark, PsiElement element, TextAttributesKey attr) {
        $this$mark.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).textAttributes(attr).create();
    }

    private final void mark(AnnotationHolder $this$mark, ASTNode node, TextAttributesKey attr) {
        $this$mark.newSilentAnnotation(HighlightSeverity.INFORMATION).range(node).textAttributes(attr).create();
    }

    private final boolean isUnused(MakefileRule $this$isUnused) {
        boolean bl;
        block8: {
            MakefileRecipe makefileRecipe = $this$isUnused.getRecipe();
            boolean bl2 = makefileRecipe != null ? !makefileRecipe.isEmpty() : false;
            if (bl2) {
                return false;
            }
            List<MakefileTarget> list = $this$isUnused.getTargetLine().getTargets().getTargetList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getTargetList(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MakefileTarget it = (MakefileTarget)element$iv;
                    boolean bl3 = false;
                    if (!(it.isSpecialTarget() || it.isPatternTarget())) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Object object = $this$isUnused.getTargetLine().getPrerequisites();
        boolean bl4 = object != null && (object = object.getNormalPrerequisites()) != null && (object = object.getPrerequisiteList()) != null ? CollectionsKt.any((Iterable)((Iterable)object)) : false;
        if (bl4) {
            return false;
        }
        Object object2 = $this$isUnused.getTargetLine().getPrerequisites();
        boolean bl5 = object2 != null && (object2 = object2.getOrderOnlyPrerequisites()) != null && (object2 = object2.getPrerequisiteList()) != null ? CollectionsKt.any((Iterable)((Iterable)object2)) : false;
        if (bl5) {
            return false;
        }
        if ($this$isUnused.getTargetLine().getVariableAssignment() != null) {
            return false;
        }
        return $this$isUnused.getTargetLine().getPrivatevar() == null;
    }
}

