/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.blade.injection.BladeInjectionInfo;
import com.jetbrains.php.blade.injection.BladeInjectionMappingService;
import com.jetbrains.php.blade.psi.BladeTokenSets;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.highlighter.PhpHighlightingLexer;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeCustomizedLexer
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(BladeCustomizedLexer.class);
    private static final int PHP_STATE_CONSTANT;
    private final Matcher[] myInitialMatchers;
    private final char[] myHtmlStopChars;
    private final String myTextBlockEndDelimiter;
    private final String myRawTextBlockEndDelimiter;
    private final String myEscapedTextBlockEndDelimiter;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private State myState;
    private State myNextState;
    private IElementType myTokenType;
    private int myTokenStart;
    private int myTokenEnd;
    private int directiveParenCounter;
    private PhpHighlightingLexer myPhpLexer;

    public static BladeCustomizedLexer newInstance(@Nullable Project project) {
        return (BladeCustomizedLexer)((Object)Cancellation.computeInNonCancelableSection(() -> {
            BladeInjectionMappingService service = BladeInjectionMappingService.getInstance(project);
            BladeInjectionMappingService.BladeState state = service.getState();
            return new BladeCustomizedLexer(state.getTextBlockStart(), state.getTextBlockEnd(), state.getRawTextBlockStart(), state.getRawTextBlockEnd(), state.getEscapedTextBlockStart(), state.getEscapedTextBlockEnd(), service.getDirectiveInfos());
        }));
    }

    /*
     * WARNING - void declaration
     */
    private BladeCustomizedLexer(String textBlockStartDelimiter, String textBlockEndDelimiter, String rawTextBlockStartDelimiter, String rawTextBlockEndDelimiter, String escapedTextBlockStartDelimiter, String escapedTextBlockEndDelimiter, Map<String, BladeInjectionInfo> list) {
        this.myTextBlockEndDelimiter = textBlockEndDelimiter;
        this.myRawTextBlockEndDelimiter = rawTextBlockEndDelimiter;
        this.myEscapedTextBlockEndDelimiter = escapedTextBlockEndDelimiter;
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.add(new CommentMatcher());
        HashSet<String> directives = new HashSet<String>();
        for (String string : list.keySet()) {
            directives.add(StringUtil.toLowerCase((String)string));
        }
        matchers.add(new DirectiveMatcher(directives));
        if (BladeCustomizedLexer.isMatcherReasonable(textBlockStartDelimiter, textBlockEndDelimiter)) {
            matchers.add(0, new SomeTextBlockMatcher(textBlockStartDelimiter, BladeTokenTypes.TEXT_BLOCK_START, State.TEXT_BLOCK));
        }
        if (BladeCustomizedLexer.isMatcherReasonable(escapedTextBlockStartDelimiter, escapedTextBlockEndDelimiter)) {
            matchers.add(0, new SomeTextBlockMatcher(escapedTextBlockStartDelimiter, BladeTokenTypes.ESCAPED_TEXT_BLOCK_START, State.ESCAPED_TEXT_BLOCK));
        }
        if (BladeCustomizedLexer.isMatcherReasonable(rawTextBlockStartDelimiter, rawTextBlockEndDelimiter)) {
            matchers.add(0, new SomeTextBlockMatcher(rawTextBlockStartDelimiter, BladeTokenTypes.RAW_TEXT_BLOCK_START, State.RAW_TEXT_BLOCK));
        }
        this.myInitialMatchers = matchers.toArray(new Matcher[0]);
        HashSet<Character> htmlStopChars = new HashSet<Character>();
        for (Matcher matcher : this.myInitialMatchers) {
            matcher.registerHtmlStopChars(htmlStopChars);
        }
        this.myHtmlStopChars = new char[htmlStopChars.size()];
        boolean bl = false;
        for (Character aChar : htmlStopChars) {
            void var11_14;
            this.myHtmlStopChars[var11_14] = aChar.charValue();
            ++var11_14;
        }
    }

    private static boolean isMatcherReasonable(@Nullable String start, @Nullable String end) {
        return BladeCustomizedLexer.isDelimiterReasonable(start) && BladeCustomizedLexer.isDelimiterReasonable(end);
    }

    public static boolean isDelimiterReasonable(@Nullable String delimiter) {
        return !StringUtil.isEmptyOrSpaces((String)delimiter);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BladeCustomizedLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = buffer;
        this.myTokenType = null;
        this.myTokenStart = startOffset;
        this.myTokenEnd = startOffset;
        this.myBufferEnd = endOffset;
        int state = initialState % PHP_STATE_CONSTANT;
        int phpState = initialState / PHP_STATE_CONSTANT;
        this.myPhpLexer = new PhpHighlightingLexer();
        this.myPhpLexer.start(this.myBuffer, this.myTokenStart, this.myBufferEnd, phpState);
        this.myNextState = this.myState = State.getByCode(initialState, state);
    }

    public int getState() {
        if (this.myTokenType == null) {
            this.locateToken();
            if (this.myTokenStart < this.myBufferEnd) {
                LOG.assertTrue(this.myTokenType != null);
                LOG.assertTrue(this.myState != null);
            }
        }
        int state = this.myState.getCode();
        int phpState = this.myPhpLexer.getState();
        return state + phpState * PHP_STATE_CONSTANT;
    }

    @Nullable
    public IElementType getTokenType() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenType;
    }

    public int getTokenStart() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenStart;
    }

    public int getTokenEnd() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        return this.myTokenEnd;
    }

    public void advance() {
        if (this.myTokenType == null) {
            this.locateToken();
        }
        this.myTokenType = null;
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            BladeCustomizedLexer.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    private void locateToken() {
        if (this.myTokenType != null) {
            return;
        }
        this.myTokenStart = this.myTokenEnd;
        if (this.myTokenStart >= this.myBufferEnd) {
            return;
        }
        this.myState = this.myNextState;
        switch (this.myState) {
            case ESCAPED_TEXT_BLOCK: {
                if (BladeCustomizedLexer.isDelimiterReasonable(this.myEscapedTextBlockEndDelimiter)) {
                    this.matchInTextBlock(this.myEscapedTextBlockEndDelimiter, BladeTokenTypes.ESCAPED_TEXT_BLOCK_CONTENT, BladeTokenTypes.ESCAPED_TEXT_BLOCK_END);
                    return;
                }
            }
            case TEXT_BLOCK: {
                if (BladeCustomizedLexer.isDelimiterReasonable(this.myTextBlockEndDelimiter)) {
                    this.matchInTextBlock(this.myTextBlockEndDelimiter, BladeTokenTypes.TEXT_BLOCK_CONTENT, BladeTokenTypes.TEXT_BLOCK_END);
                    return;
                }
            }
            case RAW_TEXT_BLOCK: {
                if (BladeCustomizedLexer.isDelimiterReasonable(this.myRawTextBlockEndDelimiter)) {
                    this.matchInTextBlock(this.myRawTextBlockEndDelimiter, BladeTokenTypes.RAW_TEXT_BLOCK_CONTENT, BladeTokenTypes.RAW_TEXT_BLOCK_END);
                    return;
                }
            }
            case AFTER_DIRECTIVE: {
                if (!this.handleAfterDirective()) break;
                return;
            }
            case AFTER_PHP_DIRECTIVE: {
                this.handleAfterDirective();
                if (this.myNextState == State.IN_DIRECTIVE_PARAMETERS) {
                    return;
                }
                this.myNextState = State.AFTER_PHP_DIRECTIVE;
                if (!this.handleAfterPhpDirective()) break;
                return;
            }
            case IN_DIRECTIVE_PARAMETERS: {
                if (!this.handleInDirectiveParameters()) break;
                return;
            }
            case YYINITIAL: {
                if (!this.handleInitial()) break;
                return;
            }
        }
        this.myTokenEnd = this.myTokenStart + 1;
        this.myTokenType = BladeTokenTypes.BAD_CHARACTER;
        this.myNextState = State.YYINITIAL;
    }

    private boolean handleInitial() {
        int bestLength = 0;
        Matcher bestMatcher = null;
        if (this.myPhpLexer.getTokenEnd() == this.myTokenStart) {
            this.myPhpLexer.advance();
        } else if (this.myPhpLexer.getTokenEnd() < this.myTokenStart) {
            this.myPhpLexer.start(this.myBuffer, this.myTokenStart, this.myBufferEnd, 0);
        }
        if (BladeCustomizedLexer.isPhpLexerStateUnrestartable(this.myPhpLexer)) {
            return this.setMatchBasedOnPhpLexer();
        }
        Pair<Integer, IElementType> match = this.findMatchInsideHtml();
        if (match != null) {
            return this.setMatch((Integer)match.first, (IElementType)match.second);
        }
        for (Matcher matcher : this.myInitialMatchers) {
            int length = matcher.match();
            if (length <= bestLength) continue;
            bestLength = length;
            bestMatcher = matcher;
        }
        if (bestMatcher == null) {
            LOG.assertTrue(this.myPhpLexer.getTokenEnd() > this.myTokenStart, (Object)("PhpLexer " + this.myPhpLexer.getTokenEnd() + ", myTokenStart " + this.myTokenStart));
            match = this.findMatchInsideHtmlWithFirstSymbolNotConsideredSuspicious();
            if (match != null) {
                return this.setMatch((Integer)match.first, (IElementType)match.second);
            }
            return this.setMatch(this.myPhpLexer.getTokenEnd(), BladeTokenTypes.TEMPLATE_PHP_TEXT);
        }
        this.myTokenEnd = this.myTokenStart + bestLength;
        bestMatcher.apply(bestLength);
        return true;
    }

    @Nullable
    private Pair<Integer, IElementType> findMatchInsideHtml() {
        if (this.myPhpLexer.getTokenType() == PhpTokenTypes.HTML && this.myPhpLexer.getTokenStart() <= this.myTokenStart && this.myPhpLexer.getTokenEnd() > this.myTokenStart) {
            int offset;
            int tokenEnd = this.myPhpLexer.getTokenEnd();
            for (offset = this.myTokenStart; offset < tokenEnd && Character.isWhitespace(this.myBuffer.charAt(offset)); ++offset) {
            }
            if (offset > this.myTokenStart) {
                return Pair.create((Object)offset, (Object)BladeTokenTypes.WHITESPACE);
            }
            while (offset < tokenEnd && !this.isSuspiciousChar(this.myBuffer.charAt(offset))) {
                ++offset;
            }
            if (offset > this.myTokenStart) {
                return Pair.create((Object)offset, (Object)BladeTokenTypes.TEMPLATE_HTML_TEXT);
            }
        }
        return null;
    }

    @Nullable
    private Pair<Integer, IElementType> findMatchInsideHtmlWithFirstSymbolNotConsideredSuspicious() {
        if (this.myPhpLexer.getTokenType() == PhpTokenTypes.HTML && this.myPhpLexer.getTokenStart() <= this.myTokenStart && this.myPhpLexer.getTokenEnd() > this.myTokenStart) {
            int offset;
            int tokenEnd = this.myPhpLexer.getTokenEnd();
            for (offset = this.myTokenStart; !(offset >= tokenEnd || offset != this.myTokenStart && this.isSuspiciousChar(this.myBuffer.charAt(offset))); ++offset) {
            }
            if (offset > this.myTokenStart) {
                return Pair.create((Object)offset, (Object)BladeTokenTypes.TEMPLATE_HTML_TEXT);
            }
        }
        return null;
    }

    private boolean isSuspiciousChar(char c) {
        for (char aChar : this.myHtmlStopChars) {
            if (aChar != c) continue;
            return true;
        }
        return false;
    }

    private boolean setMatchBasedOnPhpLexer() {
        IElementType type = this.myPhpLexer.getTokenType();
        if (type == PhpTokenTypes.HTML) {
            return this.setMatch(this.myPhpLexer.getTokenEnd(), BladeTokenTypes.TEMPLATE_HTML_TEXT);
        }
        return this.setMatch(this.myPhpLexer.getTokenEnd(), BladeTokenTypes.TEMPLATE_PHP_TEXT);
    }

    private static boolean isPhpLexerStateUnrestartable(PhpHighlightingLexer lexer) {
        int state = lexer.getState();
        return state != lexer.getStartState() && !lexer.isRestartableState(state);
    }

    private boolean handleInDirectiveParameters() {
        int offset = this.myTokenStart;
        char c = this.myBuffer.charAt(offset);
        if (c == '(') {
            ++this.directiveParenCounter;
            if (this.directiveParenCounter == 1) {
                return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_LBRACE);
            }
            return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        }
        if (c == ')') {
            --this.directiveParenCounter;
            if (this.directiveParenCounter <= 0) {
                this.myNextState = State.YYINITIAL;
                return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_RBRACE);
            }
            return this.setMatch(offset + 1, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
        }
        do {
            if (c == '\'' || c == '\"') {
                offset = this.handleStringLiteral(c, offset + 1);
                continue;
            }
            ++offset;
        } while (offset < this.myBufferEnd && (c = this.myBuffer.charAt(offset)) != '(' && c != ')');
        return this.setMatch(offset, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT);
    }

    private int handleStringLiteral(char endingQuote, int offset) {
        while (offset < this.myBufferEnd) {
            char c = this.myBuffer.charAt(offset);
            if ('\\' == c && offset + 1 < this.myBufferEnd) {
                ++offset;
            } else if (endingQuote == c) {
                return Math.min(offset + 1, this.myBufferEnd);
            }
            ++offset;
        }
        return offset;
    }

    private boolean handleAfterDirective() {
        char c;
        int offset = this.myTokenStart;
        do {
            c = this.myBuffer.charAt(offset);
        } while (++offset < this.myBufferEnd && Character.isWhitespace(c));
        if (c == '(' || c == ')') {
            this.myNextState = State.IN_DIRECTIVE_PARAMETERS;
            this.directiveParenCounter = 0;
        } else {
            this.myNextState = State.YYINITIAL;
        }
        return this.setMatch(offset == this.myBufferEnd && Character.isWhitespace(c) ? offset : offset - 1, BladeTokenTypes.WHITESPACE);
    }

    private boolean handleAfterPhpDirective() {
        int offset;
        for (offset = this.myTokenStart; offset < this.myBufferEnd && Character.isWhitespace(this.myBuffer.charAt(offset)); ++offset) {
        }
        if (offset > this.myTokenStart) {
            return this.setMatch(offset, BladeTokenTypes.WHITESPACE);
        }
        while (offset < this.myBufferEnd && !this.bufferMatches(offset, "@endphp")) {
            ++offset;
        }
        if (offset == this.myTokenStart) {
            this.myState = State.YYINITIAL;
            return this.handleInitial();
        }
        if (this.bufferMatches(offset, "@endphp")) {
            while (offset > this.myTokenStart && Character.isWhitespace(this.myBuffer.charAt(offset - 1))) {
                --offset;
            }
        }
        this.myNextState = State.YYINITIAL;
        return this.setMatch(offset, BladeTokenTypes.PHP_DIRECTIVE_CONTENT);
    }

    private boolean bufferMatches(int offset, String text) {
        if (offset > this.myBufferEnd - text.length()) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (this.myBuffer.charAt(offset + i) == text.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void matchInTextBlock(String endDelimiter, IElementType contentType, IElementType endType) {
        int offset;
        if (CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)this.myTokenStart, (int)this.myBufferEnd, (CharSequence)endDelimiter)) {
            this.setMatch(this.myTokenStart + endDelimiter.length(), endType);
            this.myNextState = State.YYINITIAL;
            return;
        }
        for (offset = this.myTokenStart + 1; offset < this.myBufferEnd && !CharArrayUtil.regionMatches((CharSequence)this.myBuffer, (int)offset, (int)this.myBufferEnd, (CharSequence)endDelimiter); ++offset) {
        }
        this.setMatch(offset, contentType);
    }

    private boolean setMatch(int endOffset, IElementType tokenType) {
        this.myTokenEnd = endOffset;
        this.myTokenType = tokenType;
        return true;
    }

    static {
        int max = 0;
        for (State state : State.values()) {
            max = Math.max(max, state.code);
        }
        PHP_STATE_CONSTANT = max + 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/lexer/BladeCustomizedLexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/lexer/BladeCustomizedLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class CommentMatcher
    implements Matcher {
        public static final String START_DELIMITER = "{{--";

        private CommentMatcher() {
        }

        @Override
        public int match() {
            int offset = BladeCustomizedLexer.this.myTokenStart;
            String startDelimiter = START_DELIMITER;
            String endDelimiter = "--}}";
            if (CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)offset, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)startDelimiter)) {
                offset += startDelimiter.length();
                char firstCharInSuffix = endDelimiter.charAt(0);
                while (offset < BladeCustomizedLexer.this.myBufferEnd) {
                    char c = BladeCustomizedLexer.this.myBuffer.charAt(offset);
                    if (c == firstCharInSuffix && CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)offset, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)endDelimiter)) {
                        return offset + endDelimiter.length() - BladeCustomizedLexer.this.myTokenStart;
                    }
                    ++offset;
                }
                return BladeCustomizedLexer.this.myBufferEnd - BladeCustomizedLexer.this.myTokenStart;
            }
            return -1;
        }

        @Override
        public void apply(int length) {
            BladeCustomizedLexer.this.myTokenType = BladeTokenTypes.COMMENT;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            chars.add(Character.valueOf(START_DELIMITER.charAt(0)));
        }
    }

    private final class DirectiveMatcher
    implements Matcher {
        private final Set<String> myDirectives;

        private DirectiveMatcher(Set<String> directives) {
            this.myDirectives = directives;
        }

        @Override
        public int match() {
            String directiveText;
            int offset = BladeCustomizedLexer.this.myTokenStart;
            char c = BladeCustomizedLexer.this.myBuffer.charAt(offset);
            if (c != '@') {
                return -1;
            }
            while (++offset < BladeCustomizedLexer.this.myBufferEnd && ((c = BladeCustomizedLexer.this.myBuffer.charAt(offset)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '-')) {
            }
            if (offset > BladeCustomizedLexer.this.myTokenStart && !this.myDirectives.contains(StringUtil.toLowerCase((String)(directiveText = BladeCustomizedLexer.this.myBuffer.subSequence(BladeCustomizedLexer.this.myTokenStart, offset).toString())))) {
                return -1;
            }
            return offset - BladeCustomizedLexer.this.myTokenStart;
        }

        @Override
        public void apply(int length) {
            String directiveText = BladeCustomizedLexer.this.myBuffer.subSequence(BladeCustomizedLexer.this.myTokenStart, BladeCustomizedLexer.this.myTokenEnd).toString();
            IElementType result = BladeTokenSets.getDirectiveType(directiveText);
            BladeCustomizedLexer.this.myNextState = result == BladeTokenTypes.PHP_DIRECTIVE ? State.AFTER_PHP_DIRECTIVE : State.AFTER_DIRECTIVE;
            BladeCustomizedLexer.this.myTokenType = result == null ? BladeTokenTypes.CUSTOM_DIRECTIVE : result;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            chars.add(Character.valueOf('@'));
        }
    }

    private final class SomeTextBlockMatcher
    implements Matcher {
        private final String prefix;
        private final IElementType type;
        private final State newState;

        private SomeTextBlockMatcher(String prefix, IElementType type, State newState) {
            this.prefix = prefix;
            this.type = type;
            this.newState = newState;
        }

        @Override
        public int match() {
            if (CharArrayUtil.regionMatches((CharSequence)BladeCustomizedLexer.this.myBuffer, (int)BladeCustomizedLexer.this.myTokenStart, (int)BladeCustomizedLexer.this.myBufferEnd, (CharSequence)this.prefix)) {
                if (BladeCustomizedLexer.this.myTokenStart > 0 && BladeCustomizedLexer.this.myBuffer.charAt(BladeCustomizedLexer.this.myTokenStart - 1) == '@') {
                    return -1;
                }
                return this.prefix.length();
            }
            return -1;
        }

        @Override
        public void apply(int length) {
            BladeCustomizedLexer.this.myNextState = this.newState;
            BladeCustomizedLexer.this.myTokenType = this.type;
        }

        @Override
        public void registerHtmlStopChars(Collection<Character> chars) {
            chars.add(Character.valueOf(this.prefix.charAt(0)));
        }
    }

    private static enum State {
        YYINITIAL(0),
        TEXT_BLOCK(2),
        ESCAPED_TEXT_BLOCK(4),
        RAW_TEXT_BLOCK(6),
        AFTER_DIRECTIVE(8),
        IN_DIRECTIVE_PARAMETERS(10),
        AFTER_PHP_DIRECTIVE(12);

        private final int code;

        private State(int code) {
            this.code = code;
        }

        static State getByCode(int code, int initialCode) throws IllegalStateException {
            for (State state : State.values()) {
                if (code != state.code) continue;
                return state;
            }
            LOG.error("Unexpected code " + code + ", initial code " + initialCode);
            throw new IllegalStateException("Unexpected code " + code + ", initial code " + initialCode);
        }

        public int getCode() {
            return this.code;
        }
    }

    private static interface Matcher {
        public int match();

        public void apply(int var1);

        public void registerHtmlStopChars(Collection<Character> var1);
    }
}

