/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.blade.BladeBundle;
import com.jetbrains.php.blade.BladeLanguage;
import com.jetbrains.php.blade.inspections.BladeInspection;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public final class BladeUnpairedParenthesesInStringLiteralInspection
extends BladeInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            BladeUnpairedParenthesesInStringLiteralInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            BladeUnpairedParenthesesInStringLiteralInspection.$$$reportNull$$$0(1);
        }
        return new PhpElementVisitor(){

            public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
                InjectedLanguageManager injectionManager = InjectedLanguageManager.getInstance((Project)expression.getProject());
                PsiFile topLevelFile = injectionManager.getTopLevelFile((PsiElement)expression);
                if (BladeLanguage.INSTANCE != topLevelFile.getLanguage()) {
                    return;
                }
                PsiLanguageInjectionHost injectionHost = injectionManager.getInjectionHost((PsiElement)expression);
                if (injectionHost == null) {
                    return;
                }
                int hostOffset = injectionManager.injectedToHost((PsiElement)expression, expression.getTextOffset());
                PsiElement hostElement = injectionHost.findElementAt(hostOffset);
                if (BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT != PsiUtilCore.getElementType((PsiElement)hostElement)) {
                    return;
                }
                int invalidParenIndex = BladeUnpairedParenthesesInStringLiteralInspection.checkParentheses(expression.getText());
                if (invalidParenIndex >= 0) {
                    holder.registerProblem((PsiElement)expression, new TextRange(invalidParenIndex, invalidParenIndex), BladeBundle.message("inspection.unpaired.parentheses.in.string.literals", new Object[0]), new LocalQuickFix[0]);
                }
            }
        };
    }

    private static int checkParentheses(@NotNull String s) {
        if (s == null) {
            BladeUnpairedParenthesesInStringLiteralInspection.$$$reportNull$$$0(2);
        }
        int opened = 0;
        int lastParen = -1;
        for (int i = 0; i < s.length(); ++i) {
            if ('(' == s.charAt(i)) {
                lastParen = i;
                ++opened;
                continue;
            }
            if (')' != s.charAt(i)) continue;
            lastParen = i;
            if (opened == 0) {
                return lastParen;
            }
            --opened;
        }
        return opened == 0 ? -1 : lastParen;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/blade/inspections/BladeUnpairedParenthesesInStringLiteralInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkParentheses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

