/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTokenTypes;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BladeInjectionInfo {
    @NotNull
    @NonNls
    private final String myPhpPrefix;
    @NotNull
    @NonNls
    private final String myPhpSuffix;
    @Nullable
    private final IElementType myContentType;

    public static BladeInjectionInfo createForDirective(@NotNull @NonNls String phpPrefix, @NotNull @NonNls String phpSuffix) {
        if (phpPrefix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(0);
        }
        if (phpSuffix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(1);
        }
        return new BladeInjectionInfo(phpPrefix, phpSuffix, BladeTokenTypes.DIRECTIVE_PARAMETER_CONTENT){

            @Override
            public int getBladePrefixLength() {
                return "(".length();
            }

            @Override
            public int getBladeSuffixLength() {
                return ")".length();
            }
        };
    }

    public static BladeInjectionInfo createForClosingDirective(@NotNull @NonNls String phpPrefix, @NotNull @NonNls String phpSuffix) {
        if (phpPrefix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(2);
        }
        if (phpSuffix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(3);
        }
        return new BladeInjectionInfo(phpPrefix, phpSuffix, null){

            @Override
            public int getBladePrefixLength() {
                return 0;
            }

            @Override
            public int getBladeSuffixLength() {
                return 0;
            }
        };
    }

    public BladeInjectionInfo(@NotNull @NonNls String phpPrefix, @NotNull @NonNls String phpSuffix, @Nullable IElementType contentType) {
        if (phpPrefix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(4);
        }
        if (phpSuffix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(5);
        }
        this.myPhpPrefix = phpPrefix;
        this.myPhpSuffix = phpSuffix;
        this.myContentType = contentType;
    }

    @NotNull
    public String getPhpPrefix() {
        String string = this.myPhpPrefix;
        if (string == null) {
            BladeInjectionInfo.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPhpSuffix() {
        String string = this.myPhpSuffix;
        if (string == null) {
            BladeInjectionInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isConfigurable() {
        return true;
    }

    public abstract int getBladePrefixLength();

    public abstract int getBladeSuffixLength();

    @Nullable
    public IElementType getContentType() {
        return this.myContentType;
    }

    @Nullable
    public String getUnmodifiablePresentableDescription() {
        return null;
    }

    @Nullable
    public TextRange convertInjectedRangeToInnerVisible(BladeTranslatableElement host, TextRange injected, int length, boolean showEmptyBorderIntersections) {
        if (injected.getEndOffset() < this.getPhpPrefix().length() || injected.getStartOffset() > length - this.getPhpSuffix().length()) {
            return null;
        }
        if (!(showEmptyBorderIntersections || injected.getEndOffset() != this.getPhpPrefix().length() && injected.getStartOffset() != length - this.getPhpSuffix().length())) {
            return null;
        }
        int start = Math.max(injected.getStartOffset() - this.getPhpPrefix().length(), 0);
        int end = Math.min(injected.getEndOffset() - this.getPhpPrefix().length(), length - this.getPhpSuffix().length() - this.getPhpPrefix().length());
        return TextRange.create((int)(this.getBladePrefixLength() + start), (int)(this.getBladePrefixLength() + end));
    }

    public void handleContentChange(@NotNull LeafElement content, @NotNull TextRange changeRange, String newContent) {
        int startOffsetInParent;
        TextRange contentRange;
        TextRange intersection;
        if (content == null) {
            BladeInjectionInfo.$$$reportNull$$$0(8);
        }
        if (changeRange == null) {
            BladeInjectionInfo.$$$reportNull$$$0(9);
        }
        if ((intersection = changeRange.intersection(contentRange = new TextRange(startOffsetInParent = content.getStartOffsetInParent(), startOffsetInParent + content.getTextLength()))) == null) {
            return;
        }
        if (intersection.getStartOffset() > changeRange.getStartOffset()) {
            newContent = ((String)newContent).substring(intersection.getStartOffset() - changeRange.getStartOffset());
        }
        if (intersection.getEndOffset() < changeRange.getEndOffset()) {
            newContent = ((String)newContent).substring(0, ((String)newContent).length() - changeRange.getEndOffset() + intersection.getEndOffset());
        }
        String oldContentText = content.getText();
        if (intersection.getStartOffset() > contentRange.getStartOffset()) {
            newContent = oldContentText.substring(0, intersection.getStartOffset() - contentRange.getStartOffset()) + (String)newContent;
        }
        if (intersection.getEndOffset() < contentRange.getEndOffset()) {
            newContent = (String)newContent + oldContentText.substring(oldContentText.length() - contentRange.getEndOffset() + intersection.getEndOffset());
        }
        content.replaceWithText((String)newContent);
    }

    public void register(MultiHostRegistrar registrar, BladePsiLanguageInjectionHost host, PsiElement child, @NotNull String prefix) {
        if (prefix == null) {
            BladeInjectionInfo.$$$reportNull$$$0(10);
        }
        TextRange rangeInsideHost = this.getRangeInsideHost(host, child);
        registrar.addPlace(prefix + this.getPhpPrefix(), this.getPhpSuffix(), (PsiLanguageInjectionHost)host, rangeInsideHost);
    }

    @NotNull
    protected TextRange getRangeInsideHost(BladePsiLanguageInjectionHost host, PsiElement child) {
        int startOffset = child.getTextOffset() + this.getBladePrefixLength();
        int endOffset = this.getContentType() == null ? startOffset : child.getTextOffset() + child.getTextLength() - this.getBladeSuffixLength();
        endOffset = Math.max(startOffset, endOffset);
        TextRange textRange = new TextRange(startOffset, endOffset).shiftLeft(host.getTextRange().getStartOffset());
        if (textRange == null) {
            BladeInjectionInfo.$$$reportNull$$$0(11);
        }
        return textRange;
    }

    @NonNls
    public String toString() {
        return "BIInfo{prefix='" + this.myPhpPrefix + "', suffix='" + this.myPhpSuffix + "'}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpPrefix";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpSuffix";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectionInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectionInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpPrefix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPhpSuffix";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideHost";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createForDirective";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createForClosingDirective";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11 -> new IllegalStateException(string);
        };
    }
}

