/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.blade.BladeFileViewProvider;
import com.jetbrains.php.blade.parser.BladeDirectiveStack;
import com.jetbrains.php.blade.psi.BladePsiDirective;
import com.jetbrains.php.blade.psi.BladePsiLanguageInjectionHost;
import com.jetbrains.php.blade.psi.BladeTranslatableElement;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BladeInjectedPhpRefContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            BladeInjectedPhpRefContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(BladeTranslatableElement.class), (PsiReferenceProvider)new PhpElementsReferenceProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/php/blade/injection/BladeInjectedPhpRefContributor", "registerReferenceProviders"));
    }

    private static class PhpElementsReferenceProvider
    extends PsiReferenceProvider {
        private PhpElementsReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                PhpElementsReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpElementsReferenceProvider.$$$reportNull$$$0(1);
            }
            if (!(element instanceof BladeTranslatableElement)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    PhpElementsReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            List injectedFiles = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element);
            if (injectedFiles == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    PhpElementsReferenceProvider.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            final HashSet<PhpNamedElement> declarations = new HashSet<PhpNamedElement>();
            BladeDirectiveStack stack = new BladeDirectiveStack(){

                @Override
                protected void reportMissingOpeningProblem(BladePsiDirective directive) {
                }

                @Override
                protected void reportMissingClosingProblem(BladePsiDirective directive) {
                    if (!directive.isVariableProvider()) {
                        return;
                    }
                    Set<? extends PhpNamedElement> variableDeclarations = PhpElementsReferenceProvider.collectVariableDeclarations(directive);
                    if (variableDeclarations != null) {
                        declarations.addAll(variableDeclarations);
                    }
                }
            };
            stack.handleDirectivesBeforeElement(element);
            ReferenceElementVisitor visitor = new ReferenceElementVisitor((BladeTranslatableElement)element, declarations);
            for (Pair pair : injectedFiles) {
                int offset = element.getTextRange().getStartOffset();
                PsiElement phpElement = BladeFileViewProvider.findCorrespondingPsiElement(element, offset, (Language)PhpLanguage.INSTANCE);
                if (phpElement == null) continue;
                visitor.setInjection(phpElement);
                ((PsiElement)pair.getFirst()).accept((PsiElementVisitor)visitor);
            }
            PsiReference[] psiReferenceArray = visitor.getReferences();
            if (psiReferenceArray == null) {
                PhpElementsReferenceProvider.$$$reportNull$$$0(4);
            }
            return psiReferenceArray;
        }

        public static Set<? extends PhpNamedElement> collectVariableDeclarations(BladePsiDirective element) {
            BladePsiLanguageInjectionHost injectionHost = (BladePsiLanguageInjectionHost)PsiTreeUtil.getChildOfType((PsiElement)element, BladePsiLanguageInjectionHost.class);
            if (injectionHost == null) {
                return null;
            }
            List files = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles((PsiElement)injectionHost);
            if (files == null) {
                return null;
            }
            return VariableImpl.collectDeclarations((PsiElement)((PsiElement)((Pair)files.get((int)0)).first), (boolean)false, null);
        }

        @Nullable
        private static PsiPolyVariantReferenceBase<BladeTranslatableElement> createReference(Variable variable, BladeTranslatableElement bladeInjectionHost, PsiElement phpElement, Set<? extends PhpNamedElement> varsFromDirectives) {
            TextRange injectedRange = variable.getTextRange();
            TextRange visibleRange = bladeInjectionHost.convertInjectedRangeToInnerVisible(injectedRange, variable.getContainingFile().getTextLength(), false);
            if (visibleRange == null) {
                return null;
            }
            return new VariableReference(variable, bladeInjectionHost, visibleRange, phpElement, varsFromDirectives);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectedPhpRefContributor$PhpElementsReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectedPhpRefContributor$PhpElementsReferenceProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }

        private static final class ReferenceElementVisitor
        extends PhpRecursiveElementVisitor {
            private final Set<? extends PhpNamedElement> myVarsFromDirectives;
            private final BladeTranslatableElement myInjectionHost;
            private PsiElement myPhpFileElement;
            private final List<PsiReference> myReferences;

            private ReferenceElementVisitor(BladeTranslatableElement host, @NotNull Set<PhpNamedElement> varsFromDirectives) {
                if (varsFromDirectives == null) {
                    ReferenceElementVisitor.$$$reportNull$$$0(0);
                }
                this.myReferences = new ArrayList<PsiReference>();
                this.myInjectionHost = host;
                this.myVarsFromDirectives = varsFromDirectives;
            }

            public void setInjection(PsiElement phpFileElement) {
                this.myPhpFileElement = phpFileElement;
            }

            public void visitPhpVariable(Variable variable) {
                super.visitPhpVariable(variable);
                PsiPolyVariantReferenceBase<BladeTranslatableElement> reference = PhpElementsReferenceProvider.createReference(variable, this.myInjectionHost, this.myPhpFileElement, this.myVarsFromDirectives);
                if (reference != null) {
                    this.myReferences.add((PsiReference)reference);
                }
            }

            public PsiReference[] getReferences() {
                return this.myReferences.toArray(PsiReference.EMPTY_ARRAY);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "varsFromDirectives", "com/jetbrains/php/blade/injection/BladeInjectedPhpRefContributor$PhpElementsReferenceProvider$ReferenceElementVisitor", "<init>"));
            }
        }

        private static final class VariableReference
        extends PsiPolyVariantReferenceBase<BladeTranslatableElement> {
            private final String myVariableName;
            private final PsiElement myPhpElement;
            private final Set<? extends PhpNamedElement> myVarsFromDirectives;

            private VariableReference(Variable variable, BladeTranslatableElement host, TextRange visibleRange, PsiElement phpElement, Set<? extends PhpNamedElement> varsFromDirectives) {
                super((PsiElement)host, visibleRange, true);
                this.myVariableName = variable.getName();
                this.myPhpElement = phpElement;
                this.myVarsFromDirectives = varsFromDirectives;
            }

            public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
                Set phpVars = VariableImpl.collectDeclarations((PsiElement)this.myPhpElement, (boolean)true, (String)this.myVariableName);
                HashSet<PhpNamedElement> result = new HashSet<PhpNamedElement>(phpVars);
                for (PhpNamedElement phpNamedElement : this.myVarsFromDirectives) {
                    if (!this.myVariableName.equals(phpNamedElement.getName())) continue;
                    result.add(phpNamedElement);
                }
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(result);
                if (resolveResultArray == null) {
                    VariableReference.$$$reportNull$$$0(0);
                }
                return resolveResultArray;
            }

            @Nullable
            public PsiElement resolve() {
                return VariableImpl.getLeastByPathAndOffset((ResolveResult[])this.multiResolve(false));
            }

            public boolean isReferenceTo(@NotNull PsiElement element) {
                if (element == null) {
                    VariableReference.$$$reportNull$$$0(1);
                }
                if (element instanceof Variable || element instanceof Parameter || element instanceof PhpDocVariable) {
                    ResolveResult[] results;
                    for (ResolveResult result : results = this.multiResolve(false)) {
                        if (element != result.getElement()) continue;
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/blade/injection/BladeInjectedPhpRefContributor$PhpElementsReferenceProvider$VariableReference";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "multiResolve";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/blade/injection/BladeInjectedPhpRefContributor$PhpElementsReferenceProvider$VariableReference";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isReferenceTo";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        }
    }
}

