/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringIntentionBase;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSQualifiedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceDestructuringVariablesAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSIntroduceDestructuringVariablesIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public JSIntroduceDestructuringVariablesIntention() {
        this.setText(this.getFamilyName());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(1);
        }
        new JSIntroduceDestructuringVariablesAction().createHandler().invoke(project, editor, element2.getContainingFile(), DataContext.EMPTY_CONTEXT);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(3);
        }
        if (!super.isAvailable(project, editor, element2) || !DialectDetector.hasFeature(element2, JSLanguageFeature.DESTRUCTURING_ASSIGNMENT)) {
            return false;
        }
        JSQualifiedExpression parent = (JSQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JSReferenceExpression.class, JSIndexedPropertyAccessExpression.class});
        if (parent != null && JSIntroduceDestructuringVariablesIntention.isValidParent(parent)) {
            JSQualifiedExpression reference = JSIntroduceDestructuringVariablesAction.findReference(editor, element2.getContainingFile());
            if (reference == null || reference instanceof JSReferenceExpression && ((JSReferenceExpression)reference).getReferenceKind() != JSReferenceExpression.Kind.PropertyAccess || PsiTreeUtil.getParentOfType((PsiElement)reference, JSStatement.class) == null || JSIntroduceDestructuringVariablesIntention.isInTypeAnnotation((PsiElement)reference)) {
                return false;
            }
            this.setText(this.guessKind(reference));
            return true;
        }
        return false;
    }

    public static boolean isInTypeAnnotation(PsiElement element2) {
        PsiElement expression = JSResolveUtil.getTopReferenceExpression(element2);
        return expression instanceof JSReferenceExpression && JSResolveUtil.isExprInTypeContext((JSReferenceExpression)expression);
    }

    @NotNull
    @IntentionName
    private String guessKind(JSQualifiedExpression reference) {
        while (reference.getParent() instanceof JSQualifiedExpression) {
            reference = (JSQualifiedExpression)reference.getParent();
        }
        if (reference instanceof JSReferenceExpression) {
            JSExpression qualifier = reference.getQualifier();
            while (qualifier instanceof JSQualifiedExpression) {
                if (qualifier instanceof JSIndexedPropertyAccessExpression) {
                    String string = this.getFamilyName();
                    if (string == null) {
                        JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                qualifier = ((JSQualifiedExpression)qualifier).getQualifier();
            }
            String string = JavaScriptBundle.message("refactoring.destructuring.vars.intention.name.object", new Object[0]);
            if (string == null) {
                JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (reference instanceof JSIndexedPropertyAccessExpression) {
            JSExpression qualifier = reference.getQualifier();
            while (qualifier instanceof JSQualifiedExpression) {
                if (qualifier instanceof JSReferenceExpression && ((JSReferenceExpression)qualifier).getQualifier() != null) {
                    String string = this.getFamilyName();
                    if (string == null) {
                        JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(6);
                    }
                    return string;
                }
                qualifier = ((JSQualifiedExpression)qualifier).getQualifier();
            }
            String string = JavaScriptBundle.message("refactoring.destructuring.vars.intention.name.array", new Object[0]);
            if (string == null) {
                JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.getFamilyName();
        if (string == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static boolean isValidParent(@NotNull JSQualifiedExpression parent) {
        if (parent == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(9);
        }
        if (parent.getQualifier() != null) {
            return JSIntroduceDestructuringVariablesIntention.isValidParentExpression(parent);
        }
        JSQualifiedExpression root = JSIntroduceDestructuringVariablesIntention.getValidRoot(parent);
        while (root != null) {
            if (JSIntroduceDestructuringVariablesIntention.isValidParentExpression(root)) {
                return true;
            }
            root = JSIntroduceDestructuringVariablesIntention.getValidRoot(root);
        }
        return false;
    }

    private static JSQualifiedExpression getValidRoot(@NotNull JSQualifiedExpression parent) {
        if (parent == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(10);
        }
        return (JSQualifiedExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSReferenceExpression.class, JSIndexedPropertyAccessExpression.class});
    }

    private static boolean isValidParentExpression(JSExpression parent) {
        PsiElement parentParent = parent.getParent();
        if (parentParent instanceof JSCallExpression || parentParent instanceof JSTypeDeclaration) {
            return false;
        }
        if (parent instanceof JSIndexedPropertyAccessExpression) {
            return JSDestructuringIntentionBase.isValidIndexer((JSIndexedPropertyAccessExpression)parent);
        }
        if (parent instanceof JSReferenceExpression && ((JSReferenceExpression)parent).getReferenceName() == null) {
            return false;
        }
        return !JSIntroduceDestructuringVariablesIntention.hasNonReadUsage(parent);
    }

    private static boolean hasNonReadUsage(JSExpression parent) {
        if (JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)parent) != ReadWriteAccessDetector.Access.Read) {
            return true;
        }
        PsiElement parentParent = parent.getParent();
        return parentParent instanceof JSExpression && JSIntroduceDestructuringVariablesIntention.hasNonReadUsage((JSExpression)parentParent);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("refactoring.destructuring.vars.intention.name", new Object[0]);
        if (string == null) {
            JSIntroduceDestructuringVariablesIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSIntroduceDestructuringVariablesIntention";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSIntroduceDestructuringVariablesIntention";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "guessKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isValidParent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getValidRoot";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 8, 11 -> new IllegalStateException(string);
        };
    }
}

