/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runConfiguration;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoManager;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoNameUtils;
import com.intellij.javascript.testFramework.util.PresentableTestNameKt;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006J:\u0010\u000e\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0012J;\u0010\u0013\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\r\u0010\u0015\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u001c\u0010\u0016\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\r\u0010\u0015\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationUtil;", "", "<init>", "()V", "suggestRunConfigurationName", "", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "contextFileOrDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "scope", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "configFilePath", "getRunConfigurationActionName", "runConfiguration", "Lcom/intellij/execution/configurations/LocatableConfiguration;", "contextFileProvider", "Lkotlin/Function0;", "suggestName", "packageRoot", "packageName", "getAllTestsName", "intellij.javascript.impl"})
public final class JsTestRunConfigurationUtil {
    @NotNull
    public static final JsTestRunConfigurationUtil INSTANCE = new JsTestRunConfigurationUtil();

    private JsTestRunConfigurationUtil() {
    }

    @NotNull
    public final String suggestRunConfigurationName(@NotNull Project project, @Nullable VirtualFile contextFileOrDir, @NotNull JsTestRunScope scope2, @NotNull String configFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        VirtualFile packageRoot = JSMonorepoManager.Companion.getInstance(project).guessContextPackageRoot(contextFileOrDir);
        return this.suggestName(packageRoot, JSMonorepoNameUtils.getPackageName(packageRoot), scope2, configFilePath);
    }

    @Nullable
    public final String getRunConfigurationActionName(@NotNull LocatableConfiguration runConfiguration, @NotNull JsTestRunScope scope2, @NotNull String configFilePath, @NotNull Function0<? extends VirtualFile> contextFileProvider) {
        String string;
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter(contextFileProvider, (String)"contextFileProvider");
        if ((scope2.getKind() == JsTestRunScopeKind.SUITE || scope2.getKind() == JsTestRunScopeKind.TEST) && (string = (String)CollectionsKt.lastOrNull(scope2.getTestNames())) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (runConfiguration.isGeneratedName()) {
            VirtualFile virtualFile;
            if (scope2.getKind() == JsTestRunScopeKind.DIRECTORY) {
                Project project = runConfiguration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                virtualFile = JSMonorepoManager.Companion.getInstance(project).guessContextPackageRoot((VirtualFile)contextFileProvider.invoke());
            } else {
                virtualFile = null;
            }
            VirtualFile packageRoot = virtualFile;
            return this.suggestName(packageRoot, null, scope2, configFilePath);
        }
        return null;
    }

    private final String suggestName(VirtualFile packageRoot, String packageName, JsTestRunScope scope2, String configFilePath) {
        if (scope2.getKind() == JsTestRunScopeKind.DIRECTORY) {
            VirtualFile virtualFile = packageRoot;
            if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)FileUtil.toSystemIndependentName((String)scope2.getTestDirectoryPath()))) {
                return this.getAllTestsName(packageName);
            }
            Object[] objectArray = new Object[]{JSMonorepoNameUtils.buildContextName(packageName, PathUtil.getFileName((String)scope2.getTestDirectoryPath()) + File.separator)};
            String string = JavaScriptBundle.message("rc.testDirectory.presentable.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (scope2.getKind() == JsTestRunScopeKind.TEST_FILE) {
            String string = PathUtil.getFileName((String)scope2.getTestFilePath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            return JSMonorepoNameUtils.buildContextName(packageName, string);
        }
        if (scope2.getKind() == JsTestRunScopeKind.SUITE || scope2.getKind() == JsTestRunScopeKind.TEST) {
            return PresentableTestNameKt.createPresentableTestName(scope2.getTestNames());
        }
        if (!StringsKt.isBlank((CharSequence)configFilePath)) {
            Object[] objectArray = new Object[1];
            String string = PathUtil.getFileName((String)configFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            objectArray[0] = JSMonorepoNameUtils.buildContextName(packageName, string);
            String string2 = JavaScriptBundle.message("rc.testConfig.presentable.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        return this.getAllTestsName(packageName);
    }

    private final String getAllTestsName(String packageName) {
        String string;
        if (packageName != null) {
            Object[] objectArray = new Object[]{packageName};
            String string2 = JavaScriptBundle.message("rc.testConfig.presentable.name", objectArray);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }
}

