/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 36474887739390L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(2025424710 + (char)-30398, 2025424710 + (char)-32163, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2025424710 + (char)-30397, -2025424710 + -((char)-13867), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 115767136786170L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(588242160 + (char)-19298, 588242160 + (char)-2360, (int)l2) + string + WindowsNamedPipeAgentIpc.b(588242160 + (char)-19297, -588242160 + -((char)-11245), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(588242160 + (char)-19304, -588373230 - -((char)-5416), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                l2 = 104167459449519L;
                Object object = this.lock;
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20040, 1617665940 - (char)-17681, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20043, 1617665940 - (char)-11742, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20042, 1617665940 - (char)-22071, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20029, 1617665940 - (char)-1206, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20028, -1617665940 - -((char)-13208), (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20031, 1617665940 - (char)-18224, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20029, 1617665940 - (char)-1206, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1617665940 - (char)-20030, 1617665940 - (char)-5540, (int)l2));
            if (ActionTimestamp.J() == null) {
                SshAgentIpcService.J(new ActionTimestamp[5]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 67868943370899L;
                    actionTimestampArray = SshAgentIpcService.J();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 6542986669009L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.J();
                this.assertConnectionThread();
                Object object3 = this.lock;
                actionTimestampArray = actionTimestampArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray != null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1751488410 - 10991, -1751488410 - -8820, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10992, -1751488410 - -14288, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10993, -1751488410 - -18161, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1751488410 - 10991, -1751488410 - -8820, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10994, -1751488410 - -8387, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1751488410 - 10991, -1751488410 - -8820, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10979, 1751488410 - 18786, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10980, -1751488410 - -28161, (int)l2) + ErrorToolsKt.prettyHRESULT(n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray != null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10993, -1751488410 - -18161, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1751488410 - 10991, -1751488410 - -8820, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1751488410 - 10987, 1751488410 - 29286, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1751488410 - 10981, 1751488410 - 18126, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 26475421184654L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1242805740 - 31866, 1242805740 - 14148, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 10023601123028L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-852610350 - -((char)-3497), -852479280 + -((char)-2283), (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00bf\u009b\\}\u0015\u0098[\u00b7\f\u0007D\u0016\u00f2I\u0095(\u00ceNr\u0014Z\u00be\u00e0\u00df\u0099\u000e\u00b7\u00e0\u0013\u00ebb_\u00f4\u0099\u0094\u00b9\u0003\u00ba\u00cc\u00b2";
                        var4_3 = "\u00bf\u009b\\}\u0015\u0098[\u00b7\f\u0007D\u0016\u00f2I\u0095(\u00ceNr\u0014Z\u00be\u00e0\u00df\u0099\u000e\u00b7\u00e0\u0013\u00ebb_\u00f4\u0099\u0094\u00b9\u0003\u00ba\u00cc\u00b2".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 7;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 100;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 20;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 77;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 12;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 105;
                                        break;
                                    }
                                    default: {
                                        v11 = 73;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xBFC) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 133;
                            case 1 -> 164;
                            case 2 -> 205;
                            case 3 -> 87;
                            case 4 -> 78;
                            case 5 -> 143;
                            case 6 -> 176;
                            case 7 -> 249;
                            case 8 -> 202;
                            case 9 -> 57;
                            case 10 -> 63;
                            case 11 -> 172;
                            case 12 -> 28;
                            case 13 -> 14;
                            case 14 -> 159;
                            case 15 -> 198;
                            case 16 -> 37;
                            case 17 -> 70;
                            case 18 -> 119;
                            case 19 -> 185;
                            case 20 -> 229;
                            case 21 -> 65;
                            case 22 -> 110;
                            case 23 -> 190;
                            case 24 -> 163;
                            case 25 -> 84;
                            case 26 -> 16;
                            case 27 -> 246;
                            case 28 -> 180;
                            case 29 -> 91;
                            case 30 -> 96;
                            case 31 -> 224;
                            case 32 -> 42;
                            case 33 -> 52;
                            case 34 -> 193;
                            case 35 -> 32;
                            case 36 -> 253;
                            case 37 -> 216;
                            case 38 -> 252;
                            case 39 -> 201;
                            case 40 -> 200;
                            case 41 -> 124;
                            case 42 -> 61;
                            case 43 -> 122;
                            case 44 -> 137;
                            case 45 -> 234;
                            case 46 -> 230;
                            case 47 -> 140;
                            case 48 -> 113;
                            case 49 -> 196;
                            case 50 -> 77;
                            case 51 -> 108;
                            case 52 -> 134;
                            case 53 -> 242;
                            case 54 -> 206;
                            case 55 -> 181;
                            case 56 -> 243;
                            case 57 -> 24;
                            case 58 -> 254;
                            case 59 -> 30;
                            case 60 -> 127;
                            case 61 -> 208;
                            case 62 -> 130;
                            case 63 -> 55;
                            case 64 -> 27;
                            case 65 -> 7;
                            case 66 -> 217;
                            case 67 -> 212;
                            case 68 -> 111;
                            case 69 -> 128;
                            case 70 -> 117;
                            case 71 -> 199;
                            case 72 -> 203;
                            case 73 -> 69;
                            case 74 -> 4;
                            case 75 -> 74;
                            case 76 -> 238;
                            case 77 -> 90;
                            case 78 -> 13;
                            case 79 -> 51;
                            case 80 -> 101;
                            case 81 -> 60;
                            case 82 -> 161;
                            case 83 -> 95;
                            case 84 -> 33;
                            case 85 -> 157;
                            case 86 -> 25;
                            case 87 -> 158;
                            case 88 -> 62;
                            case 89 -> 174;
                            case 90 -> 194;
                            case 91 -> 29;
                            case 92 -> 147;
                            case 93 -> 107;
                            case 94 -> 76;
                            case 95 -> 17;
                            case 96 -> 153;
                            case 97 -> 168;
                            case 98 -> 89;
                            case 99 -> 233;
                            case 100 -> 241;
                            case 101 -> 187;
                            case 102 -> 240;
                            case 103 -> 53;
                            case 104 -> 22;
                            case 105 -> 132;
                            case 106 -> 59;
                            case 107 -> 41;
                            case 108 -> 209;
                            case 109 -> 178;
                            case 110 -> 192;
                            case 111 -> 21;
                            case 112 -> 97;
                            case 113 -> 148;
                            case 114 -> 75;
                            case 115 -> 160;
                            case 116 -> 8;
                            case 117 -> 207;
                            case 118 -> 144;
                            case 119 -> 35;
                            case 120 -> 250;
                            case 121 -> 188;
                            case 122 -> 118;
                            case 123 -> 50;
                            case 124 -> 182;
                            case 125 -> 214;
                            case 126 -> 155;
                            case 127 -> 85;
                            case 128 -> 191;
                            case 129 -> 54;
                            case 130 -> 145;
                            case 131 -> 92;
                            case 132 -> 19;
                            case 133 -> 46;
                            case 134 -> 1;
                            case 135 -> 71;
                            case 136 -> 0;
                            case 137 -> 166;
                            case 138 -> 197;
                            case 139 -> 248;
                            case 140 -> 79;
                            case 141 -> 68;
                            case 142 -> 6;
                            case 143 -> 223;
                            case 144 -> 20;
                            case 145 -> 73;
                            case 146 -> 82;
                            case 147 -> 183;
                            case 148 -> 2;
                            case 149 -> 220;
                            case 150 -> 18;
                            case 151 -> 5;
                            case 152 -> 146;
                            case 153 -> 102;
                            case 154 -> 120;
                            case 155 -> 125;
                            case 156 -> 151;
                            case 157 -> 26;
                            case 158 -> 114;
                            case 159 -> 177;
                            case 160 -> 179;
                            case 161 -> 104;
                            case 162 -> 219;
                            case 163 -> 126;
                            case 164 -> 38;
                            case 165 -> 245;
                            case 166 -> 210;
                            case 167 -> 49;
                            case 168 -> 154;
                            case 169 -> 141;
                            case 170 -> 93;
                            case 171 -> 213;
                            case 172 -> 218;
                            case 173 -> 48;
                            case 174 -> 103;
                            case 175 -> 251;
                            case 176 -> 142;
                            case 177 -> 226;
                            case 178 -> 236;
                            case 179 -> 131;
                            case 180 -> 171;
                            case 181 -> 170;
                            case 182 -> 169;
                            case 183 -> 86;
                            case 184 -> 189;
                            case 185 -> 81;
                            case 186 -> 204;
                            case 187 -> 244;
                            case 188 -> 83;
                            case 189 -> 45;
                            case 190 -> 150;
                            case 191 -> 162;
                            case 192 -> 40;
                            case 193 -> 66;
                            case 194 -> 36;
                            case 195 -> 9;
                            case 196 -> 235;
                            case 197 -> 11;
                            case 198 -> 156;
                            case 199 -> 222;
                            case 200 -> 215;
                            case 201 -> 3;
                            case 202 -> 239;
                            case 203 -> 109;
                            case 204 -> 31;
                            case 205 -> 112;
                            case 206 -> 165;
                            case 207 -> 175;
                            case 208 -> 136;
                            case 209 -> 80;
                            case 210 -> 44;
                            case 211 -> 211;
                            case 212 -> 227;
                            case 213 -> 221;
                            case 214 -> 184;
                            case 215 -> 129;
                            case 216 -> 10;
                            case 217 -> 15;
                            case 218 -> 225;
                            case 219 -> 106;
                            case 220 -> 116;
                            case 221 -> 39;
                            case 222 -> 56;
                            case 223 -> 138;
                            case 224 -> 94;
                            case 225 -> 247;
                            case 226 -> 67;
                            case 227 -> 105;
                            case 228 -> 34;
                            case 229 -> 167;
                            case 230 -> 123;
                            case 231 -> 231;
                            case 232 -> 228;
                            case 233 -> 186;
                            case 234 -> 12;
                            case 235 -> 232;
                            case 236 -> 237;
                            case 237 -> 152;
                            case 238 -> 58;
                            case 239 -> 135;
                            case 240 -> 99;
                            case 241 -> 23;
                            case 242 -> 173;
                            case 243 -> 139;
                            case 244 -> 255;
                            case 245 -> 195;
                            case 246 -> 121;
                            case 247 -> 43;
                            case 248 -> 64;
                            case 249 -> 72;
                            case 250 -> 88;
                            case 251 -> 47;
                            case 252 -> 98;
                            case 253 -> 100;
                            case 254 -> 149;
                            default -> 115;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray != null) {
                ActionTimestamp.J(new String[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 55107039060167L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1686346620 - -((char)-31943), 1686346620 - (char)-26192, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1686346620 - -((char)-31947), -1686346620 - -18846, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1686346620 - -((char)-31970), -1686346620 - -((char)-26299), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1686346620 - -((char)-31943), 1686346620 - (char)-26192, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1686346620 - -((char)-31947), -1686346620 - -18846, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1686346620 - -((char)-31967), 1686346620 - 22795, (int)l3) + ErrorToolsKt.prettyHRESULT(n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 61226649312406L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.J();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1890553680 - (char)-19621, -1890553680 - -((char)-23364), (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1890553680 - (char)-19622, -1890553680 - -((char)-2371), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 44329514048739L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.J();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1156561680 + 24713, -1156561680 + -18184, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1156561680 + 24717, 1156561680 + (char)-26890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1156561680 + 24690, -1156561680 + -27757, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1156561680 + 24717, 1156561680 + (char)-26890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1156561680 + 24715, -1156561680 + -27787, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1156561680 + 24713, -1156561680 + -18184, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1156561680 + 24717, 1156561680 + (char)-26890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1156561680 + 24701, -1156561680 + -((char)-32495), (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1156561680 + 24713, -1156561680 + -18184, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(1156561680 + 24717, 1156561680 + (char)-26890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1156561680 + 24700, -1156561680 + -26125, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1156561680 + 24713, -1156561680 + -18184, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1156561680 + 24717, 1156561680 + (char)-26890, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1156561680 + 24703, -1156561680 + -23492, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 93902902088557L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.J();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2032109280 - 13001, -2032109280 - -14662, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(2032109280 - 13005, 2032109280 - 26968, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2032109280 - 13024, 2032109280 - 8303, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(2032109280 - 13017, -2032109280 - -6344, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2032109280 - 13001, -2032109280 - -14662, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(2032109280 - 13005, 2032109280 - 26968, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2032109280 - 13018, 2032109280 - 16142, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2032109280 - 13001, -2032109280 - -14662, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(2032109280 - 13005, 2032109280 - 26968, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2032109280 - 13019, -2032109280 - -15799, (int)l2) + ErrorToolsKt.prettyHRESULT(n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2032109280 - 13001, -2032109280 - -14662, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(2032109280 - 13005, 2032109280 - 26968, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2032109280 - 13020, -2032109280 - -24019, (int)l2));
                    if (actionTimestampArray != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(2032109280 - 13001, -2032109280 - -14662, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(2032109280 - 13005, 2032109280 - 26968, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(2032109280 - 12965, 2032109280 - 7294, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(2032109280 - 12966, 2032109280 - 3298, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00c2c\u00b8\u00af\u00ce\u00e1\u00a3\u00b0\u0014\u0086f\b\u00e8&\u0081\u0011\u00a6\u0013\u00cf\u008f#\u0086\u00b9\u00e39g\u0015'\u009e\u0006\u00bf\u00da\u0017\u0098QF\u0018\u00b0o\u00ae\u00f9pf\u00d9\u009a\u00c25\u00ba\fF\u00a3\u00a9\u00f8\u0087D\u0015)K\u00e6B\u00c6\t\u00c68\u00fe\u00a2\u0011\u0092\u00edLx\u0005\u001bw\u0083-\u00d9\b\u00a3\u00b6\u0094d\u0019\u00be_\u00b9\u0014:7\u00e7Y\u00b6\u00bf6\u00f6\u0099\u0018um\u0093\u00d3\u00fa\u0099V\u00d2\u00f8$\u0005\u00c09\u00f8\u00e4\u00b6\u001e\u007f\u00c1\u001a\u009fwn\u009b\u00e1/NL\u00e4\u00d4\u009eY;x\u00ad8\u00e0B\u00f0o\u00c9WF\u00c9\u00cf\u00de\u00f3\u0010X\u00c0\u001az \u00e0\u0087\u00c9\u00d1\u00f9\u001e\u00ef\u0098\u00aa\u007f\"\t(\u00b3\u00f5\u00c2#\u00b9\u008d\u00b6\u009a\u0010\u00ceo\u00c8\u008fz^\u00cc\u001e\u00b8\u00033\u00b0=A\u00cb_?i\u0016\u00d0e#8\u0094G\u00bfK\u001b\u00bf\u0081\u0003\u00ce\u00b1O\u0099\u00a3\u00a3\u00bf\u00ca\u00ab\u00e8\u00df\u008a\u00d5\u00e2j\u0000$\u00b4\u00d1u&g\u00e3\u00e9\u00ed\u00e9\u008e\u00c2\u00b2\u00a8\u00d9\u00d4\u0000\u00f1\u00f6\f,A\r\u00a0\u00a0\u0010g/R{3\u00fb\u00f5\b\u0088\u00ad\u00f1\u0007\u00b5\u00d2\u00ca4\f/R\u0015\u00e34,\u0014\u00ec\u008a\u0015'vFu*^\u00ec]\u00cd9\u00d0/\u009e\u0099\u00c3G\u0084\tgK$#\u00bb\u00bd\u009b\u00e8\u00f0\u0081\u00a2\u00ed\u00ec\u00d2\u00e8\t\u0095H\u00e7\u00d7\u0014\u0007\u00ca\u00daI\u00fb\u00c3\u0097s\u00a3*\u001bSr\u00a0\u00da~<\u00d1\u0090%\u00fe\u00fd\u00f7\u009d\u00b4NY\u008a\u00b6\u001b\u00ad\u0015#\u00d7\u001f\u0004`u\u00ab\u009a\u00e8&1\u0098T\u00ba\u00a7\n\u00eb\u0089$\u0019\u00a6iK\u00a3\u0005\u0084\u00dcK4]MQR{\u000bm ]\u00ad=\u00e55\u00d5\u00ae>\u00a9\u0015\u0089\u009b\u00c1\u00d9\u00a9\u0003Kt_\u00ea_\u00bb\b\u00c4\u00d4\u0097ID\u00beno)\u0004Ku\u00ce\u009aD&\u00a4\u0098\u00e6\u00ba\u00f1\u000e+\u00979\u0085\u008d!\u0089Z%}\u00c0\u001b\u00fe\u0080l\u00c5\u0082k\u00e6\u00fa,\u00e7\u00e0\u001fIR\u0090I\u0007\u0005O_T\u00fbJ\u0091\u0007\u00ccu\u0002\u007f\u00b7\u00c0\u000e(%q\u001d\u00a8'\u00e2gW\u00c0O\u009b\u00f2\t\u00ca5\u0086\u00d6\u00d7\u00e5\u0081\u00a3\u001a-\u00ec\u0081\u00c7e0Ni\u00c1\u0082T\u00cb\u00ac\u00b1\u00cc\u001e\u00bb\u0089\u000f\"\u00ee\u00b3r\u001a\u00d5er\u00f5f\u009c\u0086I\u0010\u00a3\"\u00d0\u00f1\u00ef\u0099\u00c9\u00aeL\u00f9\u00d5M\u0013\u00848\u00895\u00a3:\u00f7\\\u0084\u001f\u0084u\u00a4\u0089&\u001f\u00a9\u0012\b3\u00b0\u00df\u0015\u000e>g0Cj\u00f3k\u00b64\u00fe\u00a4\u0095Bx\u001b\u000e\u00041*\u00b1k\u0085\u00f9\u00be\u0090xY\u0089\u00d7%~\u0090\u00e6\u00b4:9g\u00c2~4\u0010\u00fd\n(\u00101\u00af\u00a5?\u00d4Y?\u00e6\u0018\u00d8\u0016\u00ebe\u00eb>\u00ef\r\u00ed\u00c7\u00d0,%*L\u00e0\u00ca4(\u0019\u00d2H\u00e4\u00c8)\u00ff\u00a1\n\u0093u\u00ef\u00db\u00d1'HM$\u00f4\u0098W4\u00e3Y2\u00d6\u0002\u00de?\u00b3&\u0002\u00ba\u001f\u00d1\u00b0R1\u00f8\br\u00f0so\u00dfT\u00f8\t\u00dc\u0098k\u00b9\u00fa\u0019\u00e0\u00f9\u008a";
                var4_3 = "\u00c2c\u00b8\u00af\u00ce\u00e1\u00a3\u00b0\u0014\u0086f\b\u00e8&\u0081\u0011\u00a6\u0013\u00cf\u008f#\u0086\u00b9\u00e39g\u0015'\u009e\u0006\u00bf\u00da\u0017\u0098QF\u0018\u00b0o\u00ae\u00f9pf\u00d9\u009a\u00c25\u00ba\fF\u00a3\u00a9\u00f8\u0087D\u0015)K\u00e6B\u00c6\t\u00c68\u00fe\u00a2\u0011\u0092\u00edLx\u0005\u001bw\u0083-\u00d9\b\u00a3\u00b6\u0094d\u0019\u00be_\u00b9\u0014:7\u00e7Y\u00b6\u00bf6\u00f6\u0099\u0018um\u0093\u00d3\u00fa\u0099V\u00d2\u00f8$\u0005\u00c09\u00f8\u00e4\u00b6\u001e\u007f\u00c1\u001a\u009fwn\u009b\u00e1/NL\u00e4\u00d4\u009eY;x\u00ad8\u00e0B\u00f0o\u00c9WF\u00c9\u00cf\u00de\u00f3\u0010X\u00c0\u001az \u00e0\u0087\u00c9\u00d1\u00f9\u001e\u00ef\u0098\u00aa\u007f\"\t(\u00b3\u00f5\u00c2#\u00b9\u008d\u00b6\u009a\u0010\u00ceo\u00c8\u008fz^\u00cc\u001e\u00b8\u00033\u00b0=A\u00cb_?i\u0016\u00d0e#8\u0094G\u00bfK\u001b\u00bf\u0081\u0003\u00ce\u00b1O\u0099\u00a3\u00a3\u00bf\u00ca\u00ab\u00e8\u00df\u008a\u00d5\u00e2j\u0000$\u00b4\u00d1u&g\u00e3\u00e9\u00ed\u00e9\u008e\u00c2\u00b2\u00a8\u00d9\u00d4\u0000\u00f1\u00f6\f,A\r\u00a0\u00a0\u0010g/R{3\u00fb\u00f5\b\u0088\u00ad\u00f1\u0007\u00b5\u00d2\u00ca4\f/R\u0015\u00e34,\u0014\u00ec\u008a\u0015'vFu*^\u00ec]\u00cd9\u00d0/\u009e\u0099\u00c3G\u0084\tgK$#\u00bb\u00bd\u009b\u00e8\u00f0\u0081\u00a2\u00ed\u00ec\u00d2\u00e8\t\u0095H\u00e7\u00d7\u0014\u0007\u00ca\u00daI\u00fb\u00c3\u0097s\u00a3*\u001bSr\u00a0\u00da~<\u00d1\u0090%\u00fe\u00fd\u00f7\u009d\u00b4NY\u008a\u00b6\u001b\u00ad\u0015#\u00d7\u001f\u0004`u\u00ab\u009a\u00e8&1\u0098T\u00ba\u00a7\n\u00eb\u0089$\u0019\u00a6iK\u00a3\u0005\u0084\u00dcK4]MQR{\u000bm ]\u00ad=\u00e55\u00d5\u00ae>\u00a9\u0015\u0089\u009b\u00c1\u00d9\u00a9\u0003Kt_\u00ea_\u00bb\b\u00c4\u00d4\u0097ID\u00beno)\u0004Ku\u00ce\u009aD&\u00a4\u0098\u00e6\u00ba\u00f1\u000e+\u00979\u0085\u008d!\u0089Z%}\u00c0\u001b\u00fe\u0080l\u00c5\u0082k\u00e6\u00fa,\u00e7\u00e0\u001fIR\u0090I\u0007\u0005O_T\u00fbJ\u0091\u0007\u00ccu\u0002\u007f\u00b7\u00c0\u000e(%q\u001d\u00a8'\u00e2gW\u00c0O\u009b\u00f2\t\u00ca5\u0086\u00d6\u00d7\u00e5\u0081\u00a3\u001a-\u00ec\u0081\u00c7e0Ni\u00c1\u0082T\u00cb\u00ac\u00b1\u00cc\u001e\u00bb\u0089\u000f\"\u00ee\u00b3r\u001a\u00d5er\u00f5f\u009c\u0086I\u0010\u00a3\"\u00d0\u00f1\u00ef\u0099\u00c9\u00aeL\u00f9\u00d5M\u0013\u00848\u00895\u00a3:\u00f7\\\u0084\u001f\u0084u\u00a4\u0089&\u001f\u00a9\u0012\b3\u00b0\u00df\u0015\u000e>g0Cj\u00f3k\u00b64\u00fe\u00a4\u0095Bx\u001b\u000e\u00041*\u00b1k\u0085\u00f9\u00be\u0090xY\u0089\u00d7%~\u0090\u00e6\u00b4:9g\u00c2~4\u0010\u00fd\n(\u00101\u00af\u00a5?\u00d4Y?\u00e6\u0018\u00d8\u0016\u00ebe\u00eb>\u00ef\r\u00ed\u00c7\u00d0,%*L\u00e0\u00ca4(\u0019\u00d2H\u00e4\u00c8)\u00ff\u00a1\n\u0093u\u00ef\u00db\u00d1'HM$\u00f4\u0098W4\u00e3Y2\u00d6\u0002\u00de?\u00b3&\u0002\u00ba\u001f\u00d1\u00b0R1\u00f8\br\u00f0so\u00dfT\u00f8\t\u00dc\u0098k\u00b9\u00fa\u0019\u00e0\u00f9\u008a".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 82;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00b3&\u00c7'\u0088= \u00cf\u001c\u00cfn\u0090\u00d4J\u0017*\u00af\u00d2\u00afg\u00a0\u0093\u00dc\u0080\u00b5<\u001d\u00d9\u00f1\u0014\u0011\u0086\u00be\u00b0\u00b4\u00ce\u0007\u000b\u0095>\u001bYP\u00b2}\u001c\u00f0\u00f5\u0091\u00c6";
                    var4_3 = "\u00b3&\u00c7'\u0088= \u00cf\u001c\u00cfn\u0090\u00d4J\u0017*\u00af\u00d2\u00afg\u00a0\u0093\u00dc\u0080\u00b5<\u001d\u00d9\u00f1\u0014\u0011\u0086\u00be\u00b0\u00b4\u00ce\u0007\u000b\u0095>\u001bYP\u00b2}\u001c\u00f0\u00f5\u0091\u00c6".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 59;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 92;
                            break;
                        }
                        case 1: {
                            v15 = 37;
                            break;
                        }
                        case 2: {
                            v15 = 125;
                            break;
                        }
                        case 3: {
                            v15 = 94;
                            break;
                        }
                        case 4: {
                            v15 = 64;
                            break;
                        }
                        case 5: {
                            v15 = 111;
                            break;
                        }
                        default: {
                            v15 = 68;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x776) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 226;
                case 1 -> 59;
                case 2 -> 83;
                case 3 -> 117;
                case 4 -> 154;
                case 5 -> 157;
                case 6 -> 27;
                case 7 -> 167;
                case 8 -> 143;
                case 9 -> 5;
                case 10 -> 134;
                case 11 -> 127;
                case 12 -> 205;
                case 13 -> 130;
                case 14 -> 243;
                case 15 -> 223;
                case 16 -> 190;
                case 17 -> 98;
                case 18 -> 204;
                case 19 -> 30;
                case 20 -> 67;
                case 21 -> 165;
                case 22 -> 233;
                case 23 -> 246;
                case 24 -> 219;
                case 25 -> 253;
                case 26 -> 185;
                case 27 -> 153;
                case 28 -> 60;
                case 29 -> 160;
                case 30 -> 222;
                case 31 -> 11;
                case 32 -> 146;
                case 33 -> 221;
                case 34 -> 155;
                case 35 -> 217;
                case 36 -> 25;
                case 37 -> 106;
                case 38 -> 123;
                case 39 -> 177;
                case 40 -> 166;
                case 41 -> 247;
                case 42 -> 89;
                case 43 -> 85;
                case 44 -> 38;
                case 45 -> 195;
                case 46 -> 37;
                case 47 -> 16;
                case 48 -> 197;
                case 49 -> 227;
                case 50 -> 244;
                case 51 -> 207;
                case 52 -> 237;
                case 53 -> 45;
                case 54 -> 40;
                case 55 -> 214;
                case 56 -> 115;
                case 57 -> 215;
                case 58 -> 179;
                case 59 -> 241;
                case 60 -> 176;
                case 61 -> 43;
                case 62 -> 136;
                case 63 -> 216;
                case 64 -> 156;
                case 65 -> 206;
                case 66 -> 114;
                case 67 -> 120;
                case 68 -> 147;
                case 69 -> 111;
                case 70 -> 82;
                case 71 -> 64;
                case 72 -> 22;
                case 73 -> 118;
                case 74 -> 66;
                case 75 -> 144;
                case 76 -> 188;
                case 77 -> 108;
                case 78 -> 199;
                case 79 -> 6;
                case 80 -> 3;
                case 81 -> 99;
                case 82 -> 52;
                case 83 -> 34;
                case 84 -> 102;
                case 85 -> 149;
                case 86 -> 58;
                case 87 -> 212;
                case 88 -> 92;
                case 89 -> 208;
                case 90 -> 57;
                case 91 -> 32;
                case 92 -> 13;
                case 93 -> 31;
                case 94 -> 187;
                case 95 -> 36;
                case 96 -> 1;
                case 97 -> 56;
                case 98 -> 41;
                case 99 -> 196;
                case 100 -> 200;
                case 101 -> 178;
                case 102 -> 162;
                case 103 -> 138;
                case 104 -> 124;
                case 105 -> 69;
                case 106 -> 121;
                case 107 -> 62;
                case 108 -> 17;
                case 109 -> 50;
                case 110 -> 218;
                case 111 -> 77;
                case 112 -> 175;
                case 113 -> 48;
                case 114 -> 86;
                case 115 -> 20;
                case 116 -> 23;
                case 117 -> 94;
                case 118 -> 84;
                case 119 -> 24;
                case 120 -> 88;
                case 121 -> 9;
                case 122 -> 242;
                case 123 -> 168;
                case 124 -> 189;
                case 125 -> 169;
                case 126 -> 12;
                case 127 -> 198;
                case 128 -> 191;
                case 129 -> 220;
                case 130 -> 131;
                case 131 -> 132;
                case 132 -> 76;
                case 133 -> 159;
                case 134 -> 202;
                case 135 -> 81;
                case 136 -> 90;
                case 137 -> 96;
                case 138 -> 51;
                case 139 -> 151;
                case 140 -> 128;
                case 141 -> 209;
                case 142 -> 236;
                case 143 -> 224;
                case 144 -> 73;
                case 145 -> 71;
                case 146 -> 238;
                case 147 -> 152;
                case 148 -> 19;
                case 149 -> 4;
                case 150 -> 228;
                case 151 -> 103;
                case 152 -> 104;
                case 153 -> 184;
                case 154 -> 229;
                case 155 -> 68;
                case 156 -> 235;
                case 157 -> 186;
                case 158 -> 137;
                case 159 -> 95;
                case 160 -> 213;
                case 161 -> 170;
                case 162 -> 119;
                case 163 -> 194;
                case 164 -> 107;
                case 165 -> 109;
                case 166 -> 14;
                case 167 -> 250;
                case 168 -> 249;
                case 169 -> 163;
                case 170 -> 97;
                case 171 -> 201;
                case 172 -> 255;
                case 173 -> 70;
                case 174 -> 248;
                case 175 -> 254;
                case 176 -> 18;
                case 177 -> 129;
                case 178 -> 174;
                case 179 -> 75;
                case 180 -> 10;
                case 181 -> 203;
                case 182 -> 101;
                case 183 -> 171;
                case 184 -> 113;
                case 185 -> 148;
                case 186 -> 61;
                case 187 -> 55;
                case 188 -> 141;
                case 189 -> 251;
                case 190 -> 105;
                case 191 -> 210;
                case 192 -> 100;
                case 193 -> 164;
                case 194 -> 74;
                case 195 -> 53;
                case 196 -> 26;
                case 197 -> 72;
                case 198 -> 172;
                case 199 -> 225;
                case 200 -> 44;
                case 201 -> 192;
                case 202 -> 140;
                case 203 -> 116;
                case 204 -> 161;
                case 205 -> 15;
                case 206 -> 39;
                case 207 -> 80;
                case 208 -> 78;
                case 209 -> 135;
                case 210 -> 182;
                case 211 -> 193;
                case 212 -> 33;
                case 213 -> 234;
                case 214 -> 211;
                case 215 -> 54;
                case 216 -> 240;
                case 217 -> 46;
                case 218 -> 112;
                case 219 -> 7;
                case 220 -> 245;
                case 221 -> 47;
                case 222 -> 28;
                case 223 -> 232;
                case 224 -> 65;
                case 225 -> 139;
                case 226 -> 125;
                case 227 -> 49;
                case 228 -> 145;
                case 229 -> 158;
                case 230 -> 35;
                case 231 -> 79;
                case 232 -> 252;
                case 233 -> 63;
                case 234 -> 231;
                case 235 -> 183;
                case 236 -> 230;
                case 237 -> 133;
                case 238 -> 8;
                case 239 -> 180;
                case 240 -> 173;
                case 241 -> 239;
                case 242 -> 29;
                case 243 -> 150;
                case 244 -> 122;
                case 245 -> 110;
                case 246 -> 42;
                case 247 -> 126;
                case 248 -> 21;
                case 249 -> 91;
                case 250 -> 93;
                case 251 -> 181;
                case 252 -> 87;
                case 253 -> 0;
                case 254 -> 142;
                default -> 2;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 29688201246983L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1387244880 + -28949, -1387244880 + -30563, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 43234947759101L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.J();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1806931020 + -2132, 1806931020 + 8410, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1806931020 + -2129, 1806931020 + 15993, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1806931020 + -2130, -1806931020 + -20464, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00b6\u001a\u00b3\u0088aO\u00c5\u000f\u0010e}8\u00c5\u00aa]E\u0014\u00f8\u00c73\u00e6w\u0018\u00e8\u0005";
                    var4_3 = "\u00b6\u001a\u00b3\u0088aO\u00c5\u000f\u0010e}8\u00c5\u00aa]E\u0014\u00f8\u00c73\u00e6w\u0018\u00e8\u0005".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 36;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ba\u00dd\u000bI?5Q\u00c1a\u00a6\u00a01%\u000b\u00ba\u00a6\u00d03\u00c5q\u0082\u009bd$\u00a6\u00f6\u00a9\u00b6\u008d\u008fK>+\u00f4v\u00ba\u00ca\u0095\u0007\u009eR\b\u00e0\u0092\u00f8\u001a\u00ef9Zw-\u00f5\u009b4\u009b\u0011\u00da{\u00a7";
                        var4_3 = "\u00ba\u00dd\u000bI?5Q\u00c1a\u00a6\u00a01%\u000b\u00ba\u00a6\u00d03\u00c5q\u0082\u009bd$\u00a6\u00f6\u00a9\u00b6\u008d\u008fK>+\u00f4v\u00ba\u00ca\u0095\u0007\u009eR\b\u00e0\u0092\u00f8\u001a\u00ef9Zw-\u00f5\u009b4\u009b\u0011\u00da{\u00a7".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 36;
                                break;
                            }
                            case 1: {
                                v15 = 73;
                                break;
                            }
                            case 2: {
                                v15 = 79;
                                break;
                            }
                            case 3: {
                                v15 = 99;
                                break;
                            }
                            case 4: {
                                v15 = 112;
                                break;
                            }
                            case 5: {
                                v15 = 58;
                                break;
                            }
                            default: {
                                v15 = 105;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF989C) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 5;
                    case 1 -> 89;
                    case 2 -> 1;
                    case 3 -> 28;
                    case 4 -> 189;
                    case 5 -> 220;
                    case 6 -> 82;
                    case 7 -> 136;
                    case 8 -> 4;
                    case 9 -> 253;
                    case 10 -> 76;
                    case 11 -> 192;
                    case 12 -> 150;
                    case 13 -> 222;
                    case 14 -> 55;
                    case 15 -> 57;
                    case 16 -> 183;
                    case 17 -> 65;
                    case 18 -> 114;
                    case 19 -> 122;
                    case 20 -> 113;
                    case 21 -> 26;
                    case 22 -> 85;
                    case 23 -> 203;
                    case 24 -> 231;
                    case 25 -> 20;
                    case 26 -> 45;
                    case 27 -> 195;
                    case 28 -> 210;
                    case 29 -> 14;
                    case 30 -> 34;
                    case 31 -> 134;
                    case 32 -> 188;
                    case 33 -> 166;
                    case 34 -> 181;
                    case 35 -> 109;
                    case 36 -> 245;
                    case 37 -> 80;
                    case 38 -> 126;
                    case 39 -> 140;
                    case 40 -> 221;
                    case 41 -> 151;
                    case 42 -> 31;
                    case 43 -> 70;
                    case 44 -> 92;
                    case 45 -> 61;
                    case 46 -> 60;
                    case 47 -> 95;
                    case 48 -> 145;
                    case 49 -> 51;
                    case 50 -> 39;
                    case 51 -> 215;
                    case 52 -> 146;
                    case 53 -> 9;
                    case 54 -> 198;
                    case 55 -> 163;
                    case 56 -> 216;
                    case 57 -> 227;
                    case 58 -> 196;
                    case 59 -> 155;
                    case 60 -> 81;
                    case 61 -> 226;
                    case 62 -> 233;
                    case 63 -> 172;
                    case 64 -> 63;
                    case 65 -> 152;
                    case 66 -> 87;
                    case 67 -> 8;
                    case 68 -> 160;
                    case 69 -> 149;
                    case 70 -> 211;
                    case 71 -> 204;
                    case 72 -> 74;
                    case 73 -> 193;
                    case 74 -> 23;
                    case 75 -> 239;
                    case 76 -> 107;
                    case 77 -> 205;
                    case 78 -> 72;
                    case 79 -> 139;
                    case 80 -> 17;
                    case 81 -> 64;
                    case 82 -> 106;
                    case 83 -> 185;
                    case 84 -> 62;
                    case 85 -> 242;
                    case 86 -> 112;
                    case 87 -> 248;
                    case 88 -> 59;
                    case 89 -> 35;
                    case 90 -> 27;
                    case 91 -> 100;
                    case 92 -> 44;
                    case 93 -> 225;
                    case 94 -> 157;
                    case 95 -> 88;
                    case 96 -> 249;
                    case 97 -> 71;
                    case 98 -> 207;
                    case 99 -> 137;
                    case 100 -> 99;
                    case 101 -> 217;
                    case 102 -> 86;
                    case 103 -> 125;
                    case 104 -> 255;
                    case 105 -> 138;
                    case 106 -> 2;
                    case 107 -> 254;
                    case 108 -> 213;
                    case 109 -> 153;
                    case 110 -> 42;
                    case 111 -> 240;
                    case 112 -> 190;
                    case 113 -> 78;
                    case 114 -> 184;
                    case 115 -> 144;
                    case 116 -> 246;
                    case 117 -> 141;
                    case 118 -> 201;
                    case 119 -> 197;
                    case 120 -> 252;
                    case 121 -> 3;
                    case 122 -> 36;
                    case 123 -> 202;
                    case 124 -> 41;
                    case 125 -> 37;
                    case 126 -> 53;
                    case 127 -> 251;
                    case 128 -> 69;
                    case 129 -> 182;
                    case 130 -> 75;
                    case 131 -> 68;
                    case 132 -> 235;
                    case 133 -> 49;
                    case 134 -> 90;
                    case 135 -> 98;
                    case 136 -> 241;
                    case 137 -> 178;
                    case 138 -> 180;
                    case 139 -> 30;
                    case 140 -> 6;
                    case 141 -> 158;
                    case 142 -> 19;
                    case 143 -> 154;
                    case 144 -> 38;
                    case 145 -> 96;
                    case 146 -> 232;
                    case 147 -> 129;
                    case 148 -> 250;
                    case 149 -> 93;
                    case 150 -> 237;
                    case 151 -> 247;
                    case 152 -> 171;
                    case 153 -> 174;
                    case 154 -> 214;
                    case 155 -> 208;
                    case 156 -> 18;
                    case 157 -> 187;
                    case 158 -> 108;
                    case 159 -> 199;
                    case 160 -> 32;
                    case 161 -> 40;
                    case 162 -> 243;
                    case 163 -> 101;
                    case 164 -> 54;
                    case 165 -> 133;
                    case 166 -> 124;
                    case 167 -> 234;
                    case 168 -> 244;
                    case 169 -> 230;
                    case 170 -> 179;
                    case 171 -> 79;
                    case 172 -> 46;
                    case 173 -> 223;
                    case 174 -> 33;
                    case 175 -> 29;
                    case 176 -> 212;
                    case 177 -> 105;
                    case 178 -> 123;
                    case 179 -> 127;
                    case 180 -> 209;
                    case 181 -> 48;
                    case 182 -> 132;
                    case 183 -> 224;
                    case 184 -> 66;
                    case 185 -> 135;
                    case 186 -> 115;
                    case 187 -> 22;
                    case 188 -> 117;
                    case 189 -> 218;
                    case 190 -> 0;
                    case 191 -> 168;
                    case 192 -> 236;
                    case 193 -> 130;
                    case 194 -> 111;
                    case 195 -> 56;
                    case 196 -> 219;
                    case 197 -> 162;
                    case 198 -> 67;
                    case 199 -> 58;
                    case 200 -> 200;
                    case 201 -> 102;
                    case 202 -> 148;
                    case 203 -> 164;
                    case 204 -> 147;
                    case 205 -> 104;
                    case 206 -> 103;
                    case 207 -> 161;
                    case 208 -> 167;
                    case 209 -> 238;
                    case 210 -> 16;
                    case 211 -> 50;
                    case 212 -> 15;
                    case 213 -> 43;
                    case 214 -> 191;
                    case 215 -> 143;
                    case 216 -> 194;
                    case 217 -> 25;
                    case 218 -> 128;
                    case 219 -> 84;
                    case 220 -> 7;
                    case 221 -> 10;
                    case 222 -> 110;
                    case 223 -> 142;
                    case 224 -> 186;
                    case 225 -> 170;
                    case 226 -> 173;
                    case 227 -> 13;
                    case 228 -> 119;
                    case 229 -> 121;
                    case 230 -> 177;
                    case 231 -> 77;
                    case 232 -> 73;
                    case 233 -> 159;
                    case 234 -> 11;
                    case 235 -> 118;
                    case 236 -> 120;
                    case 237 -> 94;
                    case 238 -> 169;
                    case 239 -> 52;
                    case 240 -> 47;
                    case 241 -> 97;
                    case 242 -> 228;
                    case 243 -> 176;
                    case 244 -> 91;
                    case 245 -> 175;
                    case 246 -> 156;
                    case 247 -> 12;
                    case 248 -> 24;
                    case 249 -> 165;
                    case 250 -> 206;
                    case 251 -> 21;
                    case 252 -> 131;
                    case 253 -> 83;
                    case 254 -> 229;
                    default -> 116;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 48117061146037L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "#}pbXd z\t$wch\u0015&=f1";
                    var5_4 = "#}pbXd z\t$wch\u0015&=f1".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 50;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 122;
                                    break;
                                }
                                case 1: {
                                    v11 = 42;
                                    break;
                                }
                                case 2: {
                                    v11 = 48;
                                    break;
                                }
                                case 3: {
                                    v11 = 62;
                                    break;
                                }
                                case 4: {
                                    v11 = 15;
                                    break;
                                }
                                case 5: {
                                    v11 = 58;
                                    break;
                                }
                                default: {
                                    v11 = 33;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 50379648183572L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "Hm\u0016}czD\u0004Ns\u001ag\nBl\u0011gox\\hm\u0018\tBl\u0011gox\\dg\rEj\fjeuFd`\u000b`d|";
                    var5_4 = "Hm\u0016}czD\u0004Ns\u001ag\nBl\u0011gox\\hm\u0018\tBl\u0011gox\\dg\rEj\fjeuFd`\u000b`d|".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 32;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "uX'MTBx\u0006uX'MXH";
                        var5_4 = "uX'MTBx\u0006uX'MXH".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 23;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 33;
                                break;
                            }
                            case 1: {
                                v15 = 35;
                                break;
                            }
                            case 2: {
                                v15 = 95;
                                break;
                            }
                            case 3: {
                                v15 = 41;
                                break;
                            }
                            case 4: {
                                v15 = 42;
                                break;
                            }
                            case 5: {
                                v15 = 59;
                                break;
                            }
                            default: {
                                v15 = 8;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 78206804619216L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(254931150 - (char)-32762, 254931150 - (char)-13212, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 88681898521317L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "0F\u00a3\u008b\u00c7\u0003\u00f6\u008d\u00cf\u0005\u00ef\u008b~\u00f6\u009f\r>\u00fcrR\u00eb\u0016\u00e8=\u00d0\u0080\u0099t\u00e8\u0010p}|\u0089\u0015\u00f8\u001c\u00dd\u0087\u0018\u0090*//\u009e\u00b7\u0005\u00be\u00efTz\u00da3\u0018E\u0091X}\u0086!\u0006]\u009e@\u00d3\u00f3A)e\u00fe\u0095\u008c\u00d5\u00dc\u0090(\u001cA\u00dd\u0096I;\u00d4\u0083p\u00e1\u0091\u00f9\u00c6\u0002\u00d6a\u0096Tex\u00a3\u00c7h\u00a6\u00b8\"\u00f4p";
                    var4_3 = "0F\u00a3\u008b\u00c7\u0003\u00f6\u008d\u00cf\u0005\u00ef\u008b~\u00f6\u009f\r>\u00fcrR\u00eb\u0016\u00e8=\u00d0\u0080\u0099t\u00e8\u0010p}|\u0089\u0015\u00f8\u001c\u00dd\u0087\u0018\u0090*//\u009e\u00b7\u0005\u00be\u00efTz\u00da3\u0018E\u0091X}\u0086!\u0006]\u009e@\u00d3\u00f3A)e\u00fe\u0095\u008c\u00d5\u00dc\u0090(\u001cA\u00dd\u0096I;\u00d4\u0083p\u00e1\u0091\u00f9\u00c6\u0002\u00d6a\u0096Tex\u00a3\u00c7h\u00a6\u00b8\"\u00f4p".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 42;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "}Se\u00f4\u008e\u00ef\u00d7\u0087F\u00eb\u0010\u00ec\u0087O3\u0003L\u007fJ\u00d2\u001dR\u001a\"WqbZd\u00c0\u00d0H\u0089oa\u00f9\u0005\u00a2Vu\u00deq\u00d6\rV\n\u00c6\u00f2\u00e5gu\u00e0\u00fe\u00ab\u00b7\u00d6d,~\u0000\u0005e\u00da\u0081n\u008c\u00a2\u00f5\u00fe\u00e5\u00cf\u009c\u008aK5\u00c3\u00fdt\u008d0(s\u0094\u0013\u00c4\u0083?v\u00a4G\u00fb\u00f1\u00c1";
                        var4_3 = "}Se\u00f4\u008e\u00ef\u00d7\u0087F\u00eb\u0010\u00ec\u0087O3\u0003L\u007fJ\u00d2\u001dR\u001a\"WqbZd\u00c0\u00d0H\u0089oa\u00f9\u0005\u00a2Vu\u00deq\u00d6\rV\n\u00c6\u00f2\u00e5gu\u00e0\u00fe\u00ab\u00b7\u00d6d,~\u0000\u0005e\u00da\u0081n\u008c\u00a2\u00f5\u00fe\u00e5\u00cf\u009c\u008aK5\u00c3\u00fdt\u008d0(s\u0094\u0013\u00c4\u0083?v\u00a4G\u00fb\u00f1\u00c1".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 95;
                                break;
                            }
                            case 1: {
                                v15 = 62;
                                break;
                            }
                            case 2: {
                                v15 = 9;
                                break;
                            }
                            case 3: {
                                v15 = 14;
                                break;
                            }
                            case 4: {
                                v15 = 64;
                                break;
                            }
                            case 5: {
                                v15 = 116;
                                break;
                            }
                            default: {
                                v15 = 14;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF9F18) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 49;
                    case 1 -> 162;
                    case 2 -> 242;
                    case 3 -> 20;
                    case 4 -> 140;
                    case 5 -> 41;
                    case 6 -> 72;
                    case 7 -> 127;
                    case 8 -> 184;
                    case 9 -> 244;
                    case 10 -> 167;
                    case 11 -> 95;
                    case 12 -> 67;
                    case 13 -> 178;
                    case 14 -> 213;
                    case 15 -> 42;
                    case 16 -> 97;
                    case 17 -> 164;
                    case 18 -> 194;
                    case 19 -> 247;
                    case 20 -> 117;
                    case 21 -> 9;
                    case 22 -> 60;
                    case 23 -> 71;
                    case 24 -> 210;
                    case 25 -> 146;
                    case 26 -> 94;
                    case 27 -> 91;
                    case 28 -> 126;
                    case 29 -> 163;
                    case 30 -> 197;
                    case 31 -> 171;
                    case 32 -> 170;
                    case 33 -> 222;
                    case 34 -> 225;
                    case 35 -> 128;
                    case 36 -> 82;
                    case 37 -> 189;
                    case 38 -> 80;
                    case 39 -> 139;
                    case 40 -> 249;
                    case 41 -> 5;
                    case 42 -> 186;
                    case 43 -> 154;
                    case 44 -> 232;
                    case 45 -> 246;
                    case 46 -> 32;
                    case 47 -> 96;
                    case 48 -> 191;
                    case 49 -> 255;
                    case 50 -> 22;
                    case 51 -> 38;
                    case 52 -> 52;
                    case 53 -> 192;
                    case 54 -> 131;
                    case 55 -> 2;
                    case 56 -> 113;
                    case 57 -> 89;
                    case 58 -> 190;
                    case 59 -> 223;
                    case 60 -> 66;
                    case 61 -> 221;
                    case 62 -> 8;
                    case 63 -> 18;
                    case 64 -> 208;
                    case 65 -> 122;
                    case 66 -> 43;
                    case 67 -> 13;
                    case 68 -> 121;
                    case 69 -> 150;
                    case 70 -> 7;
                    case 71 -> 248;
                    case 72 -> 148;
                    case 73 -> 30;
                    case 74 -> 51;
                    case 75 -> 27;
                    case 76 -> 241;
                    case 77 -> 159;
                    case 78 -> 130;
                    case 79 -> 0;
                    case 80 -> 70;
                    case 81 -> 110;
                    case 82 -> 240;
                    case 83 -> 182;
                    case 84 -> 152;
                    case 85 -> 57;
                    case 86 -> 138;
                    case 87 -> 200;
                    case 88 -> 14;
                    case 89 -> 44;
                    case 90 -> 153;
                    case 91 -> 206;
                    case 92 -> 108;
                    case 93 -> 88;
                    case 94 -> 24;
                    case 95 -> 173;
                    case 96 -> 205;
                    case 97 -> 65;
                    case 98 -> 15;
                    case 99 -> 76;
                    case 100 -> 142;
                    case 101 -> 161;
                    case 102 -> 68;
                    case 103 -> 40;
                    case 104 -> 211;
                    case 105 -> 115;
                    case 106 -> 39;
                    case 107 -> 69;
                    case 108 -> 188;
                    case 109 -> 174;
                    case 110 -> 102;
                    case 111 -> 77;
                    case 112 -> 104;
                    case 113 -> 114;
                    case 114 -> 172;
                    case 115 -> 220;
                    case 116 -> 98;
                    case 117 -> 236;
                    case 118 -> 84;
                    case 119 -> 12;
                    case 120 -> 147;
                    case 121 -> 250;
                    case 122 -> 169;
                    case 123 -> 29;
                    case 124 -> 90;
                    case 125 -> 124;
                    case 126 -> 217;
                    case 127 -> 136;
                    case 128 -> 112;
                    case 129 -> 216;
                    case 130 -> 183;
                    case 131 -> 54;
                    case 132 -> 83;
                    case 133 -> 62;
                    case 134 -> 141;
                    case 135 -> 166;
                    case 136 -> 63;
                    case 137 -> 37;
                    case 138 -> 207;
                    case 139 -> 193;
                    case 140 -> 48;
                    case 141 -> 151;
                    case 142 -> 165;
                    case 143 -> 101;
                    case 144 -> 31;
                    case 145 -> 87;
                    case 146 -> 144;
                    case 147 -> 47;
                    case 148 -> 111;
                    case 149 -> 3;
                    case 150 -> 181;
                    case 151 -> 1;
                    case 152 -> 59;
                    case 153 -> 109;
                    case 154 -> 218;
                    case 155 -> 129;
                    case 156 -> 180;
                    case 157 -> 233;
                    case 158 -> 228;
                    case 159 -> 199;
                    case 160 -> 219;
                    case 161 -> 185;
                    case 162 -> 105;
                    case 163 -> 79;
                    case 164 -> 195;
                    case 165 -> 237;
                    case 166 -> 116;
                    case 167 -> 196;
                    case 168 -> 21;
                    case 169 -> 132;
                    case 170 -> 187;
                    case 171 -> 17;
                    case 172 -> 73;
                    case 173 -> 201;
                    case 174 -> 6;
                    case 175 -> 245;
                    case 176 -> 203;
                    case 177 -> 45;
                    case 178 -> 75;
                    case 179 -> 92;
                    case 180 -> 86;
                    case 181 -> 74;
                    case 182 -> 16;
                    case 183 -> 177;
                    case 184 -> 234;
                    case 185 -> 81;
                    case 186 -> 198;
                    case 187 -> 118;
                    case 188 -> 227;
                    case 189 -> 143;
                    case 190 -> 252;
                    case 191 -> 175;
                    case 192 -> 145;
                    case 193 -> 160;
                    case 194 -> 157;
                    case 195 -> 238;
                    case 196 -> 231;
                    case 197 -> 176;
                    case 198 -> 179;
                    case 199 -> 214;
                    case 200 -> 78;
                    case 201 -> 229;
                    case 202 -> 50;
                    case 203 -> 25;
                    case 204 -> 254;
                    case 205 -> 19;
                    case 206 -> 212;
                    case 207 -> 209;
                    case 208 -> 99;
                    case 209 -> 56;
                    case 210 -> 36;
                    case 211 -> 34;
                    case 212 -> 53;
                    case 213 -> 26;
                    case 214 -> 215;
                    case 215 -> 119;
                    case 216 -> 35;
                    case 217 -> 58;
                    case 218 -> 251;
                    case 219 -> 202;
                    case 220 -> 155;
                    case 221 -> 93;
                    case 222 -> 149;
                    case 223 -> 33;
                    case 224 -> 239;
                    case 225 -> 100;
                    case 226 -> 168;
                    case 227 -> 103;
                    case 228 -> 120;
                    case 229 -> 4;
                    case 230 -> 55;
                    case 231 -> 125;
                    case 232 -> 156;
                    case 233 -> 135;
                    case 234 -> 235;
                    case 235 -> 137;
                    case 236 -> 64;
                    case 237 -> 85;
                    case 238 -> 123;
                    case 239 -> 204;
                    case 240 -> 61;
                    case 241 -> 23;
                    case 242 -> 46;
                    case 243 -> 106;
                    case 244 -> 230;
                    case 245 -> 133;
                    case 246 -> 134;
                    case 247 -> 224;
                    case 248 -> 226;
                    case 249 -> 243;
                    case 250 -> 253;
                    case 251 -> 107;
                    case 252 -> 11;
                    case 253 -> 158;
                    case 254 -> 10;
                    default -> 28;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 108590676248247L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1018151760 - (char)-29800, -1018151760 - -((char)-16912), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 99810511812349L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.J();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-233173530 + -17907, -233173530 + -12796, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 50699225836051L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00e8\u00fbV\u00e2n\u0003f-\u00d1";
                var4_3 = "\u00e8\u00fbV\u00e2n\u0003f-\u00d1".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 39;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 100;
                                break;
                            }
                            case 1: {
                                v11 = 20;
                                break;
                            }
                            case 2: {
                                v11 = 44;
                                break;
                            }
                            case 3: {
                                v11 = 57;
                                break;
                            }
                            case 4: {
                                v11 = 95;
                                break;
                            }
                            case 5: {
                                v11 = 113;
                                break;
                            }
                            default: {
                                v11 = 27;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x310F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 17;
                    case 1 -> 230;
                    case 2 -> 29;
                    case 3 -> 65;
                    case 4 -> 184;
                    case 5 -> 12;
                    case 6 -> 147;
                    case 7 -> 236;
                    case 8 -> 238;
                    case 9 -> 157;
                    case 10 -> 105;
                    case 11 -> 170;
                    case 12 -> 91;
                    case 13 -> 239;
                    case 14 -> 53;
                    case 15 -> 79;
                    case 16 -> 200;
                    case 17 -> 250;
                    case 18 -> 233;
                    case 19 -> 7;
                    case 20 -> 160;
                    case 21 -> 214;
                    case 22 -> 94;
                    case 23 -> 180;
                    case 24 -> 104;
                    case 25 -> 241;
                    case 26 -> 249;
                    case 27 -> 148;
                    case 28 -> 155;
                    case 29 -> 30;
                    case 30 -> 41;
                    case 31 -> 188;
                    case 32 -> 88;
                    case 33 -> 163;
                    case 34 -> 228;
                    case 35 -> 66;
                    case 36 -> 202;
                    case 37 -> 193;
                    case 38 -> 168;
                    case 39 -> 154;
                    case 40 -> 102;
                    case 41 -> 121;
                    case 42 -> 166;
                    case 43 -> 134;
                    case 44 -> 59;
                    case 45 -> 125;
                    case 46 -> 139;
                    case 47 -> 178;
                    case 48 -> 215;
                    case 49 -> 58;
                    case 50 -> 74;
                    case 51 -> 37;
                    case 52 -> 189;
                    case 53 -> 247;
                    case 54 -> 143;
                    case 55 -> 45;
                    case 56 -> 13;
                    case 57 -> 164;
                    case 58 -> 171;
                    case 59 -> 132;
                    case 60 -> 122;
                    case 61 -> 181;
                    case 62 -> 173;
                    case 63 -> 218;
                    case 64 -> 85;
                    case 65 -> 89;
                    case 66 -> 140;
                    case 67 -> 2;
                    case 68 -> 136;
                    case 69 -> 199;
                    case 70 -> 116;
                    case 71 -> 234;
                    case 72 -> 165;
                    case 73 -> 95;
                    case 74 -> 24;
                    case 75 -> 213;
                    case 76 -> 161;
                    case 77 -> 14;
                    case 78 -> 5;
                    case 79 -> 126;
                    case 80 -> 107;
                    case 81 -> 243;
                    case 82 -> 115;
                    case 83 -> 98;
                    case 84 -> 10;
                    case 85 -> 137;
                    case 86 -> 55;
                    case 87 -> 211;
                    case 88 -> 39;
                    case 89 -> 27;
                    case 90 -> 217;
                    case 91 -> 62;
                    case 92 -> 144;
                    case 93 -> 101;
                    case 94 -> 32;
                    case 95 -> 76;
                    case 96 -> 175;
                    case 97 -> 185;
                    case 98 -> 219;
                    case 99 -> 109;
                    case 100 -> 81;
                    case 101 -> 153;
                    case 102 -> 118;
                    case 103 -> 57;
                    case 104 -> 207;
                    case 105 -> 100;
                    case 106 -> 35;
                    case 107 -> 47;
                    case 108 -> 194;
                    case 109 -> 28;
                    case 110 -> 23;
                    case 111 -> 63;
                    case 112 -> 197;
                    case 113 -> 52;
                    case 114 -> 33;
                    case 115 -> 103;
                    case 116 -> 44;
                    case 117 -> 224;
                    case 118 -> 75;
                    case 119 -> 86;
                    case 120 -> 108;
                    case 121 -> 246;
                    case 122 -> 93;
                    case 123 -> 16;
                    case 124 -> 222;
                    case 125 -> 120;
                    case 126 -> 206;
                    case 127 -> 145;
                    case 128 -> 124;
                    case 129 -> 68;
                    case 130 -> 158;
                    case 131 -> 22;
                    case 132 -> 26;
                    case 133 -> 195;
                    case 134 -> 82;
                    case 135 -> 110;
                    case 136 -> 119;
                    case 137 -> 232;
                    case 138 -> 11;
                    case 139 -> 156;
                    case 140 -> 152;
                    case 141 -> 174;
                    case 142 -> 56;
                    case 143 -> 0;
                    case 144 -> 240;
                    case 145 -> 254;
                    case 146 -> 133;
                    case 147 -> 112;
                    case 148 -> 129;
                    case 149 -> 127;
                    case 150 -> 203;
                    case 151 -> 25;
                    case 152 -> 38;
                    case 153 -> 251;
                    case 154 -> 205;
                    case 155 -> 40;
                    case 156 -> 43;
                    case 157 -> 220;
                    case 158 -> 99;
                    case 159 -> 67;
                    case 160 -> 49;
                    case 161 -> 242;
                    case 162 -> 84;
                    case 163 -> 192;
                    case 164 -> 20;
                    case 165 -> 167;
                    case 166 -> 212;
                    case 167 -> 1;
                    case 168 -> 204;
                    case 169 -> 226;
                    case 170 -> 69;
                    case 171 -> 77;
                    case 172 -> 225;
                    case 173 -> 31;
                    case 174 -> 60;
                    case 175 -> 131;
                    case 176 -> 128;
                    case 177 -> 141;
                    case 178 -> 61;
                    case 179 -> 248;
                    case 180 -> 135;
                    case 181 -> 252;
                    case 182 -> 54;
                    case 183 -> 176;
                    case 184 -> 83;
                    case 185 -> 183;
                    case 186 -> 223;
                    case 187 -> 21;
                    case 188 -> 130;
                    case 189 -> 15;
                    case 190 -> 64;
                    case 191 -> 123;
                    case 192 -> 149;
                    case 193 -> 117;
                    case 194 -> 221;
                    case 195 -> 177;
                    case 196 -> 146;
                    case 197 -> 4;
                    case 198 -> 87;
                    case 199 -> 71;
                    case 200 -> 159;
                    case 201 -> 70;
                    case 202 -> 198;
                    case 203 -> 48;
                    case 204 -> 92;
                    case 205 -> 196;
                    case 206 -> 34;
                    case 207 -> 51;
                    case 208 -> 19;
                    case 209 -> 237;
                    case 210 -> 186;
                    case 211 -> 162;
                    case 212 -> 18;
                    case 213 -> 190;
                    case 214 -> 6;
                    case 215 -> 151;
                    case 216 -> 78;
                    case 217 -> 113;
                    case 218 -> 114;
                    case 219 -> 72;
                    case 220 -> 191;
                    case 221 -> 227;
                    case 222 -> 106;
                    case 223 -> 244;
                    case 224 -> 9;
                    case 225 -> 179;
                    case 226 -> 8;
                    case 227 -> 73;
                    case 228 -> 3;
                    case 229 -> 90;
                    case 230 -> 169;
                    case 231 -> 138;
                    case 232 -> 46;
                    case 233 -> 96;
                    case 234 -> 201;
                    case 235 -> 50;
                    case 236 -> 253;
                    case 237 -> 150;
                    case 238 -> 255;
                    case 239 -> 172;
                    case 240 -> 216;
                    case 241 -> 187;
                    case 242 -> 80;
                    case 243 -> 235;
                    case 244 -> 245;
                    case 245 -> 182;
                    case 246 -> 208;
                    case 247 -> 42;
                    case 248 -> 36;
                    case 249 -> 231;
                    case 250 -> 97;
                    case 251 -> 209;
                    case 252 -> 229;
                    case 253 -> 210;
                    case 254 -> 142;
                    default -> 111;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

