/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.init;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.jetbrains.php.drupal.DrupalBundle;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalConfigurable;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import java.util.Collection;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DrupalModuleDetectionManager {
    private DrupalModuleDetectionManager() {
    }

    public static void offerIntegrationSetup(Project project) {
        if (project == null || project.isDefault()) {
            return;
        }
        DrupalDataService dataService = DrupalDataService.getInstance(project);
        if (dataService == null || dataService.isEnabled() || dataService.doNotAskAgain()) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            VirtualFile drupalDir = DrupalModuleDetectionManager.findDrupalDirToEnableSupport(project);
            if (drupalDir != null) {
                DrupalModuleDetectionManager.notifyAboutDrupalSupport(project, drupalDir);
            }
        }).expireWith((Disposable)dataService).inSmartMode(project).submit((Executor)NonUrgentExecutor.getInstance());
    }

    private static void notifyAboutDrupalSupport(final Project project, @Nullable VirtualFile drupalDir) {
        String message = DrupalBundle.message("drupal.set.up.integration.popup", new Object[0]);
        Function<Notification, AnAction> enableSupportAction = notification -> new AnAction(DrupalBundle.message("action.enable.drupal.support.text", new Object[0]), (Notification)notification, project, drupalDir){
            final /* synthetic */ Notification val$notification;
            final /* synthetic */ Project val$project;
            final /* synthetic */ VirtualFile val$drupalDir;
            {
                this.val$notification = notification;
                this.val$project = project;
                this.val$drupalDir = virtualFile;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.val$notification.expire();
                DrupalConfigurable configurable = new DrupalConfigurable(this.val$project);
                String path = this.val$drupalDir == null ? DrupalDataService.getLastDrupalPath() : this.val$drupalDir.getPath();
                DrupalVersion version = path != null && path.equals(DrupalDataService.getLastDrupalPath()) ? DrupalDataService.getLastDrupalVersion() : DrupalVersion.findNewestSuitable(this.val$drupalDir);
                ShowSettingsUtil.getInstance().editConfigurable(this.val$project, (Configurable)configurable, () -> {
                    configurable.setDrupalDir(path);
                    configurable.setDrupalVersion(version);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/init/DrupalModuleDetectionManager$1", "actionPerformed"));
            }
        };
        Function<Notification, AnAction> doNotAskAction = notification -> new DumbAwareAction(DrupalBundle.message("action.do.not.ask.again.text", new Object[0]), (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DrupalDataService.getInstance(project).setDoNotAskAgain(true);
                this.val$notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/init/DrupalModuleDetectionManager$2", "actionPerformed"));
            }
        };
        DrupalUtil.notifyGlobally(project, DrupalBundle.message("plugin.title.sentence", new Object[0]), message, NotificationType.INFORMATION, enableSupportAction, doNotAskAction);
    }

    @Nullable
    public static VirtualFile findDrupalDirToEnableSupport(@NotNull Project project) {
        VirtualFile baseDir;
        if (project == null) {
            DrupalModuleDetectionManager.$$$reportNull$$$0(0);
        }
        if ((baseDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return null;
        }
        if (DrupalModuleDetectionManager.isDrupalModule(baseDir)) {
            return baseDir;
        }
        Collection scriptFiles = FilenameIndex.getVirtualFilesByName((String)"drupal.sh", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project));
        for (VirtualFile file : scriptFiles) {
            VirtualFile veryGrandParent;
            VirtualFile parent = file.getParent();
            if (!"scripts".equals(parent.getName())) continue;
            VirtualFile grandParent = parent.getParent();
            if (DrupalUtil.validateDrupalInstallation(grandParent, null) == null) {
                return grandParent;
            }
            if (grandParent == null || !"scripts".equals(parent.getName()) || DrupalUtil.validateDrupalInstallation(veryGrandParent = grandParent.getParent(), null) != null) continue;
            return veryGrandParent;
        }
        return null;
    }

    private static boolean isDrupalModule(@NotNull VirtualFile dir) {
        if (dir == null) {
            DrupalModuleDetectionManager.$$$reportNull$$$0(1);
        }
        return DrupalModuleDetectionManager.isDrupal6Or7Module(dir) || DrupalModuleDetectionManager.isDrupal8Module(dir);
    }

    private static boolean isDrupal6Or7Module(@NotNull VirtualFile dir) {
        String name;
        if (dir == null) {
            DrupalModuleDetectionManager.$$$reportNull$$$0(2);
        }
        if (dir.findChild((name = dir.getName()) + ".info") == null && dir.findChild(name + ".info.yml") == null) {
            return false;
        }
        return dir.findChild(name + ".module") != null;
    }

    private static boolean isDrupal8Module(@NotNull VirtualFile dir) {
        VirtualFile[] children;
        if (dir == null) {
            DrupalModuleDetectionManager.$$$reportNull$$$0(3);
        }
        for (VirtualFile child : children = dir.getChildren()) {
            CharSequence charSequence;
            if (!child.getName().endsWith(".info.yml") || child.isDirectory() || !DrupalModuleDetectionManager.containsKeys(charSequence = LoadTextUtil.loadText((VirtualFile)child), "name", "type", "core")) continue;
            return true;
        }
        return false;
    }

    public static boolean containsKeys(CharSequence text, String ... keys) {
        for (String key : keys) {
            int endIndex;
            int index = StringUtil.indexOf((CharSequence)text, (CharSequence)key);
            if (index < 0) {
                return false;
            }
            if (index == 0) continue;
            if (text.charAt(index - 1) != '\n') {
                return false;
            }
            for (endIndex = index + key.length(); endIndex < text.length() && text.charAt(endIndex) == ' '; ++endIndex) {
            }
            if (endIndex != text.length() && text.charAt(endIndex) == ':') continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/drupal/init/DrupalModuleDetectionManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findDrupalDirToEnableSupport";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDrupalModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDrupal6Or7Module";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isDrupal8Module";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

