/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.hooks;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.drupal.DrupalUtil;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class DrupalHooksUtils {
    @NonNls
    static final String HOOK_FUNCTION_NAME_PREFIX = "hook_";
    @NonNls
    static final String DRUPAL_HOOK_API_HELPER_EXTENSION = ".api.php";

    private DrupalHooksUtils() {
    }

    @Nullable
    static String getPotentialHookName(PsiElement element, @Nullable Map<VirtualFile, String> hookBaseNamesCache) {
        if (!(element instanceof Function)) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        String moduleName = DrupalUtil.getHookBaseName(psiFile.getVirtualFile(), hookBaseNamesCache, element.getProject());
        if (moduleName == null) {
            return null;
        }
        String moduleNamePrefix = moduleName + "_";
        String functionName = ((Function)element).getName();
        if (!functionName.startsWith(moduleNamePrefix)) {
            return null;
        }
        return functionName.substring(moduleNamePrefix.length());
    }

    static Function getDescriptiveFunctionByHookName(String hookName, Project project) {
        DrupalDataService dataService = DrupalDataService.getInstance(project);
        if (!dataService.isEnabled() || !dataService.isVersionValid()) {
            return null;
        }
        String functionName = HOOK_FUNCTION_NAME_PREFIX + hookName;
        Collection functions = PhpIndex.getInstance((Project)project).getFunctionsByName(functionName);
        for (Function suitableFunction : functions) {
            String fileName;
            PsiFile containingFile = suitableFunction.getContainingFile();
            if (containingFile == null || !(fileName = containingFile.getName()).endsWith(DRUPAL_HOOK_API_HELPER_EXTENSION)) continue;
            return suitableFunction;
        }
        return null;
    }

    @Nullable
    public static String getHookNameFromDocFunction(PsiElement element) {
        if (!(element instanceof Function) || element instanceof Method) {
            return null;
        }
        String functionName = ((Function)element).getName();
        if (!functionName.startsWith(HOOK_FUNCTION_NAME_PREFIX)) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file == null || !file.getName().endsWith(DRUPAL_HOOK_API_HELPER_EXTENSION)) {
            return null;
        }
        return functionName;
    }
}

