/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.tools.quality.psalm;

import com.google.gson.JsonElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.Consumer;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.tools.quality.QualityToolConfigurationManager;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import com.jetbrains.php.tools.quality.psalm.PsalmConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmConfigurationManager;
import com.jetbrains.php.tools.quality.psalm.PsalmGlobalInspection;
import com.jetbrains.php.tools.quality.psalm.PsalmOpenSettingsProvider;
import com.jetbrains.php.tools.quality.psalm.PsalmOptionsConfiguration;
import com.jetbrains.php.tools.quality.psalm.PsalmQualityToolType;
import com.jetbrains.php.tools.quality.psalm.PsalmValidationInspection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsalmComposerConfig
extends QualityToolsComposerConfig<PsalmConfiguration, PsalmValidationInspection> {
    @NonNls
    private static final String PACKAGE = "vimeo/psalm";
    @NonNls
    private static final String RELATIVE_PATH = "bin/psalm" + (SystemInfo.isWindows ? ".bat" : "");
    @NonNls
    private static final String PSALM_XML = "psalm.xml";

    public PsalmComposerConfig() {
        super(PACKAGE, RELATIVE_PATH);
    }

    public String getQualityInspectionShortName() {
        return PsalmQualityToolType.INSTANCE.getInspectionId();
    }

    protected boolean applyRulesetFromComposer(@NotNull Project project, PsalmConfiguration configuration) {
        if (project == null) {
            PsalmComposerConfig.$$$reportNull$$$0(0);
        }
        String configPath = ComposerDataService.getInstance((Project)project).getConfigPath();
        VirtualFile config = LocalFileSystem.getInstance().refreshAndFindFileByPath(configPath);
        if (config == null) {
            return false;
        }
        String ruleset = this.getRuleset(config);
        if (ruleset == null) {
            return false;
        }
        VirtualFile customRulesetFile = this.detectCustomRulesetFile(config.getParent(), ruleset);
        if (customRulesetFile != null) {
            return this.modifyRulesetPsalmInspectionSetting(project, (Consumer<PsalmGlobalInspection>)((Consumer)tool -> PsalmComposerConfig.applyRuleset(project, customRulesetFile.getPath())));
        }
        return false;
    }

    protected boolean modifyRulesetPsalmInspectionSetting(@NotNull Project project, @NotNull Consumer<PsalmGlobalInspection> consumer) {
        VirtualFile projectDir;
        if (project == null) {
            PsalmComposerConfig.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            PsalmComposerConfig.$$$reportNull$$$0(2);
        }
        if ((projectDir = project.getBaseDir()) == null) {
            return false;
        }
        PsiDirectory file = PsiManager.getInstance((Project)project).findDirectory(projectDir);
        if (file != null) {
            Key key = Key.create((String)PsalmQualityToolType.INSTANCE.getInspectionId());
            InspectionProfileManager.getInstance((Project)project).getCurrentProfile().modifyToolSettings(key, (PsiElement)file, consumer);
            return true;
        }
        return false;
    }

    protected void checkComposerScriptsLeaves(JsonElement element, Ref<String> result) {
        String string = element.getAsString();
        if (string != null && string.contains("psalm")) {
            List split = StringUtil.split((String)string, (String)" ");
            for (String arg : split) {
                String prefix = "--config=";
                if (StringUtil.startsWith((CharSequence)arg, (CharSequence)"--config=")) {
                    result.set((Object)StringUtil.trimStart((String)arg, (String)"--config="));
                    return;
                }
                int index = split.indexOf(arg);
                if (!StringUtil.equals((CharSequence)arg, (CharSequence)"-c") || index >= split.size() - 1) continue;
                result.set((Object)((String)split.get(index + 1)));
                return;
            }
        }
    }

    protected boolean applyRulesetFromRoot(@NotNull Project project) {
        VirtualFile customRulesetFile;
        if (project == null) {
            PsalmComposerConfig.$$$reportNull$$$0(3);
        }
        if ((customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), PSALM_XML)) == null) {
            customRulesetFile = this.detectCustomRulesetFile(project.getBaseDir(), "psalm.xml.dist");
        }
        if (customRulesetFile != null) {
            String path = customRulesetFile.getPath();
            return this.modifyRulesetPsalmInspectionSetting(project, (Consumer<PsalmGlobalInspection>)((Consumer)tool -> PsalmComposerConfig.applyRuleset(project, path)));
        }
        return false;
    }

    @Nullable
    public ComposerLogMessageBuilder.Settings getSettings() {
        return PsalmOpenSettingsProvider.PSALM_OPEN_SETTINGS_PROVIDER;
    }

    private static void applyRuleset(Project project, String customRuleset) {
        PsalmOptionsConfiguration.getInstance(project).setConfig(customRuleset);
    }

    @NotNull
    public QualityToolConfigurationManager<PsalmConfiguration> getConfigurationManager(@NotNull Project project) {
        if (project == null) {
            PsalmComposerConfig.$$$reportNull$$$0(4);
        }
        PsalmConfigurationManager psalmConfigurationManager = PsalmConfigurationManager.getInstance(project);
        if (psalmConfigurationManager == null) {
            PsalmComposerConfig.$$$reportNull$$$0(5);
        }
        return psalmConfigurationManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/tools/quality/psalm/PsalmComposerConfig";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/tools/quality/psalm/PsalmComposerConfig";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromComposer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modifyRulesetPsalmInspectionSetting";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyRulesetFromRoot";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

