/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.eval.scratch;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ui.JBFont;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.eval.scratch.PhpEvalScratchFileEditorWithPreview;
import java.awt.Font;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class PhpEvalOpenLinkInBrowserAction
extends AnAction
implements DumbAware,
CustomComponentAction {
    private final PhpEvalScratchFileEditorWithPreview myEditor;

    public PhpEvalOpenLinkInBrowserAction(PhpEvalScratchFileEditorWithPreview editor) {
        super(PhpBundle.message((String)"action.open.3v4l.link.in.browser.text", (Object[])new Object[0]));
        this.myEditor = editor;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        String currentUrl;
        if (e == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(0);
        }
        if ((currentUrl = this.myEditor.getCurrentUrl()) == null) {
            return;
        }
        BrowserUtil.browse((String)currentUrl);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabledAndVisible(this.myEditor.getCurrentUrl() != null);
        e.getPresentation().setIcon(AllIcons.General.Web);
        e.getPresentation().setText(this.getPresentableCurrentUrl());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        if (presentation == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(3);
        }
        if (place == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(4);
        }
        HyperlinkLabel label = new HyperlinkLabel(this.getPresentableCurrentUrl()){

            protected int getTextOffset() {
                return 8;
            }
        };
        label.addHyperlinkListener(e -> {
            String currentUrl = this.myEditor.getCurrentUrl();
            if (currentUrl != null) {
                BrowserUtil.browse((String)currentUrl);
            }
        });
        PhpEvalOpenLinkInBrowserAction.setLink(label, this.myEditor.getCurrentUrl());
        HyperlinkLabel hyperlinkLabel = label;
        if (hyperlinkLabel == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(5);
        }
        return hyperlinkLabel;
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        if (component == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(6);
        }
        if (presentation == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(7);
        }
        if (component instanceof HyperlinkLabel) {
            HyperlinkLabel label = (HyperlinkLabel)component;
            PhpEvalOpenLinkInBrowserAction.setLink(label, presentation.getText());
        }
        component.setVisible(presentation.isVisible());
    }

    private static void setLink(@NotNull HyperlinkLabel label, @NlsSafe String link) {
        if (label == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(8);
        }
        @NlsSafe String hyperlink = "<hyperlink>" + link + "</hyperlink>";
        label.setTextWithHyperlink(hyperlink);
        label.setFont((Font)JBFont.medium());
        label.setIconAtRight(false);
        label.setIcon(null);
    }

    @NotNull
    @NlsSafe
    private String getPresentableCurrentUrl() {
        String s = StringUtil.notNullize((String)this.myEditor.getCurrentUrl());
        int i = s.lastIndexOf(35);
        if (i >= 0) {
            s = s.substring(0, i);
        }
        String string = StringUtil.trimStart((String)s, (String)"https://");
        if (string == null) {
            PhpEvalOpenLinkInBrowserAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/eval/scratch/PhpEvalOpenLinkInBrowserAction";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/eval/scratch/PhpEvalOpenLinkInBrowserAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCustomComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableCurrentUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createCustomComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateCustomComponent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setLink";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 9 -> new IllegalStateException(string);
        };
    }
}

