/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.Envelope;

public class LineLimiter {
    private Envelope limitEnv;
    private CoordinateList ptList;
    private Coordinate lastOutside = null;
    private List<Coordinate[]> sections = null;

    public LineLimiter(Envelope env) {
        this.limitEnv = env;
    }

    public List<Coordinate[]> limit(Coordinate[] pts) {
        this.lastOutside = null;
        this.ptList = null;
        this.sections = new ArrayList<Coordinate[]>();
        for (int i2 = 0; i2 < pts.length; ++i2) {
            Coordinate p2 = pts[i2];
            if (this.limitEnv.intersects(p2)) {
                this.addPoint(p2);
                continue;
            }
            this.addOutside(p2);
        }
        this.finishSection();
        return this.sections;
    }

    private void addPoint(Coordinate p2) {
        if (p2 == null) {
            return;
        }
        this.startSection();
        this.ptList.add(p2, false);
    }

    private void addOutside(Coordinate p2) {
        boolean segIntersects = this.isLastSegmentIntersecting(p2);
        if (!segIntersects) {
            this.finishSection();
        } else {
            this.addPoint(this.lastOutside);
            this.addPoint(p2);
        }
        this.lastOutside = p2;
    }

    private boolean isLastSegmentIntersecting(Coordinate p2) {
        if (this.lastOutside == null) {
            return this.isSectionOpen();
        }
        return this.limitEnv.intersects(this.lastOutside, p2);
    }

    private boolean isSectionOpen() {
        return this.ptList != null;
    }

    private void startSection() {
        if (this.ptList == null) {
            this.ptList = new CoordinateList();
        }
        if (this.lastOutside != null) {
            this.ptList.add(this.lastOutside, false);
        }
        this.lastOutside = null;
    }

    private void finishSection() {
        if (this.ptList == null) {
            return;
        }
        if (this.lastOutside != null) {
            this.ptList.add(this.lastOutside, false);
            this.lastOutside = null;
        }
        Coordinate[] section = this.ptList.toCoordinateArray();
        this.sections.add(section);
        this.ptList = null;
    }
}

