/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Range;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpIntermediateTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FileModifier.SafeTypeForPreview
public class PhpType {
    private static final Logger LOG = Logger.getInstance(PhpType.class);
    @NlsSafe
    public static final String PHPSTORM_HELPERS = "___PHPSTORM_HELPERS";
    @NlsSafe
    public static final String _PHPSTORM_HELPERS_FQN = "\\___PHPSTORM_HELPERS";
    @NlsSafe
    public static final String _OBJECT_FQN = "\\___PHPSTORM_HELPERS\\object";
    @NlsSafe
    public static final String _OBJECT = "\\object";
    @NlsSafe
    public static final String _MIXED = "\\mixed";
    @NlsSafe
    public static final String _VOID = "\\void";
    @NlsSafe
    public static final String _NEVER = "\\never";
    @NlsSafe
    public static final String _NULL = "\\null";
    @NlsSafe
    public static final String _ARRAY = "\\array";
    @NlsSafe
    public static final String _ITERABLE = "\\iterable";
    @NlsSafe
    public static final String _INT = "\\int";
    @NlsSafe
    public static final String _INTEGER = "\\integer";
    @NlsSafe
    public static final String _BOOL = "\\bool";
    @NlsSafe
    public static final String _BOOLEAN = "\\boolean";
    @NlsSafe
    public static final String _TRUE = "\\true";
    @NlsSafe
    public static final String _FALSE = "\\false";
    @NlsSafe
    public static final String _STRING = "\\string";
    @NlsSafe
    public static final String _FLOAT = "\\float";
    @NlsSafe
    public static final String _DOUBLE = "\\double";
    @NlsSafe
    public static final String _CLOSURE = "\\Closure";
    @NlsSafe
    public static final String _CALLBACK = "\\callback";
    @NlsSafe
    public static final String _CALLABLE = "\\callable";
    @NlsSafe
    public static final String _NUMBER = "\\number";
    @NlsSafe
    public static final String _RESOURCE = "\\resource";
    @NlsSafe
    public static final String _EXCEPTION = "\\Exception";
    @NlsSafe
    public static final String _THROWABLE = "\\Throwable";
    @NlsSafe
    public static final String _STRINGABLE = "\\Stringable";
    @NlsSafe
    public static final String _CLASS_STRING = "\\class-string";
    public static final PhpType EMPTY = PhpType.builder().build();
    public static final PhpType MIXED = PhpType.builder().add("\\mixed").build();
    public static final PhpType NULL = PhpType.builder().add("\\null").build();
    public static final PhpType STRING = PhpType.builder().add("\\string").build();
    public static final PhpType BOOLEAN = PhpType.builder().add("\\bool").build();
    public static final PhpType FALSE = PhpType.builder().add("\\false").build();
    public static final PhpType TRUE = PhpType.builder().add("\\true").build();
    public static final PhpType INT = PhpType.builder().add("\\int").build();
    public static final PhpType FLOAT = PhpType.builder().add("\\float").build();
    public static final PhpType OBJECT = PhpType.builder().add("\\object").build();
    public static final PhpType CLOSURE = PhpType.builder().add("\\Closure").build();
    public static final PhpType CALLABLE = PhpType.builder().add("\\callable").build();
    public static final PhpType RESOURCE = PhpType.builder().add("\\resource").build();
    public static final PhpType ARRAY = PhpType.builder().add("\\array").build();
    public static final PhpType ITERABLE = PhpType.builder().add("\\iterable").build();
    public static final PhpType NUMBER = PhpType.builder().add("\\number").build();
    public static final PhpType VOID = PhpType.builder().add("\\void").build();
    public static final PhpType NEVER = PhpType.builder().add("\\never").build();
    public static final PhpType CLASS_STRING = PhpType.builder().add("\\class-string").build();
    public static final PhpType NUMERIC = PhpType.builder().add(STRING).add(INT).build();
    public static final PhpType SCALAR = PhpType.builder().add(INT).add(FLOAT).add(STRING).add(BOOLEAN).add(FALSE).add(TRUE).build();
    public static final PhpType FLOAT_INT = PhpType.builder().add(FLOAT).add(INT).build();
    public static final PhpType UNSET = PhpType.builder().add("unset").build();
    public static final PhpType STATIC = PhpType.builder().add("static").build();
    public static final PhpType EXCEPTION = PhpType.builder().add("\\Exception").build();
    public static final PhpType THROWABLE = PhpType.builder().add("\\Throwable").build();
    public static final PhpType $THIS = PhpType.builder().add("$this").build();
    @NlsSafe
    public static final String _TRAVERSABLE = "\\Traversable";
    public static final PhpType TRAVERSABLE = new PhpType().add("\\Traversable");
    public static final PhpType ARRAY_TRAVERSABLE_TYPE = new PhpType().add("\\array").add("\\Traversable");
    public static final String EXCLUDED_INCOMPLETE_TYPE_SEPARATOR = "\u2206";
    public static final String INTERSECTION_TYPE_DELIMITER = "&";
    private static final char PARAMETRISED_TYPE_START = '<';
    private static final char PARAMETRISED_TYPE_END = '>';
    private boolean myTypeHasParametrizedParts = false;
    @Nullable
    private Set<String> types;
    private boolean isComplete = true;
    private boolean dirty = false;
    @NlsSafe
    private String myStringResolved;
    @NlsSafe
    private String myString;

    public PhpType createImmutableType() {
        return this instanceof ImmutablePhpType ? this : new ImmutablePhpType().addInternal(this);
    }

    @NotNull
    public PhpType map(@NotNull @NotNull Function<@NotNull String, @Nullable String> typeMapper) {
        if (typeMapper == null) {
            PhpType.$$$reportNull$$$0(0);
        }
        if (this.isEmpty()) {
            PhpType phpType = this;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpType res = new PhpType();
        for (String type : this.getTypesWithParametrisedParts()) {
            res.add(typeMapper.apply(type));
        }
        PhpType phpType = res;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    public PhpType filterOutIntermediateTypes() {
        return this.filterOut(PhpIntermediateTypeProvider::providerExists);
    }

    public boolean hasIntersectionType() {
        return ContainerUtil.exists(this.getTypes(), PhpType::isIntersectionType);
    }

    @NotNull
    public PhpType removeParametrisedParts() {
        PhpType phpType = this.map(PhpType::removeParametrisedType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(3);
        }
        return phpType;
    }

    public boolean containsAll(@NotNull PhpType type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(4);
        }
        return this.getTypes().containsAll(type.getTypes());
    }

    public static boolean isIntersectionType(String s) {
        return s.contains(INTERSECTION_TYPE_DELIMITER);
    }

    @NlsSafe
    public static String unpluralize(@NotNull @NlsSafe String type, int dimension) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(5);
        }
        return type.substring(0, type.length() - dimension * 2);
    }

    @NlsSafe
    public static String pluralise(@NotNull @NlsSafe String type, int dimension) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(6);
        }
        return type + StringUtil.repeat((String)"[]", (int)dimension);
    }

    public static boolean isPrimitiveClassAccess(@NlsSafe String subject) {
        char key;
        String originalSubject = subject;
        while (PhpType.isSignedType(subject) && (PhpTypeSignatureKey.FIELD.is(key = subject.charAt(1)) || PhpTypeSignatureKey.METHOD.is(key))) {
            int i = subject.lastIndexOf(46);
            if (i < 0) {
                LOG.debug(String.format("Invalid subject: %s\nProcessed subject: %s", originalSubject, subject));
                return false;
            }
            subject = subject.substring(2, i);
        }
        return PhpType.isSignedType(subject) && PhpTypeSignatureKey.CLASS.is(subject.charAt(1)) && PhpType.isPrimitiveType(subject.substring(2));
    }

    @NotNull
    public static String unpluralize(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(7);
        }
        String string = PhpType.unpluralize(type, PhpType.getPluralDimension(type));
        if (string == null) {
            PhpType.$$$reportNull$$$0(8);
        }
        return string;
    }

    @ApiStatus.Internal
    public static boolean isResourceOrNumberType(@Nullable String typeName) {
        if (typeName == null) {
            return false;
        }
        Object fqn = !typeName.startsWith("\\") ? "\\" + typeName : typeName;
        return _RESOURCE.equalsIgnoreCase((String)fqn) || _NUMBER.equalsIgnoreCase((String)fqn);
    }

    @NotNull
    public static String applyIntersectionTypesAware(@NotNull String fqn, Function<@NotNull String, @NotNull String> function) {
        if (fqn == null) {
            PhpType.$$$reportNull$$$0(9);
        }
        if (fqn.contains(INTERSECTION_TYPE_DELIMITER)) {
            String string = StringUtil.split((String)fqn, (String)INTERSECTION_TYPE_DELIMITER).stream().map(function).collect(Collectors.joining(INTERSECTION_TYPE_DELIMITER));
            if (string == null) {
                PhpType.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = function.apply(fqn);
        if (string == null) {
            PhpType.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static PhpType createParametrized(@NotNull String baseName, String ... parameters) {
        if (baseName == null) {
            PhpType.$$$reportNull$$$0(12);
        }
        return PhpType.from(PhpType.createParametrizedType(baseName, parameters));
    }

    @NotNull
    public static String createParametrizedType(@NotNull String baseName, Collection<String> parameters) {
        if (baseName == null) {
            PhpType.$$$reportNull$$$0(13);
        }
        if (parameters.isEmpty()) {
            String string = baseName;
            if (string == null) {
                PhpType.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (!((String)baseName).startsWith("\\") && !((String)baseName).startsWith("#")) {
            baseName = "\\" + (String)baseName;
        }
        String string = (String)baseName + "<" + StringUtil.join(parameters, (String)",") + ">";
        if (string == null) {
            PhpType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public static String createParametrizedType(@NotNull String baseName, String ... parameters) {
        if (baseName == null) {
            PhpType.$$$reportNull$$$0(16);
        }
        return PhpType.createParametrizedType(baseName, Arrays.asList(parameters));
    }

    @Nullable
    public static Range<Integer> getIntRangeBounds(String type) {
        List<String> parts;
        if (type != null && type.startsWith("\\int<") && (parts = PhpType.getParametrizedParts(type)).size() == 2) {
            Integer min = PhpType.parseBound(parts.get(0));
            Integer max = PhpType.parseBound(parts.get(1));
            return min != null && max != null ? new Range((Comparable)min, (Comparable)max) : null;
        }
        return null;
    }

    @NotNull
    public static List<String> getParametrizedParts(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(17);
        }
        if (!PhpType.hasParameterizedPart(type)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                PhpType.$$$reportNull$$$0(18);
            }
            return list;
        }
        int l = type.indexOf(60);
        int r = type.lastIndexOf(62);
        if (l >= 0 && r >= 0) {
            String parametrizedSubstring = type.substring(l + 1, r);
            parametrizedSubstring = PhpType.escapeAllCommasInParametrizedParts(parametrizedSubstring);
            List list = ContainerUtil.map((Collection)StringUtil.split((String)parametrizedSubstring, (String)",", (boolean)true, (boolean)false), t -> t.replace(';', ','));
            if (list == null) {
                PhpType.$$$reportNull$$$0(19);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PhpType.$$$reportNull$$$0(20);
        }
        return list;
    }

    private static String escapeAllCommasInParametrizedParts(String type) {
        Collection<Pair<Integer, Integer>> parametrizedParts = PhpType.collectParametrizedParts((String)type);
        int i = -1;
        while ((i = ((String)type).indexOf(44, i)) >= 0) {
            int pos = i;
            if (ContainerUtil.exists(parametrizedParts, p -> pos > (Integer)p.getFirst() && pos < (Integer)p.getSecond())) {
                type = ((String)type).substring(0, i) + ";" + ((String)type).substring(i + 1);
            }
            ++i;
        }
        return type;
    }

    private static Collection<Pair<Integer, Integer>> collectParametrizedParts(String type) {
        ArrayList<Pair<Integer, Integer>> res = new ArrayList<Pair<Integer, Integer>>();
        ArrayDeque<Integer> stack = new ArrayDeque<Integer>();
        for (int i = 0; i < type.length(); ++i) {
            if (type.charAt(i) == '<') {
                stack.addLast(i);
                continue;
            }
            if (type.charAt(i) != '>' || stack.isEmpty()) continue;
            res.add((Pair<Integer, Integer>)Pair.create((Object)((Integer)stack.pollFirst()), (Object)i));
        }
        return res;
    }

    @Nullable
    private static Integer parseBound(String s) {
        if (s.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (s.equals("min")) {
            return Integer.MIN_VALUE;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean globalTypeEquals(PhpTypedElement f, PhpTypedElement s) {
        PhpType fType = f.getType();
        PhpType sType = s.getType();
        Set<String> fWithoutUnknown = PhpType.replaceTrueFalseWithBoolean(fType.filterUnknown().getTypes());
        Set<String> sWithoutUnknown = PhpType.replaceTrueFalseWithBoolean(sType.filterUnknown().getTypes());
        if (!fWithoutUnknown.isEmpty() && !sWithoutUnknown.isEmpty() && ContainerUtil.exists(fWithoutUnknown, t -> !sWithoutUnknown.contains(t)) || ContainerUtil.exists(sWithoutUnknown, t -> !fWithoutUnknown.contains(t))) {
            return false;
        }
        Project project = f.getProject();
        return fType.hasUnresolved() ? PhpType.globalTypeEquals(project, fType, sType) : PhpType.globalTypeEquals(project, sType, fType);
    }

    public static boolean globalTypeEquals(PhpTypedElement element, PhpType globalType) {
        return PhpType.globalTypeEquals(element.getProject(), element.getType(), globalType);
    }

    public static boolean globalTypeEquals(Project project, PhpType localType, PhpType globalType) {
        if (!globalType.hasUnresolved()) {
            PhpType typeWithoutUnknown = localType.filterUnknown();
            if (!PhpType.replaceTrueFalseWithBoolean(globalType.getTypes()).containsAll(PhpType.replaceTrueFalseWithBoolean(typeWithoutUnknown.getTypes()))) {
                return false;
            }
        }
        return localType.global(project).equals(globalType);
    }

    public static boolean isBooleanGlobal(Project project, PhpType type) {
        return !ContainerUtil.exists(type.filterUnknown().getTypes(), t -> !PhpType.isBoolean(t)) && type.global(project).isBoolean();
    }

    @Nullable
    public static PhpTypeExclusion fromCode(@NotNull String code) {
        if (code == null) {
            PhpType.$$$reportNull$$$0(21);
        }
        return (PhpTypeExclusion)ContainerUtil.find((Object[])ExcludeCode.values(), v -> v.getCode().equals(code));
    }

    public boolean isBoolean() {
        return !this.isEmpty() && this.filterOut(PhpType::isBoolean).isEmpty();
    }

    private static boolean isBoolean(String s) {
        return _BOOL.equals(s) || _TRUE.equals(s) || _FALSE.equals(s);
    }

    public static boolean isArray(@Nullable PhpType type) {
        if (type == null) {
            return false;
        }
        if (type.isEmpty()) {
            return false;
        }
        return type.getTypes().stream().allMatch(t -> PhpType.isArray(t) || PhpType.isPluralType(t));
    }

    public static boolean hasArray(@Nullable PhpType type) {
        if (type == null) {
            return false;
        }
        return type.getTypes().stream().anyMatch(t -> PhpType.isArray(t) || PhpType.isPluralType(t));
    }

    public static boolean hasTypedArray(@Nullable PhpType type) {
        if (type == null) {
            return false;
        }
        return type.getTypes().stream().anyMatch(t -> PhpType.isPluralType(t));
    }

    @NotNull
    public static PhpTypeBuilder builder() {
        return new PhpTypeBuilder();
    }

    @NotNull
    public PhpType add(@Nullable @NlsSafe String aClass) {
        if (aClass == null || ((String)aClass).length() <= 0) {
            PhpType phpType = this;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(22);
            }
            return phpType;
        }
        if (((String)aClass).length() > 1 && ((String)aClass).charAt(0) == '#') {
            this.isComplete = false;
        }
        String trimmed = aClass;
        while (StringUtil.endsWith((CharSequence)trimmed, (CharSequence)"[]")) {
            trimmed = StringUtil.trimEnd((String)trimmed, (String)"[]");
        }
        if ((PhpType.isPrimitiveType(trimmed) || PhpType.isResourceOrNumberType(trimmed)) && !((String)aClass).startsWith("\\")) {
            aClass = "\\" + (String)aClass;
        }
        if (((String)aClass).equalsIgnoreCase(_INTEGER)) {
            aClass = _INT;
        } else if (((String)aClass).equals(_STRING)) {
            aClass = _STRING;
        } else if (((String)aClass).equalsIgnoreCase(_ARRAY)) {
            aClass = _ARRAY;
        } else if (((String)aClass).equalsIgnoreCase(_BOOL)) {
            aClass = _BOOL;
        } else if (((String)aClass).equalsIgnoreCase(_MIXED)) {
            aClass = _MIXED;
        } else if (((String)aClass).equalsIgnoreCase(_BOOLEAN)) {
            aClass = _BOOL;
        } else if (((String)aClass).equalsIgnoreCase(_CALLBACK)) {
            aClass = _CALLABLE;
        } else if (((String)aClass).equalsIgnoreCase(_ITERABLE)) {
            aClass = _ITERABLE;
        } else if (((String)aClass).equalsIgnoreCase(_DOUBLE)) {
            aClass = _FLOAT;
        }
        if (this.types == null) {
            this.types = PhpType.createEmptyTypesSet();
        }
        if (this.types.size() > 50 && this.getTypes().size() > 50) {
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.trace("too much type variants: " + String.valueOf(this.getTypes()));
            }
        } else {
            if (!this.myTypeHasParametrizedParts && PhpType.hasParameterizedPart((String)aClass)) {
                this.myTypeHasParametrizedParts = true;
            }
            this.types.add((String)aClass);
        }
        this.dirty = true;
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(23);
        }
        return phpType;
    }

    @NotNull
    public PhpType add(@Nullable PsiElement other) {
        if (other instanceof PhpTypedElement) {
            PhpType type = ((PhpTypedElement)other).getType();
            this.add(type);
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(24);
        }
        return phpType;
    }

    @NotNull
    public PhpType add(PhpType type) {
        if (type == null || type.isEmpty()) {
            PhpType phpType = this;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(25);
            }
            return phpType;
        }
        Set<@NlsSafe String> parts = type.getTypesWithParametrisedParts();
        if (!this.myTypeHasParametrizedParts && ContainerUtil.exists(parts, PhpType::hasParameterizedPart)) {
            this.myTypeHasParametrizedParts = true;
        }
        try {
            this.isComplete &= type.isComplete;
            if (this.types == null) {
                this.types = PhpType.createTypesSet(parts);
            } else {
                this.types.addAll(parts);
                if (this.types.size() > 50 && this.getTypes().size() > 50 && ApplicationManager.getApplication().isInternal()) {
                    LOG.trace("too much type variants: " + String.valueOf(this.getTypesWithParametrisedParts()));
                }
            }
            this.dirty = true;
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("NSEE @" + String.valueOf(parts), e);
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    public int size() {
        return this.getTypes().size();
    }

    public boolean isAmbiguous() {
        return this.isEmpty() || this.hasUnknown() || PhpType.intersects(this, MIXED);
    }

    public @NotNull Set<@NlsSafe String> getTypes() {
        return this.sanitizeTypes();
    }

    private @NotNull Set<@NlsSafe String> sanitizeTypes() {
        if (this.myTypeHasParametrizedParts) {
            return PhpType.sanitizeTypes(this.types);
        }
        return PhpType.removeFalseAndTrueIfNeeded(this.types);
    }

    public @NotNull Set<@NlsSafe String> getTypesWithParametrisedParts() {
        return PhpType.removeFalseAndTrueIfNeeded(this.types);
    }

    @ApiStatus.Internal
    public @NotNull Stream<@NlsSafe String> types() {
        Stream<String> stream = this.sanitizeTypes().stream();
        if (stream == null) {
            PhpType.$$$reportNull$$$0(27);
        }
        return stream;
    }

    public @NotNull Set<Collection<@NlsSafe String>> getTypesIntersections() {
        Set<Collection<String>> set = this.getTypesWithParametrisedParts().stream().map((? super T t) -> new HashSet(StringUtil.split((String)t, (String)INTERSECTION_TYPE_DELIMITER))).collect(Collectors.toSet());
        if (set == null) {
            PhpType.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static @NotNull Set<@NlsSafe String> sanitizeTypes(Set<@NlsSafe String> types) {
        if (types == null || types.isEmpty()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpType.$$$reportNull$$$0(29);
            }
            return set;
        }
        boolean sorted = types instanceof SortedSet;
        types = types.stream().map(PhpType::convertTypedArrayToPluralOrSanitize).map(PhpType::convertClassStringToString).collect(Collectors.toCollection(() -> sorted ? PhpType.createSortedSet() : PhpType.createEmptyTypesSet()));
        return PhpType.removeFalseAndTrueIfNeeded(types);
    }

    public static boolean hasParameterizedPart(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(30);
        }
        if (PhpType.isPluralType(type)) {
            return PhpType.hasParameterizedPart(PhpType.unpluralize(type));
        }
        int startIndex = type.indexOf(60);
        return startIndex >= 0 && StringUtil.endsWithChar((CharSequence)type, (char)'>');
    }

    @NotNull
    public static String removeParametrisedType(String t) {
        int l = t.indexOf(60);
        int r = t.lastIndexOf(62);
        Object object = l >= 0 && r >= 0 ? t.substring(0, l) + t.substring(r + 1) : t;
        if (object == null) {
            PhpType.$$$reportNull$$$0(31);
        }
        return object;
    }

    @NotNull
    private static Set<String> removeFalseAndTrueIfNeeded(Set<@NlsSafe String> types) {
        if (types != null) {
            if ((types.contains(_FALSE) || types.contains(_TRUE)) && types.contains(_BOOL) || types.contains(_FALSE) && types.contains(_TRUE)) {
                return PhpType.replaceTrueFalseWithBoolean(types);
            }
            Set<String> set = types;
            if (set == null) {
                PhpType.$$$reportNull$$$0(32);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            PhpType.$$$reportNull$$$0(33);
        }
        return set;
    }

    @NotNull
    private static Set<String> replaceTrueFalseWithBoolean(Set<@NlsSafe String> types) {
        Set<String> typesCopy = PhpType.createTypesSet(types);
        typesCopy.remove(_FALSE);
        typesCopy.remove(_TRUE);
        typesCopy.add(_BOOL);
        Set<String> set = typesCopy;
        if (set == null) {
            PhpType.$$$reportNull$$$0(34);
        }
        return set;
    }

    public @NotNull Set<@NlsSafe String> getTypesSorted() {
        if (this.types == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpType.$$$reportNull$$$0(35);
            }
            return set;
        }
        this.sortIfNeeded();
        assert (this.types != null);
        return this.sanitizeTypes();
    }

    private @NotNull Set<@NlsSafe String> getTypesWithParametrisedPartsSorted() {
        if (this.types == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpType.$$$reportNull$$$0(36);
            }
            return set;
        }
        this.sortIfNeeded();
        assert (this.types != null);
        return PhpType.removeFalseAndTrueIfNeeded(this.types);
    }

    public String toString() {
        if (this.types == null) {
            return "";
        }
        if (!this.dirty && this.myString != null) {
            return this.myString;
        }
        String typesString = this.sortedResolvedTypes().collect(Collectors.joining("|"));
        this.myString = this.isComplete ? typesString : typesString + "|?";
        return this.myString;
    }

    public static String toString(@NlsSafe String type) {
        String unpluralized = StringUtil.trimEnd((String)(type = PhpType.convertTypedArrayToPluralOrSanitize(type)), (String)"[]");
        if ((PhpType.isPrimitiveType(unpluralized) || PhpType.isResourceOrNumberType(unpluralized)) && type.startsWith("\\")) {
            return type.substring(1);
        }
        return type;
    }

    @NotNull
    private static String convertTypedArrayToPluralOrSanitize(String type) {
        List<String> parts;
        String s = PhpType.removeParametrisedType(type);
        if ("array".equals(StringUtil.trimStart((String)s, (String)"\\")) && !(parts = PhpType.getParametrizedParts(type)).isEmpty()) {
            String elementType = PhpType.removeParametrisedType((String)ContainerUtil.getLastItem(parts));
            if (StringUtil.trimStart((String)elementType, (String)"\\").equals("mixed")) {
                return _ARRAY;
            }
            String string = elementType + "[]";
            if (string == null) {
                PhpType.$$$reportNull$$$0(37);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            PhpType.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static String convertClassStringToString(String type) {
        String s = PhpType.removeParametrisedType(type);
        if (_CLASS_STRING.equals(s)) {
            return _STRING;
        }
        String string = s;
        if (string == null) {
            PhpType.$$$reportNull$$$0(39);
        }
        return string;
    }

    private void sortIfNeeded() {
        if (this.types != null && !(this.types instanceof SortedSet)) {
            TreeSet<String> sorted = PhpType.createSortedSet();
            sorted.addAll(this.getTypesWithParametrisedParts());
            this.types = sorted;
        }
    }

    @NotNull
    private static TreeSet<String> createSortedSet() {
        Comparator<String> comparator = Comparator.comparing(PhpType::removeParametrisedType, String.CASE_INSENSITIVE_ORDER).thenComparing(String.CASE_INSENSITIVE_ORDER);
        return new TreeSet<String>(comparator);
    }

    @NlsSafe
    public String toStringResolved() {
        if (!this.dirty && this.myStringResolved != null) {
            return this.myStringResolved;
        }
        this.myStringResolved = this.toStringRelativized(null);
        return this.myStringResolved;
    }

    @NlsSafe
    public String toStringRelativized(@Nullable @NlsSafe String currentNamespaceName) {
        if (this.types == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String type : this.getSortedTypesStrings(currentNamespaceName)) {
            builder.append(type).append('|');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        if (!this.isComplete) {
            builder.append("|?");
        }
        return builder.toString();
    }

    public @NotNull Collection<@NlsSafe String> getSortedTypesStrings(@Nullable @NlsSafe String currentNamespaceName) {
        Collection collection = this.sortedResolvedTypes().map((? super T t) -> PhpType.applyIntersectionTypesAware(t, t1 -> PhpType.trimNamespace(currentNamespaceName, t1))).collect(Collectors.toList());
        if (collection == null) {
            PhpType.$$$reportNull$$$0(40);
        }
        return collection;
    }

    private static String trimNamespace(@Nullable @NlsSafe String currentNamespaceName, @NlsSafe String t) {
        return currentNamespaceName != null && t.startsWith(currentNamespaceName) ? t.substring(currentNamespaceName.length()) : t;
    }

    private @NotNull Stream<@NlsSafe String> sortedResolvedTypes() {
        Stream<String> stream = this.getTypesWithParametrisedPartsSorted().stream().filter((? super T t) -> !StringUtil.startsWithChar((CharSequence)t, (char)'?')).map(PhpType::toString).distinct();
        if (stream == null) {
            PhpType.$$$reportNull$$$0(41);
        }
        return stream;
    }

    public boolean isConvertibleFromGlobal(Project project, @NotNull PhpType type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(42);
        }
        if (this.isConvertibleLocal(project, type)) {
            return true;
        }
        PhpType globalType = this.global(project);
        return globalType.isAmbiguous() || globalType.isConvertibleFrom(type.global(project), PhpIndex.getInstance(project));
    }

    public boolean isConvertibleLocal(Project project, @NotNull PhpType type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(43);
        }
        if (this.hasUnknown() || this.hasUnresolved() || type.hasUnknown() || type.hasUnresolved()) {
            PhpType t1 = this.filterUnknown();
            PhpType t2 = type.filterUnknown();
            if (!t1.isEmpty() && !t2.isEmpty() && t1.isConvertibleFrom(t2, PhpIndex.getInstance(project))) {
                return true;
            }
        }
        return false;
    }

    @ApiStatus.Internal
    public boolean isConvertibleFrom(Project project, @NotNull PhpType otherType) {
        if (otherType == null) {
            PhpType.$$$reportNull$$$0(44);
        }
        return this.isConvertibleFrom(otherType, PhpIndex.getInstance(project));
    }

    public boolean isConvertibleFrom(@NotNull PhpType otherType, @NotNull PhpIndex index) {
        Set<String> myTypes;
        if (otherType == null) {
            PhpType.$$$reportNull$$$0(45);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(46);
        }
        if (this.isAmbiguous() || otherType.isAmbiguous()) {
            return true;
        }
        if (this.equals(NULL)) {
            return true;
        }
        Set<String> otherTypes = PhpType.sanitizeTypes(otherType.types);
        if (ContainerUtil.intersects(otherTypes, myTypes = this.sanitizeTypes())) {
            return true;
        }
        if (otherTypes.contains(_ITERABLE) && myTypes.contains(_ARRAY) && myTypes.contains(_TRAVERSABLE)) {
            return true;
        }
        for (String other : otherTypes) {
            for (String my : myTypes) {
                if (!PhpType.isConvertibleFrom(my, other, index)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static Boolean isConvertibleIntersectionAware(String mySuper, String otherChild, BiFunction<String, String, Boolean> convertibilityFunction) {
        if (mySuper.contains(INTERSECTION_TYPE_DELIMITER)) {
            return ContainerUtil.all((Collection)StringUtil.split((String)mySuper, (String)INTERSECTION_TYPE_DELIMITER), intersectedSuper -> (Boolean)convertibilityFunction.apply((String)intersectedSuper, otherChild));
        }
        if (otherChild.contains(INTERSECTION_TYPE_DELIMITER)) {
            return ContainerUtil.exists((Iterable)StringUtil.split((String)otherChild, (String)INTERSECTION_TYPE_DELIMITER), intersectedChild -> (Boolean)convertibilityFunction.apply(mySuper, (String)intersectedChild));
        }
        return null;
    }

    private static boolean isConvertibleFrom(String mySuper, String otherChild, @NotNull PhpIndex index) {
        boolean elementTypesConvertible;
        BiFunction<String, String, Boolean> convertibilityFunction;
        Boolean convertibleIntersectionAware;
        if (index == null) {
            PhpType.$$$reportNull$$$0(47);
        }
        if ((convertibleIntersectionAware = PhpType.isConvertibleIntersectionAware(mySuper, otherChild, convertibilityFunction = (superType, childType) -> PhpType.isConvertibleFrom(superType, childType, index))) != null) {
            return convertibleIntersectionAware;
        }
        if (PhpType.isPluralType(mySuper) && PhpType.isPluralType(otherChild) && (elementTypesConvertible = new PhpType().add(mySuper).unpluralize().isConvertibleFrom(new PhpType().add(otherChild).unpluralize(), index))) {
            return true;
        }
        if (mySuper.equalsIgnoreCase(otherChild) || otherChild.equalsIgnoreCase(_NEVER) || PhpType.isPluralType(mySuper) && otherChild.equalsIgnoreCase(_ARRAY) || PhpType.isPluralType(otherChild) && (mySuper.equalsIgnoreCase(_ARRAY) || mySuper.equalsIgnoreCase(_ITERABLE)) || (mySuper.equalsIgnoreCase(_STRING) || mySuper.equalsIgnoreCase(_STRINGABLE) && !PhpType.isNotExtendablePrimitiveType(otherChild)) && !otherChild.equalsIgnoreCase(_ARRAY) && !PhpType.isPluralType(otherChild) && !PhpType.nonPrimitiveWithoutToString(otherChild, index) || otherChild.equalsIgnoreCase(_STRING) && mySuper.equalsIgnoreCase(_CALLABLE) || otherChild.equalsIgnoreCase(_ARRAY) && mySuper.equalsIgnoreCase(_CALLABLE) || PhpType.isPluralType(otherChild) && mySuper.equalsIgnoreCase(_CALLABLE) || otherChild.equalsIgnoreCase(_STRING) && mySuper.equalsIgnoreCase(_INT) || otherChild.equalsIgnoreCase(_STRING) && mySuper.equalsIgnoreCase(_FLOAT) || otherChild.equalsIgnoreCase(_STRING) && mySuper.equalsIgnoreCase(_BOOL) || otherChild.equalsIgnoreCase(_STRING) && mySuper.equalsIgnoreCase(_FALSE) || mySuper.equalsIgnoreCase(_ITERABLE) && otherChild.equalsIgnoreCase(_ARRAY) || mySuper.equalsIgnoreCase(_ITERABLE) && PhpType.isPluralType(otherChild) || PhpType.isBidi(mySuper, otherChild, _TRUE, _BOOL) || PhpType.isBidi(mySuper, otherChild, _FALSE, _BOOL) || PhpType.isBidi(mySuper, otherChild, _INT, _FLOAT) || PhpType.isBidi(mySuper, otherChild, _BOOL, _INT) || PhpType.isBidi(mySuper, otherChild, _FALSE, _INT) || PhpType.isBidi(mySuper, otherChild, _TRUE, _INT) || PhpType.isBidi(mySuper, otherChild, _BOOL, _FLOAT) || PhpType.isBidi(mySuper, otherChild, _FALSE, _FLOAT) || PhpType.isBidi(mySuper, otherChild, _TRUE, _FLOAT) || PhpType.isBidi(mySuper, otherChild, _NUMBER, _FLOAT) || PhpType.isBidi(mySuper, otherChild, _NUMBER, _INT) || PhpType.isBidi(mySuper, otherChild, _OBJECT, "\\stdClass") || mySuper.equalsIgnoreCase(_STRING) && otherChild.equalsIgnoreCase(_CLASS_STRING) || mySuper.equalsIgnoreCase(_CLASS_STRING) && otherChild.equalsIgnoreCase(_STRING)) {
            return true;
        }
        if (!mySuper.equalsIgnoreCase(_CALLABLE) && !otherChild.equalsIgnoreCase(_CALLABLE) && PhpType.isPrimitiveType(mySuper) && PhpType.isPrimitiveType(otherChild)) {
            return false;
        }
        if (PhpType.findSuper(mySuper, otherChild, index) || PhpType.isSuperWithOnlyPolymorphicTarget(mySuper, otherChild, index)) {
            return true;
        }
        if (!PhpType.isPluralType(otherChild) && !PhpType.isPrimitiveType(otherChild) && _OBJECT.equalsIgnoreCase(mySuper)) {
            return true;
        }
        return mySuper.equalsIgnoreCase(_CALLABLE) && PhpType.checkInvoke(otherChild, index) || otherChild.equalsIgnoreCase(_CALLABLE) && PhpType.checkInvoke(mySuper, index);
    }

    private static boolean isSuperWithOnlyPolymorphicTarget(String my, String other, @NotNull PhpIndex index) {
        Collection<PhpClass> classes;
        if (index == null) {
            PhpType.$$$reportNull$$$0(48);
        }
        if (!(classes = index.getAnyByFQN(other)).isEmpty() && ContainerUtil.and(classes, PhpClass::isAbstract)) {
            HashSet subClasses = new HashSet();
            index.processAllSubclasses(other, new HashSet<PhpClass>(), (Processor<? super PhpClass>)((Processor)c -> {
                if (!c.isAbstract()) {
                    subClasses.add(c);
                }
                return subClasses.size() <= 1;
            }));
            PhpClass onlySubClass = (PhpClass)ContainerUtil.getOnlyItem(subClasses);
            return onlySubClass != null && PhpType.findSuper(my, onlySubClass.getFQN(), index);
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean nonPrimitiveWithoutToString(String fqn, @NotNull PhpIndex index) {
        if (index == null) {
            PhpType.$$$reportNull$$$0(49);
        }
        if (PhpType.isPluralType(fqn) || PhpType.isNotExtendablePrimitiveType(fqn)) {
            return false;
        }
        Collection<PhpClass> classes = index.getAnyByFQN(fqn);
        return !classes.isEmpty() && !PhpType.hasToString(classes) && !PhpType.hasToStringInSubclasses(fqn, index, new HashSet<PhpClass>(classes));
    }

    private static boolean hasToStringInSubclasses(String fqn, PhpIndex phpIndex, HashSet<PhpClass> alreadyProcessedSubClasses) {
        Ref hasToStringInSubclasses = new Ref((Object)false);
        phpIndex.processAllSubclasses(fqn, (Processor<? super PhpClass>)((Processor)phpClass -> {
            if (phpClass.findMethodByName("__toString", alreadyProcessedSubClasses) != null) {
                hasToStringInSubclasses.set((Object)true);
                return false;
            }
            alreadyProcessedSubClasses.add((PhpClass)phpClass);
            return true;
        }));
        return (Boolean)hasToStringInSubclasses.get();
    }

    private static boolean hasToString(Collection<PhpClass> classes) {
        return ContainerUtil.exists(classes, c -> c.findMethodByName("__toString") != null);
    }

    private static boolean isBidi(@NlsSafe String my, @NlsSafe String other, @NlsSafe String type1, @NlsSafe String type2) {
        return my.equalsIgnoreCase(type1) && other.equalsIgnoreCase(type2) || other.equalsIgnoreCase(type1) && my.equalsIgnoreCase(type2);
    }

    @NotNull
    public PhpType filterUnknown() {
        PhpType phpType = this.filterOut(s -> s.startsWith("#") || s.startsWith("?"));
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(50);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterPrimitives() {
        PhpType phpType = this.filterOut(PhpType::isPrimitiveType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(51);
        }
        return phpType;
    }

    public boolean hasUnknown() {
        for (String type : this.getTypes()) {
            if (!StringUtil.startsWith((CharSequence)type, (CharSequence)"?")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInvoke(@NotNull @NlsSafe String some, @NotNull PhpIndex index) {
        if (some == null) {
            PhpType.$$$reportNull$$$0(52);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(53);
        }
        Collection<PhpClass> candidates = index.getAnyByFQN(some);
        for (PhpClass candidate : candidates) {
            if (candidate.findMethodByName("__invoke") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean findSuper(@NotNull @NlsSafe String mySuper, @Nullable @NlsSafe String otherChild, @NotNull PhpIndex index) {
        if (mySuper == null) {
            PhpType.$$$reportNull$$$0(54);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(55);
        }
        return PhpType.findSuper(mySuper, otherChild, index, new HashSet<PhpClass>());
    }

    @ApiStatus.Internal
    public static boolean findSuper(@NotNull @NlsSafe String mySuper, @Nullable @NlsSafe String otherChild, @NotNull PhpIndex index, Collection<PhpClass> visited) {
        if (mySuper == null) {
            PhpType.$$$reportNull$$$0(56);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(57);
        }
        if (otherChild == null) {
            return false;
        }
        BiFunction<String, String, Boolean> convertibilityFunction = (superType, childType) -> PhpType.findSuper(superType, childType, index);
        Boolean convertibleIntersectionAware = PhpType.isConvertibleIntersectionAware((String)mySuper, (String)otherChild, convertibilityFunction);
        if (convertibleIntersectionAware != null) {
            return convertibleIntersectionAware;
        }
        if (((String)mySuper).endsWith("[]") != ((String)otherChild).endsWith("[]")) {
            return false;
        }
        mySuper = StringUtil.trimEnd((String)mySuper, (String)"[]");
        otherChild = StringUtil.trimEnd((String)otherChild, (String)"[]");
        if (!((String)mySuper).startsWith("\\")) {
            mySuper = "\\" + (String)mySuper;
        }
        if (!((String)otherChild).startsWith("\\")) {
            otherChild = "\\" + (String)otherChild;
        }
        if (((String)mySuper).equalsIgnoreCase((String)otherChild)) {
            return true;
        }
        Collection<PhpClass> mes = index.getAnyByFQN((String)mySuper);
        if (mes.isEmpty()) {
            return false;
        }
        Collection<PhpClass> childClasses = index.getAnyByFQN((String)otherChild);
        if (ContainerUtil.all(mes, PhpClass::isFinal)) {
            return ContainerUtil.intersects(mes, childClasses);
        }
        Ref result = new Ref((Object)false);
        return ContainerUtil.exists(childClasses, phpClass -> {
            PhpClassHierarchyUtils.processSuperWithoutMixins(phpClass, true, true, (Processor<? super PhpClass>)((Processor)aSuper -> {
                for (PhpClass me : mes) {
                    if (!PhpClassHierarchyUtils.classesEqual(me, aSuper)) continue;
                    result.set((Object)true);
                    break;
                }
                return (Boolean)result.get() == false;
            }), visited);
            return (Boolean)result.get();
        });
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    @Deprecated(forRemoval=true)
    public PhpType globalLocationAware(@NotNull PsiElement context) {
        if (context == null) {
            PhpType.$$$reportNull$$$0(58);
        }
        return this.global(context.getProject());
    }

    public PhpType global(@NotNull Project p) {
        if (p == null) {
            PhpType.$$$reportNull$$$0(59);
        }
        try {
            return PhpIndex.getInstance(p).completeType(p, this, null);
        }
        catch (StackOverflowError e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            LOG.warn("SOE in PhpType.global @ " + String.valueOf(this));
            return EMPTY;
        }
    }

    public boolean isEmpty() {
        return this.types == null || this.types.isEmpty();
    }

    @NotNull
    public PhpType elementType() {
        PhpType phpType = this.elementType(PhpTypeSignatureKey.ARRAY_ELEMENT);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(60);
        }
        return phpType;
    }

    @NotNull
    private static String transformInnerElementType(@NotNull String type, UnaryOperator<@NotNull String> transform) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(61);
        }
        SmartList exclusionModifiers = new SmartList();
        while (type.startsWith("#-")) {
            int idx = type.lastIndexOf(EXCLUDED_INCOMPLETE_TYPE_SEPARATOR);
            if (idx <= 0 || type.length() <= idx + 1) continue;
            exclusionModifiers.add(type.substring(idx));
            type = type.substring(2, idx);
        }
        String mappedType = (String)transform.apply(type);
        if (mappedType.isEmpty()) {
            return "";
        }
        Collections.reverse(exclusionModifiers);
        String string = "#-".repeat(exclusionModifiers.size()) + mappedType + String.join((CharSequence)"", (Iterable<? extends CharSequence>)exclusionModifiers);
        if (string == null) {
            PhpType.$$$reportNull$$$0(62);
        }
        return string;
    }

    @ApiStatus.Internal
    @NotNull
    public PhpType elementType(PhpTypeKey typeKey) {
        PhpType elementType = new PhpType();
        PhpType keysType = new PhpType();
        for (String type : this.getTypesWithParametrisedParts()) {
            if (PhpKeyTypeProvider.isArrayKeySignature(type)) {
                keysType.add(PhpType.transformInnerElementType(type, t -> {
                    String unsignedKeyType = t.substring(2);
                    return PhpKeyTypeProvider.isArrayKeySignature(unsignedKeyType) ? unsignedKeyType : "";
                }));
                continue;
            }
            String subtype = PhpType.transformInnerElementType(type, t -> PhpType.transformElementValueType(typeKey, t));
            elementType.add(subtype);
        }
        if (elementType.isEmpty()) {
            elementType.add(_MIXED);
        }
        PhpType phpType = elementType.add(keysType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(63);
        }
        return phpType;
    }

    @NotNull
    private static String transformElementValueType(@NotNull PhpTypeKey typeKey, @NotNull String type) {
        List<String> parts;
        if (typeKey == null) {
            PhpType.$$$reportNull$$$0(64);
        }
        if (type == null) {
            PhpType.$$$reportNull$$$0(65);
        }
        if (PhpType.removeParametrisedType(type).equals(_ARRAY) && (parts = PhpType.getParametrizedParts(type)).size() == 2) {
            String string = (String)ContainerUtil.getLastItem(parts);
            if (string == null) {
                PhpType.$$$reportNull$$$0(66);
            }
            return string;
        }
        if (PhpType.isPrimitiveClassAccess(type) || type.equalsIgnoreCase(_ARRAY)) {
            return _MIXED;
        }
        if (PhpType.isPluralType(type) && !type.contains("#\u03c0")) {
            String string = type.substring(0, type.length() - 2);
            if (string == null) {
                PhpType.$$$reportNull$$$0(67);
            }
            return string;
        }
        if (PhpType.isPrimitiveType(type)) {
            return type.equals(_STRING) ? _STRING : _MIXED;
        }
        String string = typeKey.sign(PhpTypeSignatureKey.CLASS.signIfUnsigned(type));
        if (string == null) {
            PhpType.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NotNull
    public PhpType pluralise() {
        PhpType phpType = this.pluralise(1);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(69);
        }
        return phpType;
    }

    public PhpType pluralise(int c) {
        if (c == 0) {
            return this;
        }
        PhpType elementType = new PhpType();
        for (String type : this.getTypesWithParametrisedParts()) {
            String pluralise = PhpType.pluraliseMixedAware(type, c);
            elementType.add(pluralise);
        }
        if (elementType.isEmpty()) {
            elementType.add(ARRAY);
        }
        return elementType;
    }

    @NotNull
    public static String pluraliseMixedAware(String type, int c) {
        String string = _MIXED.equals(type) ? PhpType.pluralise(_ARRAY, c - 1) : PhpType.pluralise(type, c);
        if (string == null) {
            PhpType.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NotNull
    public PhpType unpluralize() {
        if (this.getTypes().isEmpty()) {
            PhpType phpType = this.getEmpty();
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(71);
            }
            return phpType;
        }
        PhpType unpluralized = new PhpType();
        for (String type : this.getTypesWithParametrisedParts()) {
            unpluralized.add(PhpType.unpluralizeType(type));
        }
        PhpType phpType = unpluralized;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(72);
        }
        return phpType;
    }

    @NotNull
    private static String unpluralizeType(String type) {
        String s = PhpType.removeParametrisedType(type);
        List<String> parts = PhpType.getParametrizedParts(type);
        if (_ARRAY.equals(s) && !parts.isEmpty()) {
            String string = (String)ContainerUtil.getLastItem(parts);
            if (string == null) {
                PhpType.$$$reportNull$$$0(73);
            }
            return string;
        }
        String string = _ARRAY.equalsIgnoreCase(type) ? _MIXED : StringUtil.trimEnd((String)type, (String)"[]");
        if (string == null) {
            PhpType.$$$reportNull$$$0(74);
        }
        return string;
    }

    public static boolean isPrimitiveType(@Nullable String type) {
        if (type == null) {
            return true;
        }
        if (((String)type).length() < 3 || ((String)type).length() > 11) {
            return false;
        }
        if (((String)type).charAt(0) == '#') {
            return false;
        }
        if (!((String)type).startsWith("\\")) {
            type = "\\" + (String)type;
        }
        return PhpType.isNotExtendablePrimitiveType((String)type) || PhpType.isArray((String)type) || _OBJECT.equalsIgnoreCase((String)type) || _CALLABLE.equalsIgnoreCase((String)type) || _ITERABLE.equalsIgnoreCase((String)type);
    }

    public boolean isNotExtendablePrimitiveType() {
        if (this.isEmpty()) {
            return false;
        }
        return ContainerUtil.and(this.getTypes(), PhpType::isNotExtendablePrimitiveType);
    }

    public static boolean isNotExtendablePrimitiveType(@Nullable @NlsSafe String type) {
        if (type == null) {
            return true;
        }
        if (((String)type).length() < 3 || ((String)type).length() > 12) {
            return false;
        }
        if (((String)type).charAt(0) == '#') {
            return false;
        }
        if (!((String)type).startsWith("\\")) {
            type = "\\" + (String)type;
        }
        return _MIXED.equalsIgnoreCase((String)type) || _STRING.equalsIgnoreCase((String)type) || _CLASS_STRING.equalsIgnoreCase((String)type) || _INT.equalsIgnoreCase((String)type) || _INTEGER.equalsIgnoreCase((String)type) || _BOOL.equalsIgnoreCase((String)type) || _BOOLEAN.equalsIgnoreCase((String)type) || _TRUE.equalsIgnoreCase((String)type) || _FALSE.equalsIgnoreCase((String)type) || _FLOAT.equalsIgnoreCase((String)type) || _NULL.equalsIgnoreCase((String)type) || _VOID.equalsIgnoreCase((String)type) || _NEVER.equalsIgnoreCase((String)type) || _DOUBLE.equalsIgnoreCase((String)type);
    }

    public static boolean isArray(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(75);
        }
        return _ARRAY.equals(PhpType.removeParametrisedType(type));
    }

    public static boolean isString(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(76);
        }
        return _STRING.equals(type);
    }

    public static boolean isObject(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(77);
        }
        return _OBJECT.equals(type);
    }

    public static boolean isMixedType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(78);
        }
        return _MIXED.equals(type);
    }

    public static boolean isCallableType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(79);
        }
        return _CALLABLE.equals(type);
    }

    public static boolean isPluralType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(80);
        }
        return type.endsWith("[]");
    }

    public static int getPluralDimension(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(81);
        }
        int res = 0;
        while (StringUtil.endsWith((CharSequence)type, (int)0, (int)(type.length() - res * 2), (CharSequence)"[]")) {
            ++res;
        }
        return res;
    }

    public static boolean isPluralPrimitiveType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(82);
        }
        return type.endsWith("[]") && PhpType.isPrimitiveType(type.substring(0, type.length() - 2));
    }

    public static boolean isAnonymousClass(@Nullable @NlsSafe String type) {
        return type != null && StringUtil.startsWith((CharSequence)type, (CharSequence)"__anonymous@");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhpType)) {
            return false;
        }
        PhpType phpType = (PhpType)o;
        return this.isComplete == phpType.isComplete && Objects.equals(this.getTypes(), phpType.getTypes());
    }

    public int hashCode() {
        int result = PhpType.computeHashCode(this.getTypes());
        result = 31 * result + (this.isComplete ? 1 : 0);
        return result;
    }

    private static int computeHashCode(@NotNull Set<@NlsSafe String> types) {
        if (types == null) {
            PhpType.$$$reportNull$$$0(83);
        }
        int result = 0;
        for (String type : types) {
            result += HashingStrategy.caseInsensitiveCharSequence().hashCode((Object)type);
        }
        return result;
    }

    public static boolean isUnresolved(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(84);
        }
        return type.indexOf(35) != -1;
    }

    public static boolean isNull(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(85);
        }
        return _NULL.equalsIgnoreCase(type);
    }

    @Contract(pure=true)
    public boolean isNullable() {
        return this.getTypes().stream().anyMatch(PhpType::isNull);
    }

    private static boolean isScalar(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(86);
        }
        return _BOOL.equals(type) || _BOOLEAN.equals(type) || _FLOAT.equals(type) || _STRING.equals(type) || _INT.equals(type) || _INTEGER.equals(type);
    }

    public static boolean isScalar(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(87);
        }
        if (project == null) {
            PhpType.$$$reportNull$$$0(88);
        }
        PhpType completedType = type.global(project);
        for (String curType : completedType.getTypes()) {
            if (PhpType.isScalar(curType)) continue;
            return false;
        }
        return true;
    }

    public boolean hasUnresolved() {
        for (String type : this.getTypes()) {
            if (!PhpType.isSignedType(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSignedType(@Nullable String type) {
        return StringUtil.startsWithChar((CharSequence)type, (char)'#');
    }

    public static boolean intersectsGlobal(Project project, @NotNull PhpType f, @NotNull PhpType s) {
        if (f == null) {
            PhpType.$$$reportNull$$$0(89);
        }
        if (s == null) {
            PhpType.$$$reportNull$$$0(90);
        }
        return PhpType.intersectsLocal(f, s) || PhpType.intersects(f.global(project), s.global(project));
    }

    private static boolean intersectsLocal(@NotNull PhpType f, @NotNull PhpType s) {
        if (f == null) {
            PhpType.$$$reportNull$$$0(91);
        }
        if (s == null) {
            PhpType.$$$reportNull$$$0(92);
        }
        if (f.hasUnknown() || f.hasUnresolved() || s.hasUnknown() || s.hasUnresolved()) {
            PhpType f1 = f.filterUnknown();
            PhpType s1 = s.filterUnknown();
            if (!f1.isEmpty() && !s1.isEmpty() && PhpType.intersects(f1, s1)) {
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(93);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(94);
        }
        Set<String> phpTypeSet1 = phpType1.getTypes();
        Set<String> phpTypeSet2 = phpType2.getTypes();
        for (String type1 : phpTypeSet1) {
            if (!phpTypeSet2.contains(type1) && (!_FALSE.equals(type1) && !_TRUE.equals(type1) || !phpTypeSet2.contains(_BOOL)) && (!_BOOL.equals(type1) || !phpTypeSet2.contains(_FALSE) && !phpTypeSet2.contains(_TRUE))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubType(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        Set<String> typeSet1;
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(95);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(96);
        }
        if ((typeSet1 = phpType1.getTypes()).isEmpty()) {
            return false;
        }
        Set<String> typeSet2 = phpType2.getTypes();
        if (typeSet2.isEmpty()) {
            return false;
        }
        for (String type1 : typeSet1) {
            if ((_FALSE.equals(type1) || _TRUE.equals(type1)) && typeSet2.contains(_BOOL) || typeSet2.contains(type1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static PhpType and(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(97);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(98);
        }
        Set<String> phpTypeSet1 = phpType1.getTypesWithParametrisedParts();
        Set<String> phpTypeSet2 = phpType2.getTypesWithParametrisedParts();
        PhpType phpType = new PhpType();
        for (String type1 : phpTypeSet1) {
            if (!phpTypeSet2.contains(type1)) continue;
            phpType.add(type1);
        }
        PhpType phpType3 = phpType;
        if (phpType3 == null) {
            PhpType.$$$reportNull$$$0(99);
        }
        return phpType3;
    }

    @NotNull
    public static PhpType or(@Nullable PhpType phpType1, @Nullable PhpType phpType2) {
        if (phpType1 == null || phpType1.isEmpty()) {
            PhpType phpType = (PhpType)ObjectUtils.notNull((Object)phpType2, (Object)EMPTY);
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(100);
            }
            return phpType;
        }
        if (phpType2 == null || phpType2.isEmpty()) {
            PhpType phpType = (PhpType)ObjectUtils.notNull((Object)phpType1, (Object)EMPTY);
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(101);
            }
            return phpType;
        }
        PhpType phpType = new PhpType().add(phpType1).add(phpType2);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(102);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterNull() {
        PhpType phpType = this.filterOutIncompleteTypesAware(ExcludeCode.NOT_NULL);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(103);
        }
        return phpType;
    }

    public PhpType filterScalarPrimitives() {
        return this.filterOutIncompleteTypesAware(ExcludeCode.NOT_PRIMITIVE);
    }

    public PhpType filterFalse() {
        return this.filterOutIncompleteTypesAware(ExcludeCode.NOT_FALSE);
    }

    @ApiStatus.Internal
    public PhpType filterOutIncompleteTypesAware(PhpTypeExclusion excludeCodeForIncompleteType) {
        if (this.isEmpty()) {
            return this instanceof ImmutablePhpType ? this.getEmpty() : new PhpType();
        }
        PhpType phpType = new PhpType();
        for (String type : this.getTypesWithParametrisedParts()) {
            boolean isUnresolved = PhpType.isSignedType(type);
            if (!isUnresolved && excludeCodeForIncompleteType.isNotApplicableType(null, PhpType.removeParametrisedType(type))) continue;
            if (!(excludeCodeForIncompleteType.filterOnlyUnresolved() && !isUnresolved || StringUtil.containsChar((String)type, (char)'|'))) {
                phpType.add(excludeCodeForIncompleteType.filterIncompleteType(type));
                continue;
            }
            phpType.add(type);
        }
        return phpType;
    }

    protected PhpType getEmpty() {
        return new PhpType();
    }

    @NotNull
    public PhpType filterMixed() {
        PhpType phpType = this.filterOutIncompleteTypesAware(ExcludeCode.NOT_MIXED);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(104);
        }
        return phpType;
    }

    @ApiStatus.Internal
    public PhpType filterObject() {
        return this.filterOutIncompleteTypesAware(ExcludeCode.NOT_OBJECT);
    }

    @NotNull
    public PhpType filterPlurals() {
        PhpType phpType = this.filterOut(PhpType::isPluralType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(105);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterOut(@NotNull Predicate<String> typeExcludePredicate) {
        if (typeExcludePredicate == null) {
            PhpType.$$$reportNull$$$0(106);
        }
        PhpType phpType = this.filterOut(typeExcludePredicate, false);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(107);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterOut(@NotNull Predicate<String> typeExcludePredicate, boolean checkParametrisedParts) {
        if (typeExcludePredicate == null) {
            PhpType.$$$reportNull$$$0(108);
        }
        if (this.isEmpty()) {
            PhpType phpType = this.getEmpty();
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(109);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        for (String type : this.getTypesWithParametrisedParts()) {
            if (typeExcludePredicate.test(PhpType.removeParametrisedType(type)) && (!checkParametrisedParts || typeExcludePredicate.test(type))) continue;
            phpType.add(type);
        }
        PhpType phpType2 = phpType;
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(110);
        }
        return phpType2;
    }

    @NotNull
    public PhpType filter(@NotNull PhpType sieve) {
        if (sieve == null) {
            PhpType.$$$reportNull$$$0(111);
        }
        if (this.isEmpty()) {
            PhpType phpType = this.getEmpty();
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(112);
            }
            return phpType;
        }
        Set<String> sieveTypes = sieve.getTypes();
        if (ContainerUtil.isEmpty(sieveTypes)) {
            PhpType phpType = new PhpType().add(this);
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(113);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        if (sieveTypes.size() == 1) {
            String sieveType = (String)ContainerUtil.getFirstItem(sieveTypes);
            assert (sieveType != null);
            this.getTypesWithParametrisedParts().stream().filter((? super T type) -> !sieveType.equals(PhpType.removeParametrisedType(type))).forEach(phpType::add);
        } else {
            this.getTypesWithParametrisedParts().stream().filter((? super T type) -> !sieveTypes.contains(PhpType.removeParametrisedType(type))).forEach(phpType::add);
        }
        PhpType phpType2 = phpType;
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(114);
        }
        return phpType2;
    }

    @NotNull
    private static Set<String> createEmptyTypesSet() {
        Set set = CollectionFactory.createCaseInsensitiveStringSet();
        if (set == null) {
            PhpType.$$$reportNull$$$0(115);
        }
        return set;
    }

    @NotNull
    private static Set<String> createTypesSet(@NotNull Collection<String> types) {
        if (types == null) {
            PhpType.$$$reportNull$$$0(116);
        }
        Set set = CollectionFactory.createCaseInsensitiveStringSet(types);
        if (set == null) {
            PhpType.$$$reportNull$$$0(117);
        }
        return set;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType from(String ... types) {
        if (types == null) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(118);
            }
            return phpType;
        }
        return PhpType.fromStrings(Arrays.asList(types));
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType fromStrings(@NotNull Collection<String> types) {
        if (types == null) {
            PhpType.$$$reportNull$$$0(119);
        }
        if (ContainerUtil.and(types, e -> e == null)) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(120);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        for (String s : types) {
            type.add(s);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(121);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType global(Project project, String ... types) {
        PhpType phpType = PhpType.from(types).global(project);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(122);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType from(PsiElement ... elements) {
        return PhpType.from(Arrays.asList(elements));
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType from(Collection<? extends PsiElement> elements) {
        if (elements == null || ContainerUtil.and(elements, e -> e == null)) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(123);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        for (PsiElement psiElement : elements) {
            type.add(psiElement);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(124);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType global(PsiElement ... elements) {
        if (elements == null) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(125);
            }
            return phpType;
        }
        PsiElement notNullElement = (PsiElement)ContainerUtil.find((Object[])elements, e -> e != null);
        PhpType phpType = notNullElement != null ? PhpType.from(elements).global(notNullElement.getProject()) : EMPTY;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(126);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType from(PhpType ... types) {
        if (types == null || ContainerUtil.and((Object[])types, e -> e == null)) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(127);
            }
            return phpType;
        }
        PhpType type = new PhpType();
        for (PhpType s : types) {
            type.add(s);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(128);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public static PhpType global(Project project, PhpType ... types) {
        PhpType phpType = PhpType.from(types).global(project);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(129);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 10, 11, 14, 15, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 50, 51, 60, 62, 63, 66, 67, 68, 69, 70, 71, 72, 73, 74, 99, 100, 101, 102, 103, 104, 105, 107, 109, 110, 112, 113, 114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 50: 
            case 51: 
            case 60: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 17: 
            case 30: 
            case 42: 
            case 43: 
            case 61: 
            case 65: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 53: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "some";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mySuper";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeKey";
                break;
            }
            case 83: 
            case 116: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 89: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 93: 
            case 95: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType1";
                break;
            }
            case 94: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType2";
                break;
            }
            case 106: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExcludePredicate";
                break;
            }
            case 111: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sieve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParametrisedParts";
                break;
            }
            case 8: 
            case 71: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "unpluralize";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "applyIntersectionTypesAware";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createParametrizedType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametrizedParts";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "types";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesIntersections";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeTypes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "removeParametrisedType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFalseAndTrueIfNeeded";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceTrueFalseWithBoolean";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesSorted";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesWithParametrisedPartsSorted";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTypedArrayToPluralOrSanitize";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "convertClassStringToString";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedTypesStrings";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedResolvedTypes";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnknown";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPrimitives";
                break;
            }
            case 60: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "elementType";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "transformInnerElementType";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "transformElementValueType";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralise";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "pluraliseMixedAware";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "unpluralizeType";
                break;
            }
            case 99: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNull";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMixed";
                break;
            }
            case 105: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPlurals";
                break;
            }
            case 107: 
            case 109: 
            case 110: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOut";
                break;
            }
            case 112: 
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 115: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTypesSet";
                break;
            }
            case 117: {
                objectArray = objectArray2;
                objectArray2[1] = "createTypesSet";
                break;
            }
            case 118: 
            case 123: 
            case 124: 
            case 127: 
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "from";
                break;
            }
            case 120: 
            case 121: {
                objectArray = objectArray2;
                objectArray2[1] = "fromStrings";
                break;
            }
            case 122: 
            case 125: 
            case 126: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "global";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 50: 
            case 51: 
            case 60: 
            case 62: 
            case 63: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 117: 
            case 118: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "pluralise";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyIntersectionTypesAware";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createParametrized";
                break;
            }
            case 13: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createParametrizedType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getParametrizedParts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "fromCode";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "hasParameterizedPart";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFromGlobal";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleLocal";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isSuperWithOnlyPolymorphicTarget";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "nonPrimitiveWithoutToString";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "checkInvoke";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findSuper";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "globalLocationAware";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "global";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "transformInnerElementType";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "transformElementValueType";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "isString";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isMixedType";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "isCallableType";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isPluralType";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getPluralDimension";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isPluralPrimitiveType";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "computeHashCode";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isNull";
                break;
            }
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isScalar";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "intersectsGlobal";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "intersectsLocal";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "isSubType";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 106: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "filterOut";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "createTypesSet";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "fromStrings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 10, 11, 14, 15, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 50, 51, 60, 62, 63, 66, 67, 68, 69, 70, 71, 72, 73, 74, 99, 100, 101, 102, 103, 104, 105, 107, 109, 110, 112, 113, 114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129 -> new IllegalStateException(string);
        };
    }

    private static class ImmutablePhpType
    extends PhpType {
        private ImmutablePhpType() {
        }

        @Override
        @NotNull
        public PhpType add(@Nullable @NlsSafe String aClass) {
            throw ImmutablePhpType.getException();
        }

        @Override
        @NotNull
        public PhpType add(@Nullable PsiElement other) {
            throw ImmutablePhpType.getException();
        }

        @Override
        @NotNull
        public PhpType add(@Nullable PhpType type) {
            throw ImmutablePhpType.getException();
        }

        @Override
        protected PhpType getEmpty() {
            return EMPTY;
        }

        private PhpType addInternal(@Nullable PhpType type) {
            return super.add(type);
        }

        @NotNull
        private static RuntimeException getException() {
            return new UnsupportedOperationException("This PHP type is immutable");
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ExcludeCode implements PhpTypeExclusion
    {
        NOT_NULL("n"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpType.isNull(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$1", "isNotApplicableType"));
            }
        }
        ,
        NOT_PRIMITIVE("p"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !PhpType.isMixedType(type) && (PhpType.isArray(type) || PhpType.isNotExtendablePrimitiveType(type));
            }

            @Override
            public String filterIncompleteType(String type) {
                if (PhpTypeSignatureKey.SELF_CLASS.isSigned(type) || PhpTypeSignatureKey.SELF_CLASS_IN_TRAIT.isSigned(type) || PhpTypeSignatureKey.POLYMORPHIC_CLASS.isSigned(type)) {
                    return type;
                }
                return super.filterIncompleteType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$2", "isNotApplicableType"));
            }
        }
        ,
        NOT_FALSE("f"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PhpType._FALSE.equals(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$3", "isNotApplicableType"));
            }
        }
        ,
        NOT_MIXED("m"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PhpType.isMixedType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$4", "isNotApplicableType"));
            }
        }
        ,
        NOT_OBJECT("o"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    5.$$$reportNull$$$0(0);
                }
                return PhpType.isObject(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$5", "isNotApplicableType"));
            }
        }
        ,
        ONLY_PLURAL("s"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    6.$$$reportNull$$$0(0);
                }
                return !PhpType.isPluralType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$6", "isNotApplicableType"));
            }
        }
        ,
        ONLY_NUMERIC("x"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    7.$$$reportNull$$$0(0);
                }
                return !NUMERIC.getTypes().contains(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$7", "isNotApplicableType"));
            }
        };

        @NotNull
        private final String myCode;

        private ExcludeCode(String code) {
            if (code == null) {
                ExcludeCode.$$$reportNull$$$0(0);
            }
            this.myCode = code;
        }

        @Override
        public abstract boolean isNotApplicableType(@Nullable Project var1, @NotNull @NlsSafe String var2);

        @Override
        @NotNull
        public String getCode() {
            String string = this.myCode;
            if (string == null) {
                ExcludeCode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    public static interface PhpTypeExclusion {
        public boolean isNotApplicableType(@Nullable Project var1, @NotNull String var2);

        @NlsSafe
        public String getCode();

        default public boolean filterOnlyUnresolved() {
            return true;
        }

        default public String filterIncompleteType(String type) {
            int i = 0;
            String suffixToAdd = PhpType.EXCLUDED_INCOMPLETE_TYPE_SEPARATOR + this.getCode();
            while (type.startsWith("#-", i)) {
                if (StringUtil.endsWith((CharSequence)type, (int)0, (int)(type.length() - i), (CharSequence)suffixToAdd)) {
                    return type;
                }
                i += 2;
            }
            return String.format("#-%s%s", type, suffixToAdd);
        }
    }

    public static class PhpTypeBuilder {
        private final PhpType temp = new PhpType();

        @NotNull
        public PhpTypeBuilder add(@Nullable @NlsSafe String aClass) {
            this.temp.add(aClass);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(0);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder add(@Nullable @NlsSafe PsiElement other) {
            this.temp.add(other);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(1);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder add(@Nullable PhpType type) {
            this.temp.add(type);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(2);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder merge(@NotNull PhpTypeBuilder builder) {
            if (builder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(3);
            }
            this.temp.add(builder.temp);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(4);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpType build() {
            ImmutablePhpType type = new ImmutablePhpType();
            Set<@NlsSafe String> types = this.temp.getTypesWithParametrisedParts();
            switch (types.size()) {
                case 0: {
                    type.types = Collections.emptySet();
                    break;
                }
                case 1: {
                    type.types = Collections.unmodifiableSet(PhpType.createTypesSet(types));
                    break;
                }
                default: {
                    type.types = types;
                    type.dirty = this.temp.dirty;
                }
            }
            type.isComplete = this.temp.isComplete;
            type.myTypeHasParametrizedParts = ContainerUtil.exists(types, PhpType::hasParameterizedPart);
            ImmutablePhpType immutablePhpType = type;
            if (immutablePhpType == null) {
                PhpTypeBuilder.$$$reportNull$$$0(5);
            }
            return immutablePhpType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$PhpTypeBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$PhpTypeBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

