/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpCallbackElement;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpEnumCase;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import com.jetbrains.php.lang.psi.stubs.PhpStubBasedPsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface PhpClass
extends PhpNamedElement,
PhpElementWithModifier,
PhpStubBasedPsiElement<PhpClassStub>,
PhpCallbackElement,
PhpAttributesOwner {
    public static final String CLONE = "__clone";
    public static final String TO_STRING = "__toString";
    public static final String CONSTRUCTOR = "__construct";
    public static final String DESTRUCTOR = "__destruct";
    public static final String INVOKE = "__invoke";
    public static final String PARENT = "parent";
    public static final String SELF = "self";
    public static final String STATIC = "static";
    public static final String CLASS = "class";
    public static final PhpClass[] EMPTY_ARRAY = new PhpClass[0];
    public static final Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpClass;
    public static final String ANONYMOUS = "__anonymous@";

    public boolean isAnonymous();

    public boolean isInterface();

    public boolean isEnum();

    @NotNull
    public PhpType getBackedEnumType();

    public boolean isAbstract();

    public boolean isFinal();

    public boolean isReadonly();

    @NotNull
    public ExtendsList getExtendsList();

    @NotNull
    public ImplementsList getImplementsList();

    @Nullable
    public String getSuperName();

    @Nullable
    public String getSuperFQN();

    @Nullable
    public PhpClass getSuperClass();

    public Collection<PhpClass> getSuperClasses();

    public String @NotNull [] getInterfaceNames();

    public PhpClass[] getImplementedInterfaces();

    @ApiStatus.Internal
    @NotNull
    default public List<PhpClass> getDirectImplementedInterfaces() {
        ArrayList<PhpClass> interfaceList = new ArrayList<PhpClass>();
        PhpIndex phpIndex = PhpIndex.getInstance(this.getProject());
        for (String fqn : this.getInterfaceNames()) {
            interfaceList.addAll(phpIndex.getInterfacesByFQN(fqn));
        }
        ArrayList<PhpClass> arrayList = interfaceList;
        if (arrayList == null) {
            PhpClass.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    @ApiStatus.Internal
    public Collection<PhpClass> getImplicitEnumInterfaces();

    public boolean hasTraitUses();

    public String @NotNull [] getTraitNames();

    public PhpClass[] getTraits();

    public String[] getMixinNames();

    public PhpClass[] getMixins();

    @ApiStatus.Internal
    public boolean hasGenericMixins();

    @ApiStatus.Internal
    public PhpClass[] getMixinsIncludingGeneric(String var1);

    public PhpClass[] getSupers();

    public Collection<Field> getFields();

    public Field[] getOwnFields();

    @ApiStatus.Internal
    public Field[] getOwnFields(boolean var1);

    public Collection<Method> getMethods();

    public Method[] getOwnMethods();

    public boolean hasOwnStaticMembers();

    public boolean hasStaticMembers();

    @Nullable
    public Method getConstructor();

    @Nullable
    public Method findMethodByName(@Nullable CharSequence var1);

    @Nullable
    @ApiStatus.Internal
    public Method findMethodByName(@Nullable CharSequence var1, Collection<PhpClass> var2);

    @NotNull
    @ApiStatus.Internal
    public Collection<Method> findMethodsByName(@Nullable CharSequence var1);

    @NotNull
    @ApiStatus.Internal
    public @Unmodifiable Collection<Method> findMethodsByName(@Nullable CharSequence var1, HashSet<PhpClass> var2);

    @Nullable
    public Method findOwnMethodByName(@Nullable CharSequence var1);

    @Nullable
    public Field findFieldByName(@Nullable CharSequence var1, boolean var2);

    @ApiStatus.Internal
    @NotNull
    public Collection<PhpClass> getTypeAwareImplicitEnumInterfaces();

    @Nullable
    public Field findOwnFieldByName(@Nullable CharSequence var1, boolean var2);

    @ApiStatus.Internal
    public PhpOverloadedMethods findOwnMethodsByName(@Nullable CharSequence var1);

    @Override
    @NotNull
    public Icon getIcon();

    public boolean hasMethodTags();

    public boolean hasPropertyTags();

    public boolean hasConstructorFields();

    @Nullable
    public Method getOwnConstructor();

    public boolean isTrait();

    public JBIterable<PhpTraitUseRule> traitUseRules();

    @NotNull
    public String getPresentableFQN();

    public Collection<PhpEnumCase> getEnumCases();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/psi/elements/PhpClass", "getDirectImplementedInterfaces"));
    }

    @ApiStatus.Internal
    public static class PhpOverloadedMethods {
        public static final PhpOverloadedMethods EMPTY = new PhpOverloadedMethods(ContainerUtil.emptyList());
        private final Collection<? extends Method> myMethods;
        private final boolean myFromMixin;

        private PhpOverloadedMethods(Collection<? extends Method> methods) {
            this(methods, false);
        }

        private PhpOverloadedMethods(Collection<? extends Method> methods, boolean mixin) {
            this.myMethods = methods;
            this.myFromMixin = mixin;
        }

        public @Unmodifiable @NotNull Collection<Method> getMethods() {
            Collection<Method> collection = Collections.unmodifiableCollection(this.myMethods);
            if (collection == null) {
                PhpOverloadedMethods.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Nullable
        public Method getAny() {
            return (Method)ContainerUtil.getFirstItem(this.myMethods);
        }

        public boolean isEmpty() {
            return this.myMethods.isEmpty();
        }

        @NotNull
        public PhpOverloadedMethods filter(@NotNull Predicate<? super Method> predicate) {
            if (predicate == null) {
                PhpOverloadedMethods.$$$reportNull$$$0(1);
            }
            PhpOverloadedMethods phpOverloadedMethods = PhpOverloadedMethods.from(ContainerUtil.filter(this.myMethods, predicate::test)).fromMixin(this.isFromMixin());
            if (phpOverloadedMethods == null) {
                PhpOverloadedMethods.$$$reportNull$$$0(2);
            }
            return phpOverloadedMethods;
        }

        public boolean isFromMixin() {
            return this.myFromMixin;
        }

        @NotNull
        public static PhpOverloadedMethods from(Collection<? extends Method> methods) {
            return methods.isEmpty() ? EMPTY : new PhpOverloadedMethods(methods);
        }

        public static PhpOverloadedMethods fromMethods(Collection<PhpOverloadedMethods> values) {
            if (values.size() == 1) {
                return (PhpOverloadedMethods)ContainerUtil.getFirstItem(values);
            }
            PhpOverloadedMethods res = PhpOverloadedMethods.from(values.stream().flatMap(m -> m.getMethods().stream()).collect(Collectors.toSet()));
            return PhpOverloadedMethods.updateWithMixin(values, res);
        }

        private static PhpOverloadedMethods updateWithMixin(Collection<PhpOverloadedMethods> values, PhpOverloadedMethods res) {
            return res.fromMixin(!values.isEmpty() && ContainerUtil.all(values, PhpOverloadedMethods::isFromMixin));
        }

        @NotNull
        public PhpOverloadedMethods fromMixin(boolean value) {
            return new PhpOverloadedMethods(this.myMethods, value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/PhpClass$PhpOverloadedMethods";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/PhpClass$PhpOverloadedMethods";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filter";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static enum PhpDynamicFieldInitPlace {
        CONSTRUCTOR,
        PHPUNIT_SETUP,
        PHPUNIT_SETUP_BEFORE_CLASS,
        DYNAMIC;

    }
}

