/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.Namespace;
import com.jetbrains.php.lang.parser.parsing.Statement;
import com.jetbrains.php.lang.parser.parsing.classes.ClassDeclaration;
import com.jetbrains.php.lang.parser.parsing.functions.Function;
import com.jetbrains.php.lang.parser.parsing.statements.EchoStatement;
import java.util.function.Predicate;

public final class StatementList {
    public static void parseFast(PhpPsiBuilder builder) {
        IElementType t;
        PsiBuilder.Marker statementList = builder.mark();
        int balance = 0;
        while ((t = builder.getTokenType()) != null) {
            if (t == PhpTokenTypes.chLBRACE || t == PhpTokenTypes.DOLLAR_LBRACE) {
                ++balance;
            } else if (t == PhpTokenTypes.chRBRACE && (--balance == 0 || balance < 0)) break;
            builder.advanceLexer();
        }
        builder.match(PhpTokenTypes.chRBRACE);
        statementList.collapse((IElementType)PhpElementTypes.GROUP_STATEMENT);
    }

    public static void parseAccurate(PhpPsiBuilder builder, TokenSet whereToStop) {
        PsiBuilder.Marker statementList = builder.mark();
        StatementList.parseAccurate(builder, b -> whereToStop.contains(b.getTokenType()), statementList);
    }

    static void parseAccurate(PhpPsiBuilder builder, Predicate<PhpPsiBuilder> toStop, PsiBuilder.Marker statementList) {
        if (!toStop.test(builder)) {
            while (true) {
                IElementType tokenType;
                int previous = builder.getCurrentOffset();
                if (!StatementList.parseTopStatement(builder) && (tokenType = builder.getTokenType()) != null) {
                    builder.error(PhpFrontBackBundle.message("parsing.error.unexpected.token", tokenType));
                    builder.advanceLexer();
                }
                if (builder.eof() || toStop.test(builder)) break;
                if (previous != builder.getCurrentOffset()) continue;
                builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
                builder.advanceLexer();
            }
        }
        statementList.done(PhpElementTypes.NON_LAZY_GROUP_STATEMENT);
    }

    public static void parseBlockDeep(PhpPsiBuilder builder) {
        boolean braced = builder.compareAndEat(PhpTokenTypes.chLBRACE);
        while (!builder.eof()) {
            IElementType tokenType;
            if (braced && builder.compareAndEat(PhpTokenTypes.chRBRACE)) {
                braced = false;
                if (builder.eof()) {
                    return;
                }
            }
            int previous = builder.getCurrentOffset();
            if (!StatementList.parseTopStatement(builder) && (tokenType = builder.getTokenType()) != null) {
                builder.error(PhpFrontBackBundle.message("parsing.error.unexpected.token", tokenType));
                builder.advanceLexer();
            }
            if (previous != builder.getCurrentOffset()) continue;
            builder.error(PhpParserErrors.unexpected(builder.getTokenType()));
            builder.advanceLexer();
        }
        if (braced) {
            builder.match(PhpTokenTypes.chRBRACE);
        }
    }

    static boolean parseTopStatement(PhpPsiBuilder builder) {
        IElementType parsed = PhpElementTypes.EMPTY_INPUT;
        if (builder.compare(PhpTokenTypes.PHP_OPENING_TAG)) {
            builder.advanceLexer();
        } else if (builder.compareAndEat(PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
            PsiBuilder.Marker echo = builder.mark();
            parsed = EchoStatement.parse(builder, true);
            echo.done(PhpElementTypes.ECHO);
        }
        if (parsed == PhpElementTypes.EMPTY_INPUT) {
            parsed = Function.parse(builder, false);
        }
        if (parsed == PhpElementTypes.EMPTY_INPUT) {
            parsed = Namespace.parseDeclaration(builder);
        }
        if (parsed == PhpElementTypes.EMPTY_INPUT) {
            parsed = Namespace.parseUse(builder);
        }
        if (parsed == PhpElementTypes.EMPTY_INPUT) {
            parsed = ClassDeclaration.parse(builder);
        }
        if (parsed == PhpElementTypes.EMPTY_INPUT && !builder.attributesSupported() && builder.getTokenType() == PhpTokenTypes.ATTRIBUTE_START) {
            StatementList.remapAttributePartToLineComment(builder);
            parsed = PhpTokenTypes.LINE_COMMENT;
        }
        if (parsed == PhpElementTypes.EMPTY_INPUT && !builder.eof()) {
            parsed = Statement.parse(builder);
        }
        while (builder.compareAndEat(PhpTokenTypes.PHP_CLOSING_TAG)) {
            builder.compareAndEat(PhpTokenTypes.PHP_OPENING_TAG);
        }
        return parsed != PhpElementTypes.EMPTY_INPUT;
    }

    private static void remapAttributePartToLineComment(PhpPsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        while (!builder.endOfLineRawToken()) {
            builder.advanceLexer();
        }
        mark.collapse(PhpTokenTypes.LINE_COMMENT);
    }

    private static boolean endOfLineComment(CharSequence tokenText) {
        return "\n".contentEquals(tokenText) || "\r".contentEquals(tokenText) || "?>".contentEquals(tokenText);
    }
}

