/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.ParserPart;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpParserErrors;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;

public final class ListParsingHelper {
    public static int parseCommaDelimitedExpressionWithLeadExpr(PhpPsiBuilder builder, ParserPart next, boolean eatFollowComma) {
        return ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, next.parse(builder), next, PhpTokenTypes.opCOMMA, eatFollowComma, false);
    }

    public static int parseCommaDelimitedExpressionWithLeadExpr(PhpPsiBuilder builder, IElementType first, ParserPart next, boolean eatFollowComma) {
        return ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, first, next, PhpTokenTypes.opCOMMA, eatFollowComma, false);
    }

    public static int parseCommaDelimitedExpressionWithLeadExpr(PhpPsiBuilder builder, IElementType first, ParserPart next, boolean eatFollowComma, boolean allowEmptyExpression) {
        return ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, first, next, PhpTokenTypes.opCOMMA, eatFollowComma, allowEmptyExpression);
    }

    public static int parseDelimitedExpressionWithLeadExpr(PhpPsiBuilder builder, IElementType first, ParserPart next, IElementType delimiter, boolean eatFollowComma, boolean allowEmptyExpression) {
        return ListParsingHelper.parseDelimitedExpressionWithLeadExpr(builder, first, next, TokenSet.create((IElementType[])new IElementType[]{delimiter}), eatFollowComma, allowEmptyExpression);
    }

    public static int parseDelimitedExpressionWithLeadExpr(PhpPsiBuilder builder, IElementType first, ParserPart next, TokenSet delimiter, boolean eatFollowComma, boolean allowEmptyExpression) {
        if (first == PhpElementTypes.EMPTY_INPUT) {
            if (builder.compare(delimiter)) {
                if (!allowEmptyExpression) {
                    builder.error(PhpParserErrors.getExpressionExpectedMessage());
                }
            } else {
                return 0;
            }
        }
        int count = 1;
        PsiBuilder.Marker beforeLastCommaMarker = builder.mark();
        while (builder.compareAndEat(delimiter)) {
            if (next.parse(builder) != PhpElementTypes.EMPTY_INPUT || allowEmptyExpression) {
                ++count;
                beforeLastCommaMarker.drop();
                beforeLastCommaMarker = builder.mark();
                continue;
            }
            if (builder.compare(delimiter)) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
                continue;
            }
            if (!eatFollowComma) {
                builder.error(PhpParserErrors.getExpressionExpectedMessage());
                continue;
            }
            count = -1;
        }
        if (!eatFollowComma) {
            beforeLastCommaMarker.rollbackTo();
        } else {
            beforeLastCommaMarker.drop();
        }
        return count;
    }
}

