/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.lexer.managers;

import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.lexer._PhpLexer;
import com.jetbrains.php.lang.lexer.managers.ReadingManager;
import java.io.IOException;

public class HeredocManager
extends ReadingManager {
    private final Stack<String> heredocIDs = new Stack();

    public static IElementType tryHeredocStart(_PhpLexer lexer) throws IOException {
        String id;
        String text = lexer.yytext().toString();
        if (text.startsWith(id = lexer.getHdManager().getHeredocID())) {
            String label = text.substring(0, id.length());
            lexer.yypushback(text.length() - id.length());
            if (label.equals(id)) {
                lexer.sManager.toPreviousState();
                return PhpTokenTypes.HEREDOC_END;
            }
        }
        lexer.yypushback(lexer.yylength());
        lexer.yybegin(12);
        return lexer.advance();
    }

    public static IElementType tryHeredocBody(_PhpLexer lexer) {
        int eatResult = lexer.getHdManager().eat();
        if (eatResult == 0) {
            lexer.sManager.toPreviousState();
            lexer.zzMarkedPos += lexer.getHdManager().heredocIndentLength + lexer.getHdManager().getHeredocID().length();
            lexer.getHdManager().heredocIDs.pop();
            return PhpTokenTypes.HEREDOC_END;
        }
        if (eatResult == -1) {
            char point = lexer.zzBuffer.charAt(lexer.zzMarkedPos);
            char end = point == 'x' ? (char)'9' : (point >= '0' && point <= '7' ? (char)'7' : '\u0000');
            ++lexer.zzMarkedPos;
            if (end > '\u0000') {
                do {
                    ++lexer.zzMarkedPos;
                } while ((point = lexer.zzBuffer.charAt(lexer.zzMarkedPos)) <= end && point >= '0');
            }
            return PhpTokenTypes.ESCAPE_SEQUENCE;
        }
        if (eatResult < 0) {
            throw new RuntimeException(String.valueOf(lexer.zzBuffer) + "@@@" + lexer.zzCurrentPos);
        }
        lexer.zzMarkedPos += eatResult - 1;
        return PhpTokenTypes.HEREDOC_CONTENTS;
    }

    public HeredocManager(_PhpLexer lexer) {
        super(lexer);
    }

    public void start() {
        String heredocID;
        if ((heredocID = heredocID.substring((heredocID = this.lexer.yytext().toString()).charAt(0) == '<' ? 3 : 4).trim()).charAt(0) == '\"') {
            heredocID = heredocID.substring(1, heredocID.length() - 1);
        }
        this.heredocIDs.push((Object)heredocID);
        this.lexer.sManager.toState(16);
    }

    public void setCurrentTagName(String heredocID) {
        this.heredocIDs.push((Object)heredocID);
    }

    @Override
    public String getHeredocID() {
        return (String)this.heredocIDs.peek();
    }

    public int eat() {
        int pos = 0;
        while (this.canReadAt(pos) && !this.checkForEndDelimiter(pos)) {
            if (this.checkForExprSubstitution(pos)) {
                return pos > 0 ? pos : -3;
            }
            if (this.checkForVariable(pos)) {
                return pos > 0 ? pos : -4;
            }
            if (this.checkForNewLine(pos) && pos > 2000) {
                return pos;
            }
            ++pos;
        }
        return pos > 0 ? pos : 0;
    }

    @Override
    public void reset() {
        super.reset();
    }
}

