/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.highlighter;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.lexer.PhpWithOptionalOpenTagLexer;
import org.jetbrains.annotations.Nullable;

public abstract class BasicPhpEditorHighlighterProvider
implements EditorHighlighterProvider {
    @Nullable
    protected Lexer getBaseLexer(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (BasicPhpEditorHighlighterProvider.isInjected(virtualFile) || virtualFile == null) {
            return new PhpWithOptionalOpenTagLexer();
        }
        return null;
    }

    protected static boolean isInjected(VirtualFile virtualFile) {
        if (virtualFile instanceof LightVirtualFile) {
            LightVirtualFile lightVirtualFile = (LightVirtualFile)virtualFile;
            Language language = lightVirtualFile.getLanguage();
            Boolean injectedFragment = (Boolean)virtualFile.getUserData(PhpFileType.INJECTED_FRAGMENT);
            return injectedFragment == Boolean.TRUE || language != null && language.isKindOf((Language)PhpLanguage.INJECTABLE_INSTANCE);
        }
        return false;
    }
}

