/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui;

import com.intellij.DynamicBundle;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.codeStyle.CommenterForm;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpFrontBackBundle;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.PhpNameStyle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class PhpGenerationCodeStylePanel
extends CodeStyleAbstractPanel {
    private JPanel myMainPanel;
    private JPanel myVariableNamingStylePanel;
    private JRadioButton myMixedRadioButton;
    private JRadioButton myCamelCaseRadioButton;
    private JRadioButton mySnakeCaseRadioButton;
    private JBScrollPane myScrollPane;
    private JPanel myOptionsPanel;
    private JPanel myDefaultFieldsVisibilityPanel;
    private JRadioButton myPrivateVisibilityRadioButton;
    private JRadioButton myProtectedVisibilityRadioButton;
    private JRadioButton myPublicVisibilityRadioButton;
    private JPanel myCodeCommentingPanel;
    private JRadioButton myGettersFirstRadioButton;
    private JRadioButton mySettersFirstRadioButton;
    private JPanel myGettersSettersPanel;
    private JRadioButton myAccessorsCamelCaseRadioButton;
    private JRadioButton myAccessorsSnakeCaseRadioButton;
    private CommenterForm myCommenterForm;

    protected PhpGenerationCodeStylePanel(CodeStyleSettings settings) {
        super(settings);
        this.$$$setupUI$$$();
        ButtonGroup variableNamingStyleButtonGroup = new ButtonGroup();
        variableNamingStyleButtonGroup.add(this.myMixedRadioButton);
        variableNamingStyleButtonGroup.add(this.myCamelCaseRadioButton);
        variableNamingStyleButtonGroup.add(this.mySnakeCaseRadioButton);
        this.myVariableNamingStylePanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpFrontBackBundle.message("variable.naming.style.panel", new Object[0])));
        ButtonGroup defaultFieldsVisibilityButtonGroup = new ButtonGroup();
        defaultFieldsVisibilityButtonGroup.add(this.myPrivateVisibilityRadioButton);
        defaultFieldsVisibilityButtonGroup.add(this.myProtectedVisibilityRadioButton);
        defaultFieldsVisibilityButtonGroup.add(this.myPublicVisibilityRadioButton);
        this.myDefaultFieldsVisibilityPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpFrontBackBundle.message("fields.default.visibility.panel", new Object[0])));
        ButtonGroup gettersSettersOrderingPanelButtonGroup = new ButtonGroup();
        gettersSettersOrderingPanelButtonGroup.add(this.myGettersFirstRadioButton);
        gettersSettersOrderingPanelButtonGroup.add(this.mySettersFirstRadioButton);
        this.myGettersSettersPanel.setBorder(IdeBorderFactory.createTitledBorder((String)PhpFrontBackBundle.message("getters.setters.style", new Object[0])));
        ButtonGroup gettersSettersNamingStylePanelButtonGroup = new ButtonGroup();
        gettersSettersNamingStylePanelButtonGroup.add(this.myAccessorsCamelCaseRadioButton);
        gettersSettersNamingStylePanelButtonGroup.add(this.myAccessorsSnakeCaseRadioButton);
        this.myScrollPane.setMinimumSize(new Dimension(this.myOptionsPanel.getPreferredSize().width + this.myScrollPane.getVerticalScrollBar().getPreferredSize().width + 5, -1));
        this.myScrollPane.setPreferredSize(this.myScrollPane.getMinimumSize());
    }

    protected int getRightMargin() {
        return 80;
    }

    protected EditorHighlighter createHighlighter(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(0);
        }
        return EditorHighlighterFactory.getInstance().createEditorHighlighter((VirtualFile)new LightVirtualFile("a.php"), scheme, null);
    }

    @NotNull
    protected FileType getFileType() {
        PhpFileType phpFileType = PhpFileType.INSTANCE;
        if (phpFileType == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(1);
        }
        return phpFileType;
    }

    protected String getPreviewText() {
        return "";
    }

    public void apply(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(2);
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpCodeStyleSettings.VARIABLE_NAMING_STYLE = this.getVariableNamingStyle();
        phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY = this.getFieldsDefaultVisibility();
        phpCodeStyleSettings.GETTERS_SETTERS_ORDER_STYLE = this.getGettersSettersOrderStyle();
        phpCodeStyleSettings.GETTERS_SETTERS_NAMING_STYLE = this.getGettersSettersNamingStyle();
        this.myCommenterForm.apply(settings);
    }

    public boolean isModified(CodeStyleSettings settings) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        return phpCodeStyleSettings.VARIABLE_NAMING_STYLE != this.getVariableNamingStyle() || phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY != this.getFieldsDefaultVisibility() || phpCodeStyleSettings.GETTERS_SETTERS_ORDER_STYLE != this.getGettersSettersOrderStyle() || phpCodeStyleSettings.GETTERS_SETTERS_NAMING_STYLE != this.getGettersSettersNamingStyle() || this.myCommenterForm.isModified(settings);
    }

    @NotNull
    private PhpNameStyle.Style getVariableNamingStyle() {
        PhpNameStyle.Style style = this.myCamelCaseRadioButton.isSelected() ? PhpNameStyle.Style.CAMEL_CASE : (this.mySnakeCaseRadioButton.isSelected() ? PhpNameStyle.Style.SNAKE_CASE : PhpNameStyle.Style.MIXED);
        if (style == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(3);
        }
        return style;
    }

    @NotNull
    private PhpModifier.Access getFieldsDefaultVisibility() {
        if (this.myPrivateVisibilityRadioButton.isSelected()) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpGenerationCodeStylePanel.$$$reportNull$$$0(4);
            }
            return access;
        }
        if (this.myProtectedVisibilityRadioButton.isSelected()) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpGenerationCodeStylePanel.$$$reportNull$$$0(5);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PUBLIC;
        if (access == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(6);
        }
        return access;
    }

    private PhpCodeStyleSettings.GettersSettersOrderStyle getGettersSettersOrderStyle() {
        if (this.myGettersFirstRadioButton.isSelected()) {
            return PhpCodeStyleSettings.GettersSettersOrderStyle.GETTERS_FIRST;
        }
        return PhpCodeStyleSettings.GettersSettersOrderStyle.SETTERS_FIRST;
    }

    private PhpNameStyle.Style getGettersSettersNamingStyle() {
        if (this.myAccessorsSnakeCaseRadioButton.isSelected()) {
            return PhpNameStyle.Style.SNAKE_CASE;
        }
        return PhpNameStyle.Style.CAMEL_CASE;
    }

    public JComponent getPanel() {
        return this.myMainPanel;
    }

    protected void resetImpl(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(7);
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        this.myMixedRadioButton.setSelected(phpCodeStyleSettings.VARIABLE_NAMING_STYLE == PhpNameStyle.Style.MIXED);
        this.myCamelCaseRadioButton.setSelected(phpCodeStyleSettings.VARIABLE_NAMING_STYLE == PhpNameStyle.Style.CAMEL_CASE);
        this.mySnakeCaseRadioButton.setSelected(phpCodeStyleSettings.VARIABLE_NAMING_STYLE == PhpNameStyle.Style.SNAKE_CASE);
        this.myPrivateVisibilityRadioButton.setSelected(phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY == PhpModifier.Access.PRIVATE);
        this.myProtectedVisibilityRadioButton.setSelected(phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY == PhpModifier.Access.PROTECTED);
        this.myPublicVisibilityRadioButton.setSelected(phpCodeStyleSettings.FIELDS_DEFAULT_VISIBILITY == PhpModifier.Access.PUBLIC);
        this.myGettersFirstRadioButton.setSelected(phpCodeStyleSettings.GETTERS_SETTERS_ORDER_STYLE == PhpCodeStyleSettings.GettersSettersOrderStyle.GETTERS_FIRST);
        this.mySettersFirstRadioButton.setSelected(phpCodeStyleSettings.GETTERS_SETTERS_ORDER_STYLE == PhpCodeStyleSettings.GettersSettersOrderStyle.SETTERS_FIRST);
        this.myAccessorsSnakeCaseRadioButton.setSelected(phpCodeStyleSettings.GETTERS_SETTERS_NAMING_STYLE == PhpNameStyle.Style.SNAKE_CASE);
        this.myAccessorsCamelCaseRadioButton.setSelected(phpCodeStyleSettings.GETTERS_SETTERS_NAMING_STYLE == PhpNameStyle.Style.CAMEL_CASE);
        this.myCommenterForm.reset(settings);
    }

    public Language getDefaultLanguage() {
        return PhpLanguage.INSTANCE;
    }

    private void createUIComponents() {
        this.myCommenterForm = new CommenterForm((Language)PhpLanguage.INSTANCE);
        this.myCodeCommentingPanel = this.myCommenterForm.getCommenterPanel();
    }

    @NlsContexts.TabTitle
    @NotNull
    protected String getTabTitle() {
        String string = PhpFrontBackBundle.message("php.generation.code.style.title", new Object[0]);
        if (string == null) {
            PhpGenerationCodeStylePanel.$$$reportNull$$$0(8);
        }
        return string;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JPanel jPanel2;
        JRadioButton jRadioButton8;
        JRadioButton jRadioButton9;
        JRadioButton jRadioButton10;
        JPanel jPanel3;
        JPanel jPanel4;
        JBScrollPane jBScrollPane;
        JPanel jPanel5;
        this.createUIComponents();
        this.myMainPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myOptionsPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jBScrollPane.setViewportView(jPanel4);
        this.myVariableNamingStylePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("variable.naming.style.panel"), (int)0, (int)0, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySnakeCaseRadioButton = jRadioButton10 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton10, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("variable.naming.style.snake.case"));
        jPanel6.add((Component)jRadioButton10, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCamelCaseRadioButton = jRadioButton9 = new JRadioButton();
        jRadioButton9.setSelected(false);
        this.$$$loadButtonText$$$(jRadioButton9, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("variable.naming.style.camel.case"));
        jPanel6.add((Component)jRadioButton9, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMixedRadioButton = jRadioButton8 = new JRadioButton();
        jRadioButton8.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton8, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("variable.naming.style.mixed"));
        jPanel6.add((Component)jRadioButton8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDefaultFieldsVisibilityPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("fields.default.visibility.panel"), (int)0, (int)0, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myPrivateVisibilityRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton7, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("fields.default.visibility.private"));
        jPanel7.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedVisibilityRadioButton = jRadioButton6 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton6, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("fields.default.visibility.protected"));
        jPanel7.add((Component)jRadioButton6, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPublicVisibilityRadioButton = jRadioButton5 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton5, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("fields.default.visibility.public"));
        jPanel7.add((Component)jRadioButton5, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel7.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = this.myCodeCommentingPanel;
        jPanel4.add((Component)jPanel8, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myGettersSettersPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel, new GridConstraints(2, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("getters.setters.style"), (int)0, (int)0, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myGettersFirstRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton4, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("getters.setters.getters.first"));
        jPanel9.add((Component)jRadioButton4, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySettersFirstRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("getters.setters.setters.first"));
        jPanel9.add((Component)jRadioButton3, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAccessorsCamelCaseRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("variable.naming.style.camel.case"));
        jPanel9.add((Component)jRadioButton2, new GridConstraints(1, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAccessorsSnakeCaseRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("variable.naming.style.snake.case"));
        jPanel9.add((Component)jRadioButton, new GridConstraints(1, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("getters.setters.order"));
        jPanel9.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpFrontBackBundle", PhpGenerationCodeStylePanel.class).getString("getters.setters.naming.style"));
        jPanel9.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/ui/PhpGenerationCodeStylePanel";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/ui/PhpGenerationCodeStylePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNamingStyle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldsDefaultVisibility";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resetImpl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 6, 8 -> new IllegalStateException(string);
        };
    }
}

