/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.arrangement;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.ArrangementSectionDetector;
import com.intellij.psi.codeStyle.arrangement.ArrangementSettings;
import com.intellij.psi.codeStyle.arrangement.ArrangementUtil;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.Stack;
import com.jetbrains.php.arrangement.PhpArrangementInfo;
import com.jetbrains.php.arrangement.PhpElementArrangementEntry;
import com.jetbrains.php.arrangement.PhpSectionArrangementEntry;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.BasicPhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpArrangementVisitor
extends PhpElementVisitor {
    @Nullable
    private final Document myDocument;
    private final Collection<? extends TextRange> myRanges;
    @Nullable
    private ArrangementSectionDetector mySectionProcessor;
    private final PhpArrangementInfo myInfo;
    private final Stack<PhpElementArrangementEntry> myProcessingEntries;

    public PhpArrangementVisitor(@Nullable ArrangementSettings settings, @NotNull PhpArrangementInfo info, @Nullable Document document, @NotNull Collection<? extends TextRange> ranges) {
        if (info == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(1);
        }
        this.myProcessingEntries = new Stack();
        this.myInfo = info;
        this.myDocument = document;
        this.myRanges = ranges;
        if (settings != null) {
            this.mySectionProcessor = new ArrangementSectionDetector(document, settings, data -> {
                PhpElementArrangementEntry parent = this.getCurrentElement();
                TextRange range = data.getTextRange();
                PhpSectionArrangementEntry entry = new PhpSectionArrangementEntry((ArrangementEntry)parent, data.getToken(), data.getText(), range.getStartOffset(), range.getEndOffset(), true);
                this.myInfo.registerEntry(data.getElement(), entry, parent);
            });
        }
    }

    @Override
    public void visitPhpFile(PhpFile phpFile) {
        phpFile.acceptChildren(this);
    }

    @Override
    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        groupStatement.acceptChildren(this);
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(2);
        }
        if (this.mySectionProcessor != null) {
            this.mySectionProcessor.processComment(comment);
        }
    }

    @Override
    public void visitPhpNamespace(PhpNamespace namespace) {
        this.processContainerEntry(namespace, StdArrangementTokens.EntryType.NAMESPACE, null);
    }

    @Override
    public void visitPhpClass(PhpClass clazz) {
        ArrangementSettingsToken type = clazz.isInterface() ? StdArrangementTokens.EntryType.INTERFACE : (clazz.isTrait() ? StdArrangementTokens.EntryType.TRAIT : StdArrangementTokens.EntryType.CLASS);
        HashSet<ArrangementSettingsToken> modifiers = new HashSet<ArrangementSettingsToken>();
        if (clazz.isFinal()) {
            modifiers.add(StdArrangementTokens.Modifier.FINAL);
        }
        if (clazz.isAbstract()) {
            modifiers.add(StdArrangementTokens.Modifier.ABSTRACT);
        }
        this.processContainerEntry(clazz, type, modifiers);
    }

    private void processContainerEntry(@NotNull PhpNamedElement element, @NotNull ArrangementSettingsToken type, @Nullable Set<ArrangementSettingsToken> modifiers) {
        PhpElementArrangementEntry parent;
        PhpElementArrangementEntry entry;
        if (element == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(3);
        }
        if (type == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(4);
        }
        if ((entry = this.createEntry(element, type, parent = this.getCurrentElement(), !this.hasSectionComment(element))) != null) {
            this.myInfo.registerEntry((PsiElement)element, entry, parent);
            if (modifiers != null && !modifiers.isEmpty()) {
                entry.addModifiers(modifiers);
            }
            this.myProcessingEntries.push((Object)entry);
            element.acceptChildren(this);
            this.myProcessingEntries.pop();
        }
    }

    @Nullable
    private PhpElementArrangementEntry getCurrentElement() {
        return this.myProcessingEntries.empty() ? null : (PhpElementArrangementEntry)((Object)this.myProcessingEntries.peek());
    }

    @Override
    public void visitPhpMethod(Method method) {
        PhpElementArrangementEntry parent;
        ArrangementSettingsToken type = method.getMethodType(false) == Method.MethodType.CONSTRUCTOR ? StdArrangementTokens.EntryType.CONSTRUCTOR : StdArrangementTokens.EntryType.METHOD;
        PhpElementArrangementEntry entry = this.createEntry(method, type, parent = this.getCurrentElement(), !this.hasSectionComment(method));
        if (entry != null) {
            PhpArrangementVisitor.addModifiers(method, entry);
            this.myInfo.registerMethod(method, entry, parent);
        }
    }

    @Override
    public void visitPhpElement(PhpPsiElement element) {
        this.processElementList(element, PhpElementTypes.CLASS_FIELDS, StdArrangementTokens.EntryType.FIELD);
        this.processElementList(element, PhpElementTypes.CLASS_CONSTANTS, StdArrangementTokens.EntryType.CONST);
    }

    private void processElementList(@NotNull PhpPsiElement element, @NotNull IElementType type, @NotNull ArrangementSettingsToken entryType) {
        List fields;
        if (element == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(5);
        }
        if (type == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(6);
        }
        if (entryType == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(7);
        }
        if (BasicPhpPsiUtil.isOfType((PsiElement)element, type) && !(fields = BasicPhpPsiUtil.getChildren((PsiElement)element, Field.INSTANCEOF)).isEmpty()) {
            Field field = (Field)fields.get(0);
            PhpElementArrangementEntry parent = this.getCurrentElement();
            PhpElementArrangementEntry entry = this.createEntry(field, element, element.getTextRange(), entryType, parent, !this.hasSectionComment(field));
            if (entry != null) {
                PhpArrangementVisitor.addModifiers(field, entry);
                this.myInfo.registerField(field, entry, parent);
            }
        }
    }

    protected boolean hasSectionComment(@NotNull PhpNamedElement element) {
        PhpDocComment comment;
        if (element == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(8);
        }
        return (comment = element.getDocComment()) != null && this.mySectionProcessor != null && this.mySectionProcessor.processComment((PsiComment)comment);
    }

    private static void addModifiers(@NotNull PhpClassMember member, @NotNull PhpElementArrangementEntry entry) {
        if (member == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(9);
        }
        if (entry == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(10);
        }
        Set<ArrangementSettingsToken> modifiers = PhpArrangementVisitor.collectModifiers(member.getModifier());
        entry.addModifiers(modifiers);
    }

    private static Set<ArrangementSettingsToken> collectModifiers(@NotNull PhpModifier phpModifier) {
        if (phpModifier == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(11);
        }
        HashSet<ArrangementSettingsToken> modifiers = new HashSet<ArrangementSettingsToken>();
        if (phpModifier.isAbstract()) {
            modifiers.add(StdArrangementTokens.Modifier.ABSTRACT);
        }
        if (phpModifier.isFinal()) {
            modifiers.add(StdArrangementTokens.Modifier.FINAL);
        }
        if (phpModifier.isStatic()) {
            modifiers.add(StdArrangementTokens.Modifier.STATIC);
        }
        modifiers.add(switch (phpModifier.getAccess()) {
            default -> throw new IncompatibleClassChangeError();
            case PhpModifier.Access.PUBLIC -> StdArrangementTokens.Modifier.PUBLIC;
            case PhpModifier.Access.PROTECTED -> StdArrangementTokens.Modifier.PROTECTED;
            case PhpModifier.Access.PRIVATE -> StdArrangementTokens.Modifier.PRIVATE;
        });
        return modifiers;
    }

    @Nullable
    private PhpElementArrangementEntry createEntry(@NotNull PhpNamedElement element, @NotNull ArrangementSettingsToken type, @Nullable PhpElementArrangementEntry parent, boolean withPhpDoc) {
        if (element == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(12);
        }
        if (type == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(13);
        }
        return this.createEntry(element, element, element.getTextRange(), type, parent, withPhpDoc);
    }

    @Nullable
    private PhpElementArrangementEntry createEntry(@NotNull PhpNamedElement element, @NotNull PhpPsiElement elementToRearrange, @NotNull TextRange range, @NotNull ArrangementSettingsToken type, @Nullable PhpElementArrangementEntry parent, boolean withPhpDoc) {
        if (element == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(14);
        }
        if (elementToRearrange == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(15);
        }
        if (range == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(16);
        }
        if (type == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(17);
        }
        if (!this.isInRanges(range)) {
            return null;
        }
        PhpDocComment docComment = withPhpDoc ? element.getDocComment() : null;
        TextRange rangeWithPhpDoc = docComment == null ? range : docComment.getTextRange().union(range);
        TextRange expandedRange = this.myDocument == null ? rangeWithPhpDoc : ArrangementUtil.expandToLineIfPossible((TextRange)rangeWithPhpDoc, (Document)this.myDocument);
        PsiElement prevSibling = BasicPhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)elementToRearrange, true);
        if (prevSibling == docComment && docComment != null) {
            prevSibling = BasicPhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)docComment, true);
        }
        int startOffset = prevSibling != null && expandedRange.intersects(prevSibling.getTextRange()) ? prevSibling.getTextRange().getEndOffset() : expandedRange.getStartOffset();
        Object nextSibling = BasicPhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)elementToRearrange, true);
        int endOffset = nextSibling != null && expandedRange.intersects(nextSibling.getTextRange()) ? nextSibling.getTextRange().getStartOffset() : expandedRange.getEndOffset();
        return new PhpElementArrangementEntry((ArrangementEntry)parent, type, element.getName(), startOffset, endOffset, true);
    }

    private boolean isInRanges(@NotNull TextRange range) {
        if (range == null) {
            PhpArrangementVisitor.$$$reportNull$$$0(18);
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.contains(range)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpModifier";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToRearrange";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/arrangement/PhpArrangementVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitComment";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processContainerEntry";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processElementList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "hasSectionComment";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addModifiers";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "collectModifiers";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "createEntry";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isInRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

