/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.phpunit.coverage;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.remote.phpunit.coverage.PhpRemoteCoverageResultManager;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpSshCoverageResultManager
extends PhpRemoteCoverageResultManager {
    private static final Logger LOG = Logger.getInstance(PhpSshCoverageResultManager.class);
    private String myLocalCoverage;
    private String myTargetCoverage;

    public PhpSshCoverageResultManager(@NotNull PhpRemoteSdkAdditionalData sdkData) {
        if (sdkData == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(0);
        }
        super(sdkData);
    }

    @NotNull
    public String processCoverageFile(@NotNull String localPath) {
        if (localPath == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(1);
        }
        this.myLocalCoverage = localPath;
        this.myTargetCoverage = this.mySdkData.getHelpersPath() + "/" + FileUtil.sanitizeFileName((String)PathUtil.getFileName((String)localPath));
        String string = this.myTargetCoverage;
        if (string == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void copyFromRemote(@NotNull Project project) {
        if (project == null) {
            PhpSshCoverageResultManager.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)this.myTargetCoverage) || StringUtil.isEmpty((String)this.myLocalCoverage)) {
            LOG.warn("Can not find target coverage report file: [" + this.myLocalCoverage + ", " + this.myTargetCoverage + "]");
            return;
        }
        List<PathMappingSettings.PathMapping> filesToTransfer = List.of(new PathMappingSettings.PathMapping(this.myLocalCoverage, this.myTargetCoverage));
        try {
            RemoteCredentials credentials = this.mySdkData.getRemoteCredentials(project, false);
            new PhpRemoteTransfer(project, null, credentials, (RemoteSdkProperties)this.mySdkData).downloadFromRemote(filesToTransfer);
        }
        catch (ExecutionException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/phpunit/coverage/PhpSshCoverageResultManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/phpunit/coverage/PhpSshCoverageResultManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processCoverageFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processCoverageFile";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "copyFromRemote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

