/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.CredentialsManager;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpInterpreterDecorator;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.config.phpInfo.PhpInfo;
import com.jetbrains.php.remote.PhpRemoteProcessManager;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.interpreter.PhpRemoteInterpreterDecorator;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkTypeData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import com.jetbrains.php.settingsSummary.util.PhpCredentialsContribution;
import com.jetbrains.plugins.remotesdk.RemoteCredentialsProducer;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSdkAdditionalData
extends PhpSdkAdditionalData
implements RemoteSdkAdditionalData {
    private static final Condition<PhpSdkAdditionalData> ourRemoteSdkFilter = data -> data instanceof PhpRemoteSdkAdditionalData;
    private static final String HELPERS_DIR = ".phpstorm_helpers";
    private final RemoteConnectionCredentialsWrapper myWrapper;
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;
    private PhpRemoteSdkTypeData myTypeData;
    private boolean myInitialized;

    public PhpRemoteSdkAdditionalData() {
        this.myWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
        this.myTypeData = null;
    }

    public PhpRemoteSdkAdditionalData(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(0);
        }
        this.myWrapper = new RemoteConnectionCredentialsWrapper();
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(HELPERS_DIR);
        this.myTypeData = null;
        this.setInterpreterPath(interpreterPath);
    }

    private RemoteCredentialsProducer getProducer() {
        if (PhpRemoteInterpreterManager.getInstance() == null) {
            throw new IllegalStateException(PhpRemoteInterpreterManager.getRemoteInterpreterPluginIsDisabledErrorMessage());
        }
        return new RemoteCredentialsProducer(this.myWrapper);
    }

    @NotNull
    public static Condition<PhpSdkAdditionalData> getRemoteSdkFilter() {
        Condition<PhpSdkAdditionalData> condition = ourRemoteSdkFilter;
        if (condition == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(1);
        }
        return condition;
    }

    @NotNull
    public RemoteConnectionCredentialsWrapper connectionCredentials() {
        RemoteConnectionCredentialsWrapper remoteConnectionCredentialsWrapper = this.myWrapper;
        if (remoteConnectionCredentialsWrapper == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(2);
        }
        return remoteConnectionCredentialsWrapper;
    }

    public <C> void setCredentials(Key<C> key, C credentials) {
        this.myWrapper.setCredentials(key, credentials);
    }

    public CredentialsType<?> getRemoteConnectionType() {
        return this.myWrapper.getRemoteConnectionType();
    }

    public void switchOnConnectionType(CredentialsCase ... cases) {
        this.myWrapper.switchType(cases);
    }

    @NotNull
    public String getRemoteConnectionPresentableName() {
        final Ref result = new Ref();
        this.switchOnConnectionType(new LanguageCaseCollector<PhpCredentialsContribution>(){

            protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                result.set((Object)languageContribution.getConnectionPresentableName(credentials));
            }
        }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
        String string = (String)result.get();
        if (string == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public String getPathToExecutable(String homePath) {
        return this.getInterpreterPath();
    }

    @NotNull
    public String suggestName(final @Nullable PhpInfo phpInfo) {
        final Ref result = new Ref();
        this.switchOnConnectionType(new LanguageCaseCollector<PhpCredentialsContribution>(){

            protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                result.set((Object)languageContribution.suggestName(credentials, phpInfo));
            }
        }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
        String string = !result.isNull() ? (String)result.get() : PhpRemoteSdkBundle.message("remote.0", super.suggestName(phpInfo));
        if (string == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    @Nullable
    public String getScratchesPath() {
        String path = this.getHelpersPath();
        return path != null ? PathUtil.getParentPath((String)path) + "/scratches" : null;
    }

    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @NotNull
    public PathMappingSettings getPathMappings() {
        PathMappingSettings pathMappingSettings = this.myRemoteSdkProperties.getPathMappings();
        if (pathMappingSettings == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(5);
        }
        return pathMappingSettings;
    }

    public void setPathMappings(@Nullable PathMappingSettings pathMappings) {
        this.myRemoteSdkProperties.setPathMappings(pathMappings);
    }

    @Nullable
    public PhpRemoteSdkTypeData getTypeData() {
        return this.myTypeData;
    }

    public void setTypeData(@Nullable PhpRemoteSdkTypeData typeData) {
        this.myTypeData = typeData;
    }

    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    public void setSdkId(String sdkId) {
        throw new IllegalStateException("sdkId in this class is constructed based on fields, so it can't be set");
    }

    public String getSdkId() {
        return PhpRemoteSdkAdditionalData.constructSdkID(this.myWrapper, this.myRemoteSdkProperties);
    }

    private static String constructSdkID(RemoteConnectionCredentialsWrapper wrapper, RemoteSdkPropertiesHolder properties) {
        return wrapper.getId() + properties.getInterpreterPath();
    }

    public boolean connectionEquals(PhpRemoteSdkAdditionalData data) {
        return this.myWrapper.equals((Object)data.myWrapper);
    }

    @NotNull
    public String constructFullInterpreterPath(@NotNull String exePath) {
        if (exePath == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(6);
        }
        String string = this.myWrapper.getId() + exePath;
        if (string == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isValid() {
        return this.myRemoteSdkProperties.isValid();
    }

    public void setValid(boolean valid) {
        this.myRemoteSdkProperties.setValid(valid);
    }

    public boolean isRunAsRootViaSudo() {
        return this.myRemoteSdkProperties.isRunAsRootViaSudo();
    }

    public void setRunAsRootViaSudo(boolean runAsRootViaSudo) {
        this.myRemoteSdkProperties.setRunAsRootViaSudo(runAsRootViaSudo);
    }

    public RemoteCredentials getRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return this.getProducer().getRemoteCredentials(project, allowSynchronousInteraction);
    }

    public void produceRemoteCredentials(@Nullable Project project, boolean allowSynchronousInteraction, @NotNull Consumer<RemoteCredentials> consumer) {
        if (consumer == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(8);
        }
        this.getProducer().produceRemoteCredentials(project, allowSynchronousInteraction, consumer);
    }

    public Object getRemoteSdkDataKey() {
        return this.myWrapper.getConnectionKey();
    }

    @NlsContexts.DialogMessage
    @Nullable
    public String validate(final @Nullable Project project, @Nullable JComponent parent) {
        final Ref error = new Ref(null);
        this.myWrapper.switchType(new LanguageCaseCollector<PhpCredentialsContribution>(){

            protected void processLanguageContribution(PhpCredentialsContribution languageContribution, Object credentials) {
                error.set((Object)languageContribution.validate(project, credentials));
            }
        }.collectCases(PhpCredentialsContribution.class, new CredentialsCase[0]));
        if (StringUtil.isNotEmpty((String)((String)error.get()))) {
            return (String)error.get();
        }
        if (StringUtil.isEmpty((String)this.getInterpreterPath())) {
            return PhpBundle.message((String)"validation.value.is.not.specified.or.invalid", (Object[])new Object[]{PhpRemoteSdkBundle.message("remote.interpreter.path", new Object[0])});
        }
        return super.validate(project, parent);
    }

    @NotNull
    public PhpInterpreterDecorator getDecorator() {
        PhpRemoteInterpreterDecorator phpRemoteInterpreterDecorator = PhpRemoteInterpreterDecorator.INSTANCE;
        if (phpRemoteInterpreterDecorator == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(9);
        }
        return phpRemoteInterpreterDecorator;
    }

    public void save(@NotNull Element rootElement) {
        if (rootElement == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(10);
        }
        super.save(rootElement);
        Element data = new Element("remote_data");
        this.myRemoteSdkProperties.save(data);
        PhpRemoteSdkAdditionalData.saveTypeData(this, data);
        rootElement.addContent(data);
        this.myWrapper.save(data);
    }

    @NotNull
    public static PhpRemoteSdkAdditionalData loadRemote(@NotNull Sdk interpreter, @Nullable Element element, @Nullable Project project) {
        if (interpreter == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(11);
        }
        String path = interpreter.getHomePath();
        assert (path != null);
        PhpRemoteSdkAdditionalData data = new PhpRemoteSdkAdditionalData(RemoteSdkProperties.getInterpreterPathFromFullPath((String)path));
        PhpRemoteSdkAdditionalData.load((PhpSdkAdditionalData)data, (Element)element);
        if (element != null) {
            Element child = element.getChild("remote_data");
            CredentialsManager.getInstance().loadCredentials(path, child, (RemoteSdkAdditionalData)data);
            CredentialsManager.updateOutdatedSdk((RemoteSdkAdditionalData)data, (Project)project);
            RemoteSdkUtil.fullyLoadCredentials((SdkAdditionalData)data, (Project)project);
            if (child != null) {
                data.myRemoteSdkProperties.load(child);
                data.myTypeData = PhpRemoteSdkAdditionalData.loadTypeData(data, child);
            }
        }
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = data;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(12);
        }
        return phpRemoteSdkAdditionalData;
    }

    private static void saveTypeData(PhpRemoteSdkAdditionalData data, Element element) {
        try {
            Element type = PhpRemoteProcessManager.getInstance(data).saveDataType("type_data", data);
            if (type != null) {
                element.addContent(type);
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Nullable
    private static PhpRemoteSdkTypeData loadTypeData(PhpRemoteSdkAdditionalData data, Element element) {
        try {
            Element type = element.getChild("type_data");
            return PhpRemoteProcessManager.getInstance(data).loadDataType(data, type);
        }
        catch (ExecutionException executionException) {
            return null;
        }
    }

    @NotNull
    public PhpRemoteSdkAdditionalData copy() {
        PhpRemoteSdkAdditionalData copy = new PhpRemoteSdkAdditionalData();
        this.copyToRemote(copy);
        PhpRemoteSdkAdditionalData phpRemoteSdkAdditionalData = copy;
        if (phpRemoteSdkAdditionalData == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(13);
        }
        return phpRemoteSdkAdditionalData;
    }

    public void copyToRemote(@NotNull PhpRemoteSdkAdditionalData copy) {
        if (copy == null) {
            PhpRemoteSdkAdditionalData.$$$reportNull$$$0(14);
        }
        this.copyTo(copy);
        copy.myInitialized = this.myInitialized;
        this.myRemoteSdkProperties.copyTo((RemoteSdkProperties)copy.myRemoteSdkProperties);
        copy.setCredentials(this.myWrapper.getRemoteConnectionType().getCredentialsKey(), this.myWrapper.getCredentials());
        copy.setTypeData(this.getTypeData());
    }

    public String toPresentablePath() {
        return "[" + this.myWrapper.getId() + "]:" + this.myRemoteSdkProperties.getInterpreterPath();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PhpRemoteSdkAdditionalData data = (PhpRemoteSdkAdditionalData)((Object)o);
        return Objects.equals(this.myWrapper, data.myWrapper) && Objects.equals(this.myRemoteSdkProperties, data.myRemoteSdkProperties) && Objects.equals(this.myTypeData, data.myTypeData);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myWrapper, this.myRemoteSdkProperties, this.myTypeData);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 7, 9, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/interpreter/PhpRemoteSdkAdditionalData";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/PhpRemoteSdkAdditionalData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteSdkFilter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "connectionCredentials";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteConnectionPresentableName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathMappings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFullInterpreterPath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRemote";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "constructFullInterpreterPath";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "produceRemoteCredentials";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadRemote";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyToRemote";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 7, 9, 12, 13 -> new IllegalStateException(string);
        };
    }
}

