/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.StringPattern;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.interpreters.PhpSdkAdditionalData;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.php.run.remote.PhpRemoteInterpreterManager;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteInterpreterPathDetector {
    @Nullable
    private final JComponent myMainPanel;
    private final Project myProject;
    private static final String EXECUTION_TITLE = "Searching for PHP interpreter...";
    private static final StringPattern UNIX_FILE_PATH_PATTERN = StandardPatterns.string().matches("(^(?=\\/))((\\/)+(?=[^/\u0000])[^/\u0000]+)*$");

    public PhpRemoteInterpreterPathDetector(@NotNull Project project, @Nullable JComponent panel) {
        if (project == null) {
            PhpRemoteInterpreterPathDetector.$$$reportNull$$$0(0);
        }
        this.myMainPanel = panel;
        this.myProject = project;
    }

    @NotNull
    public String findInterpreterPath(@NotNull PhpRemoteSdkAdditionalData data) throws ExecutionException, InterruptedException {
        ProcessOutput processOutput;
        String output;
        if (data == null) {
            PhpRemoteInterpreterPathDetector.$$$reportNull$$$0(1);
        }
        if (PhpRemoteInterpreterPathDetector.isValidUnixPath(output = (processOutput = this.executeCommand(data, "which", "php")).getStdout().trim())) {
            String string = output;
            if (string == null) {
                PhpRemoteInterpreterPathDetector.$$$reportNull$$$0(2);
            }
            return string;
        }
        throw new ExecutionException(PhpBundle.message((String)"failed.to.find.valid.interpreter.path", (Object[])new Object[0]));
    }

    @NotNull
    protected ProcessOutput executeCommand(@NotNull PhpRemoteSdkAdditionalData data, String ... command) throws ExecutionException, InterruptedException {
        PhpRemoteInterpreterManager manager;
        if (data == null) {
            PhpRemoteInterpreterPathDetector.$$$reportNull$$$0(3);
        }
        if (command == null) {
            PhpRemoteInterpreterPathDetector.$$$reportNull$$$0(4);
        }
        if ((manager = PhpRemoteInterpreterManager.getInstance()) == null) {
            throw new IllegalStateException("Remote interpreter manager is null");
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(command);
        ProcessOutput processOutput = manager.getProcessOutput(this.myProject, (PhpSdkAdditionalData)data, commandLine, EXECUTION_TITLE, this.myMainPanel);
        if (processOutput == null) {
            PhpRemoteInterpreterPathDetector.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    protected static boolean isValidUnixPath(String unixPathCandidate) {
        return UNIX_FILE_PATH_PATTERN.accepts((Object)unixPathCandidate);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/remote/interpreter/PhpRemoteInterpreterPathDetector";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/remote/interpreter/PhpRemoteInterpreterPathDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findInterpreterPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "executeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findInterpreterPath";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

