/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkProperties;
import com.intellij.remote.ui.RemoteSdkUpdatedCallback;
import com.intellij.util.ui.EDT;
import com.jetbrains.php.config.interpreters.PhpSdkHelpersManager;
import com.jetbrains.php.remote.PhpRemoteSdkBundle;
import com.jetbrains.php.remote.PhpRemoteTransfer;
import com.jetbrains.php.remote.interpreter.PhpRemoteSdkAdditionalData;
import com.jetbrains.plugins.remotesdk.RemoteSdkUtil;
import javax.swing.JComponent;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpRemoteSshHelpersManager
extends PhpSdkHelpersManager {
    private static final RemoteSdkUpdatedCallback EMPTY_CALLBACK = sdkProperties -> {};
    private final PhpRemoteSdkAdditionalData mySdkData;

    public PhpRemoteSshHelpersManager(PhpRemoteSdkAdditionalData sdkData) {
        this.mySdkData = sdkData;
    }

    @Nullable
    public String getHelperScript(@NotNull String scriptName, @NotNull Class<?> resourceHolder) {
        if (scriptName == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(0);
        }
        if (resourceHolder == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(1);
        }
        return StringUtil.isEmpty((String)this.mySdkData.getHelpersPath()) ? null : this.mySdkData.getHelpersPath() + "/" + scriptName;
    }

    public void update(final @NotNull Project project, @Nullable JComponent parentComponent) throws ExecutionException, InterruptedException {
        if (project == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(2);
        }
        final RemoteCredentials credentials = this.mySdkData.getRemoteCredentials(project, false);
        final String title = PhpRemoteSdkBundle.message("validation.ssh.connecting.to.remote.host.title", credentials.getHost());
        final RemoteSdkUpdatedCallback callback = StringUtil.isEmpty((String)this.mySdkData.getHelpersPath()) ? EMPTY_CALLBACK : null;
        try {
            if (EDT.isCurrentThreadEdt()) {
                this.testConnectionAndCreateHelpersPath(project, credentials, title, callback);
            } else {
                new Task.Backgroundable(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        try {
                            PhpRemoteSshHelpersManager.this.testConnectionAndCreateHelpersPath(project, credentials, title, callback);
                        }
                        catch (ExecutionException | FileSystemException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/remote/PhpRemoteSshHelpersManager$1", "run"));
                    }
                }.queue();
            }
        }
        catch (FileSystemException e) {
            throw new ExecutionException((Throwable)e);
        }
        catch (Exception e) {
            String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData);
            throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", fullInterpreterPath));
        }
        if (StringUtil.isEmpty((String)this.mySdkData.getHelpersPath())) {
            String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData);
            throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", fullInterpreterPath));
        }
        new PhpRemoteTransfer(project, parentComponent, credentials, (RemoteSdkProperties)this.mySdkData).uploadHelpers();
    }

    private void testConnectionAndCreateHelpersPath(@NotNull Project project, RemoteCredentials credentials, @Nls String title, RemoteSdkUpdatedCallback callback) throws FileSystemException, ExecutionException {
        if (project == null) {
            PhpRemoteSshHelpersManager.$$$reportNull$$$0(3);
        }
        if (!RemoteSdkUtil.testConnectionAndCreateHelpersPath((Project)project, (RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData, (String)title, (RemoteSdkUpdatedCallback)callback)) {
            String fullInterpreterPath = RemoteSdkProperties.getFullInterpreterPath((RemoteCredentials)credentials, (RemoteSdkProperties)this.mySdkData);
            throw new ExecutionException(PhpRemoteSdkBundle.message("validation.ssh.can.not.connect.to.remote.host", fullInterpreterPath));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceHolder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/remote/PhpRemoteSshHelpersManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHelperScript";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "testConnectionAndCreateHelpersPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

