/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.ui.ColorPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class ConfigUI
extends JPanel {
    private JCheckBox scrollToFirst;
    private JCheckBox useContextAtCursor;
    private JCheckBox highlightStartTagOnly;
    private JCheckBox addErrorStripe;
    private ColorPanel chooseHighlight;
    private ColorPanel chooseContext;

    public ConfigUI(Config configuration) {
        this.init();
        this.setConfig(configuration);
    }

    private void init() {
        this.setLayout(new BorderLayout());
        JPanel c = this;
        this.scrollToFirst = new JCheckBox(XPathBundle.message("settings.scroll.first.hit.into.visible.area", new Object[0]));
        this.useContextAtCursor = new JCheckBox(XPathBundle.message("settings.use.node.at.cursor.as.context.node", new Object[0]));
        this.useContextAtCursor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigUI.this.stateChanged();
            }
        });
        this.highlightStartTagOnly = new JCheckBox(XPathBundle.message("settings.highlight.only.start.tag.instead.of.whole.tag.content", new Object[0]));
        this.addErrorStripe = new JCheckBox(XPathBundle.message("settings.add.error.stripe.markers.for.each.result", new Object[0]));
        JPanel settings = new JPanel(new BorderLayout());
        settings.setBorder(IdeBorderFactory.createTitledBorder((String)XPathBundle.message("settings.settings", new Object[0])));
        ConfigUI configUI = c;
        c = new JPanel(new BorderLayout());
        configUI.add((Component)c, "North");
        c.add((Component)settings, "North");
        settings.add((Component)this.scrollToFirst, "North");
        JPanel jPanel = settings;
        settings = new JPanel(new BorderLayout());
        jPanel.add((Component)settings, "South");
        settings.add((Component)this.useContextAtCursor, "North");
        JPanel jPanel2 = settings;
        settings = new JPanel(new BorderLayout());
        jPanel2.add((Component)settings, "South");
        settings.add((Component)this.highlightStartTagOnly, "North");
        JPanel jPanel3 = settings;
        settings = new JPanel(new BorderLayout());
        jPanel3.add((Component)settings, "South");
        settings.add((Component)this.addErrorStripe, "North");
        settings.add((Component)new JPanel(new BorderLayout()), "South");
        JPanel colors = new JPanel(new GridBagLayout());
        colors.setBorder(IdeBorderFactory.createTitledBorder((String)XPathBundle.message("settings.colors", new Object[0])));
        JPanel jPanel4 = c;
        c = new JPanel(new BorderLayout());
        jPanel4.add((Component)c, "South");
        c.add((Component)colors, "North");
        JBInsets emptyInsets = JBInsets.emptyInsets();
        JBInsets cpInsets = JBUI.insetsLeft((int)8);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, (Insets)emptyInsets, 0, 0);
        colors.add((Component)new JLabel(XPathBundle.message("settings.highlight.color", new Object[0])), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        this.chooseHighlight = new ColorPanel();
        constraints.insets = cpInsets;
        colors.add((Component)this.chooseHighlight, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.insets = emptyInsets;
        colors.add((Component)new JLabel(XPathBundle.message("settings.context.node.color", new Object[0])), constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets = cpInsets;
        this.chooseContext = new ColorPanel();
        colors.add((Component)this.chooseContext, constraints);
    }

    @NotNull
    public Config getConfig() {
        Config config = new Config();
        config.setHighlightStartTagOnly(this.highlightStartTagOnly.isSelected());
        config.setUseContextAtCursor(this.useContextAtCursor.isSelected());
        config.setScrollToFirst(this.scrollToFirst.isSelected());
        config.setAddErrorStripe(this.addErrorStripe.isSelected());
        config.getAttributes().setBackgroundColor(this.chooseHighlight.getSelectedColor());
        if (this.useContextAtCursor.isSelected()) {
            config.getContextAttributes().setBackgroundColor(this.chooseContext.getSelectedColor());
        }
        Config config2 = config;
        if (config2 == null) {
            ConfigUI.$$$reportNull$$$0(0);
        }
        return config2;
    }

    public void setConfig(@NotNull Config configuration) {
        if (configuration == null) {
            ConfigUI.$$$reportNull$$$0(1);
        }
        this.scrollToFirst.setSelected(configuration.isScrollToFirst());
        this.highlightStartTagOnly.setSelected(configuration.isHighlightStartTagOnly());
        this.useContextAtCursor.setSelected(configuration.isUseContextAtCursor());
        this.addErrorStripe.setSelected(configuration.isAddErrorStripe());
        this.chooseHighlight.setSelectedColor(configuration.getAttributes().getBackgroundColor());
        this.chooseContext.setSelectedColor(configuration.getContextAttributes().getBackgroundColor());
        this.stateChanged();
    }

    private void stateChanged() {
        this.chooseContext.setEnabled(this.useContextAtCursor.isSelected());
    }

    public static void main(String[] args) {
        JFrame test = new JFrame("Config test");
        test.setDefaultCloseOperation(3);
        JPanel comp = new JPanel(new BorderLayout());
        comp.add((Component)new ConfigUI(new Config()), "Center");
        test.getContentPane().add(comp);
        test.setSize(450, 450);
        test.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/xpathView/ui/ConfigUI";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/xpathView/ui/ConfigUI";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

