/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.net.IOExceptionDialog;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.quickfix.DownloadManager;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class DownloadResourceFix
implements LocalQuickFix {
    private final String myLocation;

    public DownloadResourceFix(String location) {
        this.myLocation = location;
    }

    @NotNull
    public String getFamilyName() {
        String string = XPathBundle.message("intention.family.name.download.external.resource", new Object[0]);
        if (string == null) {
            DownloadResourceFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            DownloadResourceFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            DownloadResourceFix.$$$reportNull$$$0(2);
        }
        boolean tryAgain = true;
        DownloadManager.DownloadException[] ex = new DownloadManager.DownloadException[1];
        Runnable runnable = () -> {
            ProgressIndicator progress = ProgressManager.getInstance().getProgressIndicator();
            MyDownloadManager downloadManager = new MyDownloadManager(project, progress);
            try {
                downloadManager.fetch(this.myLocation);
            }
            catch (DownloadManager.DownloadException e) {
                ex[0] = e;
            }
        };
        while (tryAgain) {
            tryAgain = false;
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, XPathBundle.message("progress.title.downloading.resource", new Object[0]), true, project)) continue;
            if (ex[0] == null) break;
            tryAgain = IOExceptionDialog.showErrorDialog((String)XPathBundle.message("dialog.title.error.during.download", new Object[0]), (String)XPathBundle.message("text.error.downloading", ex[0].getLocation()));
            ex[0] = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/quickfix/DownloadResourceFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/quickfix/DownloadResourceFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private static class MyDownloadManager
    extends DownloadManager {
        MyDownloadManager(Project project, ProgressIndicator progress) {
            super(project, progress);
        }

        private static void processReferences(XmlTag[] subTags, Set<? super String> list) {
            for (XmlTag xmlTag : subTags) {
                String href = xmlTag.getAttributeValue("href");
                if (href == null || !href.startsWith("http://")) continue;
                list.add(href);
            }
        }

        @Override
        protected boolean isAccepted(PsiFile psiFile) {
            return XsltSupport.isXsltFile(psiFile);
        }

        @Override
        protected Set<String> getResourceDependencies(PsiFile psiFile) {
            XmlTag rootTag;
            XmlDocument document = ((XmlFile)psiFile).getDocument();
            if (document != null && (rootTag = document.getRootTag()) != null) {
                HashSet<String> list = new HashSet<String>();
                MyDownloadManager.processReferences(rootTag.findSubTags("include", "http://www.w3.org/1999/XSL/Transform"), list);
                MyDownloadManager.processReferences(rootTag.findSubTags("import", "http://www.w3.org/1999/XSL/Transform"), list);
                return list;
            }
            return Collections.emptySet();
        }
    }
}

